/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel;

import com.ontotext.metamodel.SchemaManagerMonitor;
import com.ontotext.metamodel.SchemaUpdateConsumer;
import com.ontotext.metamodel.SomlSchemaManager;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.concurrent.MonitoredOperationInfo;
import com.ontotext.soaas.common.concurrent.Timer;
import graphql.schema.GraphQLSchema;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MinimalSomlSchemaManagerMonitor
implements SomlSchemaManager,
SchemaManagerMonitor {
    protected final SomlSchemaManager delegate;
    private final Map<String, Entry> operations = new ConcurrentHashMap<String, Entry>();

    public MinimalSomlSchemaManagerMonitor(SomlSchemaManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<MonitoredOperationInfo> getSummaryInfo() {
        Map<Operations, List<Entry>> byOperation = this.operations.values().stream().collect(Collectors.groupingBy(Entry::getOp));
        return byOperation.entrySet().stream().map(this.toSummaryEntry()).collect(Collectors.toList());
    }

    @Override
    public List<MonitoredOperationInfo> getFullInfo() {
        return this.operations.values().stream().map(Entry::toSomlManagerInfo).collect(Collectors.toList());
    }

    @NotNull
    private Function<Map.Entry<Operations, List<Entry>>, MonitoredOperationInfo> toSummaryEntry() {
        return entry -> {
            String ids = ((List)entry.getValue()).stream().map(Entry::getId).filter(Objects::nonNull).distinct().collect(Collectors.joining(", "));
            long longestDuration = ((List)entry.getValue()).stream().mapToLong(Entry::getDuration).max().orElse(0L);
            List subOperations = ((List)entry.getValue()).stream().map(Entry::getSubOperations).flatMap(Collection::stream).collect(Collectors.toList());
            return new MonitoredOperationInfo(((Operations)((Object)((Object)entry.getKey()))).toString(), ids, Timer.fixed((long)longestDuration), Integer.valueOf(((List)entry.getValue()).size()), null, () -> subOperations);
        };
    }

    @Override
    public SomlSchemaManager.SchemaInfo create(String schema) throws SomlStoreException {
        return this.monitorWithEx(this.extractId(schema), Operations.CREATE, () -> this.delegate.create(schema));
    }

    @Override
    public SomlSchemaManager.SchemaInfo update(String id, String schema) throws SomlStoreException {
        return this.monitorWithEx(id, Operations.UPDATE, () -> this.delegate.update(id, schema));
    }

    @Override
    public boolean bind(String id) throws SomlStoreException {
        return this.monitorWithEx(id, Operations.BIND, () -> this.delegate.bind(id));
    }

    @Override
    public Collection<String> getAll() throws UnreachableStoreException {
        return this.delegate.getAll();
    }

    @Override
    public Collection<String> getAll(int skip, int limit) throws UnreachableStoreException {
        return this.delegate.getAll(skip, limit);
    }

    @Override
    public Optional<String> get(String id) throws UnreachableStoreException {
        return this.delegate.get(id);
    }

    @Override
    public boolean contains(String id) throws UnreachableStoreException {
        return this.delegate.contains(id);
    }

    @Override
    public boolean remove(String id) throws UnreachableStoreException {
        return this.monitorWithEx(id, Operations.REMOVE, () -> this.delegate.remove(id));
    }

    @Override
    public void clearShaclSchema() {
        this.delegate.clearShaclSchema();
    }

    @Override
    public void setShaclTransactionMode(Boolean enable) {
        this.delegate.setShaclTransactionMode(enable);
    }

    @Override
    public boolean getShaclTransactionMode() {
        return this.delegate.getShaclTransactionMode();
    }

    @Override
    public int size() throws UnreachableStoreException {
        return this.delegate.size();
    }

    @Override
    public GraphQLSchema getGraphQlSchema() {
        return this.delegate.getGraphQlSchema();
    }

    @Override
    public SomlSchema getSomlSchema() {
        return this.delegate.getSomlSchema();
    }

    @Override
    public ShaclSchema getShaclSchema() {
        return this.delegate.getShaclSchema();
    }

    @Override
    public Object getJsonLdFrame(String query) {
        return this.delegate.getJsonLdFrame(query);
    }

    @Override
    public Map<String, Object> getJsonLdContext() {
        return this.delegate.getJsonLdContext();
    }

    @Override
    public void reload() {
        this.delegate.reload();
    }

    @Override
    public void registerSchemaCreateListener(SchemaUpdateConsumer consumer) {
        this.delegate.registerSchemaCreateListener(this.monitorListener(Operations.CREATE, consumer));
    }

    @Override
    public void registerSchemaChangeListener(SchemaUpdateConsumer consumer) {
        this.delegate.registerSchemaChangeListener(this.monitorListener(Operations.UPDATE, consumer));
    }

    @Override
    public void registerSchemaBindListener(SchemaUpdateConsumer consumer) {
        this.delegate.registerSchemaBindListener(this.monitorListener(Operations.BIND, consumer));
    }

    @Override
    public void registerSchemaRemovedListener(SchemaUpdateConsumer consumer) {
        this.delegate.registerSchemaRemovedListener(this.monitorListener(Operations.REMOVE, consumer));
    }

    @Override
    public Pair<OperationResponse, SomlSchema> validateSchema(String schema) {
        return this.delegate.validateSchema(schema);
    }

    @Override
    public Pair<OperationResponse, SomlSchema> validateSchema(String schema, boolean strict) {
        return this.delegate.validateSchema(schema, strict);
    }

    @Override
    public void validateSchemaBinding(SomlSchema somlSchema) {
        this.delegate.validateSchemaBinding(somlSchema);
    }

    @Override
    public boolean hasBoundSchema() throws UnreachableStoreException {
        return this.delegate.hasBoundSchema();
    }

    @Override
    public ShaclSchema revalidateShacl() {
        return this.delegate.revalidateShacl();
    }

    @Override
    public ShaclSchema rebindShacl() {
        return this.delegate.rebindShacl();
    }

    @Override
    public SomlSchemaManager useUnrestricted() {
        return this.delegate.useUnrestricted();
    }

    @Override
    public boolean rebindService() throws UnreachableStoreException {
        return this.delegate.rebindService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E> E monitor(String id, Operations op, Supplier<E> actualOp) {
        String key = this.operationBegin(id, op);
        try {
            E e = actualOp.get();
            return e;
        }
        finally {
            this.operationEnd(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E, S extends SomlStoreException> E monitorWithEx(String id, Operations op, SchemaOp<E, S> actualOp) throws S {
        String key = this.operationBegin(id, op);
        try {
            E e = actualOp.get();
            return e;
        }
        finally {
            this.operationEnd(key);
        }
    }

    protected SchemaUpdateConsumer monitorListener(Operations op, SchemaUpdateConsumer delegate) {
        return SchemaUpdateConsumer.of((SomlSchema schema) -> {
            String key = this.operationBegin(schema.getId(), op, delegate::getOperationInfo);
            try {
                delegate.accept(schema);
            }
            finally {
                this.operationEnd(key);
            }
        }, delegate::getOperationInfo);
    }

    protected String operationBegin(String id, Operations op) {
        return this.operationBegin(id, op, null);
    }

    protected String operationBegin(String id, Operations op, Supplier<List<MonitoredOperationInfo>> subOperations) {
        String key = this.createKey(op);
        this.operations.put(key, new Entry(id, op, subOperations));
        return key;
    }

    private String createKey(Operations op) {
        return Thread.currentThread().getName() + String.valueOf((Object)op) + System.currentTimeMillis();
    }

    protected void operationEnd(String key) {
        this.operations.remove(key);
    }

    String extractId(String schema) {
        if (schema == null) {
            return null;
        }
        return SomlSchemaParser.getId((String)schema);
    }

    public HealthResult runHealthCheck() {
        return this.delegate.runHealthCheck();
    }

    static enum Operations {
        CREATE,
        UPDATE,
        BIND,
        REMOVE,
        CONTAINS,
        CLEAR_SHACL,
        GET_GRAPHQL,
        GET_SOML,
        GET_SHACL,
        VALIDATE,
        VALIDATE_STRICT,
        VALIDATE_GRAPHQL,
        VALIDATE_SHACL,
        REBIND_SHACL,
        RELOAD,
        REBIND_SERVICE,
        HEALTH;

    }

    @FunctionalInterface
    static interface SchemaOp<E, S extends SomlStoreException> {
        public E get() throws S;
    }

    static class Entry {
        private final String id;
        private final Operations op;
        private final Timer timer;
        private final String thread;
        private final Supplier<List<MonitoredOperationInfo>> subOperation;

        Entry(String id, Operations op, Supplier<List<MonitoredOperationInfo>> subOperation) {
            this.id = id;
            this.op = op;
            this.subOperation = subOperation;
            this.timer = Timer.start();
            this.thread = Thread.currentThread().getName();
        }

        String getId() {
            return this.id;
        }

        Operations getOp() {
            return this.op;
        }

        long getDuration() {
            return this.timer.getDuration();
        }

        MonitoredOperationInfo toSomlManagerInfo() {
            return new MonitoredOperationInfo(this.op.toString(), this.id, this.timer, null, this.thread, this::getSubOperations);
        }

        List<MonitoredOperationInfo> getSubOperations() {
            List<MonitoredOperationInfo> subOperations = Collections.emptyList();
            if (this.subOperation != null) {
                subOperations = this.subOperation.get();
            }
            return subOperations;
        }
    }
}

