/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel;

import com.ontotext.graphql.parser.GraphQlQueryParser;
import com.ontotext.metamodel.SchemaUpdateConsumer;
import com.ontotext.metamodel.SomlSchemaIdManager;
import com.ontotext.metamodel.SomlSchemaManager;
import com.ontotext.metamodel.generator.jsonld.JsonLdFrameGenerator;
import com.ontotext.metamodel.storage.MalformedSomlException;
import com.ontotext.metamodel.storage.SchemaBindingChanged;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.ServiceIdentity;
import com.ontotext.metamodel.storage.SomlBindException;
import com.ontotext.metamodel.storage.SomlNotFoundException;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorageUpdate;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnauthorizedStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaConverter;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.models.ValidatingException;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.query.Query;
import com.ontotext.models.query.QueryParser;
import com.ontotext.platform.SomlToGraphQlSchemaConverter;
import com.ontotext.platform.shacl.generator.SomlToShaclShapesConverter;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.exceptions.ShaclBindException;
import com.ontotext.sparql.ShaclManager;
import com.ontotext.validator.SomlSchemaValidator;
import graphql.schema.GraphQLSchema;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSomlSchemaManager
implements SomlSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String VALIDATION_WARN_MSG = "soml.validations.warnings";
    static final String SOML_CANNOT_CONVERT_SHACL = "soml.cannot.convert.shacl";
    private final SomlSchemaParser schemaParser = new SomlSchemaParser();
    private final String name;
    private final SomlSchemaIdManager idManager;
    private final ShaclManager shaclManager;
    private final SomlSchemaStorage schemaStorage;
    private final SomlSchemaConverter<GraphQLSchema> grahqlSchemaConverter;
    private final SomlSchemaConverter<ShaclSchema> shaclSchemaConverter;
    private ManagerState managerState;
    private List<SchemaUpdateConsumer> schemaCreateListeners = new CopyOnWriteArrayList<SchemaUpdateConsumer>();
    private List<SchemaUpdateConsumer> schemaUpdateListeners = new CopyOnWriteArrayList<SchemaUpdateConsumer>();
    private List<SchemaUpdateConsumer> schemaBindListeners = new CopyOnWriteArrayList<SchemaUpdateConsumer>();
    private List<SchemaUpdateConsumer> schemaRemoveListeners = new CopyOnWriteArrayList<SchemaUpdateConsumer>();
    private ServiceIdentity applicationNameProvider;

    public DefaultSomlSchemaManager(SomlSchemaIdManager idManager, SomlSchemaStorage schemaStorage, ServiceIdentity applicationNameProvider) {
        this("default", idManager, null, schemaStorage, (SomlSchemaConverter<GraphQLSchema>)new SomlToGraphQlSchemaConverter(), (SomlSchemaConverter<ShaclSchema>)new SomlToShaclShapesConverter(), applicationNameProvider);
    }

    public DefaultSomlSchemaManager(String name, SomlSchemaIdManager idManager, ShaclManager shaclManager, SomlSchemaStorage schemaStorage, SomlSchemaConverter<GraphQLSchema> graphqlSchemaConverter, SomlSchemaConverter<ShaclSchema> shaclSchemaConverter, ServiceIdentity applicationNameProvider) {
        this.name = Objects.requireNonNull(name, "service name cannot be null");
        this.idManager = idManager;
        this.shaclManager = shaclManager;
        this.schemaStorage = schemaStorage;
        this.grahqlSchemaConverter = graphqlSchemaConverter;
        this.shaclSchemaConverter = shaclSchemaConverter;
        this.applicationNameProvider = applicationNameProvider;
        schemaStorage.registerListener(this.createUpdateListener());
        schemaStorage.registerBindListener(this.createBindListener());
    }

    @NotNull
    private Consumer<SchemaBindingChanged> createBindListener() {
        return event -> {
            if (event.isLocalEvent() || "rbac".equals(this.name) || "/soml/soml-rbac".equals(event.getSchemaId())) {
                return;
            }
            String schemaId = event.getSchemaId();
            if (schemaId != null) {
                try {
                    LOGGER.info("Received external event to change the bound schema to: {}", (Object)schemaId);
                    this.bind(schemaId, true);
                }
                catch (SomlStoreException sse) {
                    LOGGER.warn("Unable to change the binding schema to {} due to: ", (Object)schemaId, (Object)sse);
                }
            } else {
                LOGGER.info("Received external event to remove the bound schema");
                this.clearBoundSchemaIf(id -> true);
            }
        };
    }

    private Consumer<SomlSchemaStorageUpdate> createUpdateListener() {
        return update -> {
            SomlSchemaStorageUpdate.Type operation = update.getType();
            if (!operation.isSomlChange()) {
                return;
            }
            String updatedSchemaId = update.getId();
            LOGGER.info("[{}] Received schema change event: {} {}", new Object[]{this.name, operation, updatedSchemaId});
            DefaultSomlSchemaManager defaultSomlSchemaManager = this;
            synchronized (defaultSomlSchemaManager) {
                if (operation == SomlSchemaStorageUpdate.Type.DELETE) {
                    this.clearBoundSchemaIf(Predicate.isEqual(updatedSchemaId));
                } else if (operation == SomlSchemaStorageUpdate.Type.UPDATE) {
                    this.updateBoundSchemaIf(Predicate.isEqual(updatedSchemaId), update.getSoml());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SomlSchemaManager.SchemaInfo create(String schema) throws SomlStoreException {
        DefaultSomlSchemaManager defaultSomlSchemaManager = this;
        synchronized (defaultSomlSchemaManager) {
            Pair<OperationResponse, SomlSchema> result = this.validateSchema(schema);
            Optional<String> id = this.idManager.getId();
            SomlSchema somlSchema = (SomlSchema)result.getRight();
            SchemaEntity entity = new SchemaEntity(schema).setSomlSchema(somlSchema);
            String newId = this.schemaStorage.store(entity);
            LOGGER.info("[{}] Created schema: {}", (Object)this.name, (Object)newId);
            this.notifyListenerForCreatedSchema(somlSchema);
            if (id.filter(Predicate.isEqual(newId)).isPresent()) {
                this.clear();
                this.notifyListenerForUpdatedSchema(this.getSomlSchema());
            }
            OperationResponse operationResponse = (OperationResponse)result.getLeft();
            this.addSanitizingInfo(somlSchema, operationResponse);
            SomlSchemaManager.SchemaInfo schemaInfo = SomlSchemaManager.SchemaInfo.create(newId);
            schemaInfo.setMessages(operationResponse.getWarningMessages());
            schemaInfo.getMessages().addAll(operationResponse.getInfoMessages());
            return schemaInfo;
        }
    }

    private void addSanitizingInfo(SomlSchema somlSchema, OperationResponse operationResponse) {
        if (somlSchema.isSanitized()) {
            operationResponse.addInfo("The schema has been sanitized!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SomlSchemaManager.SchemaInfo update(String id, String schema) throws SomlStoreException {
        DefaultSomlSchemaManager defaultSomlSchemaManager = this;
        synchronized (defaultSomlSchemaManager) {
            LOGGER.info("[{}] Updating schema: {}", (Object)this.name, (Object)id);
            Pair<OperationResponse, SomlSchema> result = this.validateSchema(schema);
            SomlSchema somlSchema = (SomlSchema)result.getRight();
            this.validateSchemaBinding(somlSchema);
            if (this.hasBoundSchema() && this.shaclValidationIsEnabledForSchema(id)) {
                try {
                    this.shaclManager.reloadSchema((ShaclSchema)this.shaclSchemaConverter.convert(somlSchema));
                }
                catch (SomlConversionException ex) {
                    throw new InvalidSchemaException(ErrorMessages.get((String)SOML_CANNOT_CONVERT_SHACL, (Object[])new Object[]{ex.getMessage()}), (Throwable)ex);
                }
            }
            Optional<String> boundSchema = this.idManager.getId();
            SchemaEntity entity = new SchemaEntity(schema).setSomlSchema(somlSchema);
            String theOldSoml = this.schemaStorage.update(id, entity);
            if (boundSchema.filter(Predicate.isEqual(id)).isPresent()) {
                this.schemaStorage.registerSchemaService(id, this.getServiceAddress());
            }
            OperationResponse operationResponse = (OperationResponse)result.getLeft();
            this.addSanitizingInfo(somlSchema, operationResponse);
            SomlSchemaManager.SchemaInfo schemaInfo = SomlSchemaManager.SchemaInfo.create(id);
            schemaInfo.setPreviousSchema(theOldSoml);
            schemaInfo.setMessages(operationResponse.getWarningMessages());
            schemaInfo.getMessages().addAll(operationResponse.getInfoMessages());
            return schemaInfo;
        }
    }

    @NotNull
    private String getServiceAddress() {
        return this.applicationNameProvider.getServiceAddress();
    }

    private boolean shaclValidationIsEnabledForSchema(String id) {
        ShaclSchema schema;
        if (!this.isShaclConfigured()) {
            return false;
        }
        try {
            schema = this.useUnrestricted().getShaclSchema();
        }
        catch (SomlBindException sbe) {
            return false;
        }
        return null != schema && schema.getId().equals(id) && Boolean.TRUE.equals(schema.isEnabledAtTransactionLevel()) || null == schema && Boolean.TRUE.equals(this.shaclManager.isEnabled());
    }

    @Override
    public boolean bind(String id) throws SomlStoreException {
        return this.bind(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bind(String id, boolean forced) throws SomlStoreException {
        DefaultSomlSchemaManager defaultSomlSchemaManager = this;
        synchronized (defaultSomlSchemaManager) {
            if (!this.schemaStorage.get(id).isPresent()) {
                throw SomlNotFoundException.notFound(id);
            }
            LOGGER.info("[{}] Binding schema: {}", (Object)this.name, (Object)id);
            try {
                String serviceHostname = this.getServiceAddress();
                this.unregisterPreviousBoundSchema(id, serviceHostname);
                SomlSchema oldSchema = this.idManager.getId().map(this::getSchema).orElse(null);
                if (this.idManager.setId(id) || forced) {
                    if (oldSchema != null) {
                        this.notifyListenerForRemovedSchema(oldSchema);
                    }
                    this.reload();
                    this.schemaStorage.registerSchemaService(id, serviceHostname);
                    this.notifyListenerForBindSchema(this.getSomlSchema());
                    return true;
                }
                this.rebindService();
            }
            catch (PlatformConfigurationException pce) {
                LOGGER.warn("[{}] Encounter configuration error during bind operation. The service would not be accessible until resolved: {}", (Object)this.name, (Object)pce.getMessage());
                return true;
            }
            catch (RuntimeException rte) {
                LOGGER.warn("[{}] Unbinding schema {} due: {}", new Object[]{this.name, id, rte.getMessage()});
                this.idManager.getId().filter(Predicate.isEqual(id)).ifPresent(currentId -> this.resetDefaultSchema());
                throw rte;
            }
            return false;
        }
    }

    private void resetDefaultSchema() {
        try {
            this.idManager.clear();
        }
        catch (UnreachableStoreException use) {
            throw new IllegalStateException(use);
        }
    }

    private void unregisterPreviousBoundSchema(String id, String serviceHostname) throws SomlStoreException {
        Optional<String> boundId = this.idManager.getId().filter(Predicate.isEqual(id).negate());
        if (boundId.isPresent()) {
            String boundSchemaId = boundId.get();
            this.schemaStorage.deregisterSchemaService(boundSchemaId, serviceHostname);
        }
    }

    @Override
    public Collection<String> getAll() throws UnreachableStoreException {
        return this.schemaStorage.getAll().stream().map(SchemaEntity::getOriginalDefinition).toList();
    }

    @Override
    public Collection<String> getAll(int skip, int limit) throws UnreachableStoreException {
        return this.schemaStorage.getAll(skip, limit, null, false, true).stream().map(SchemaEntity::getOriginalDefinition).filter(Objects::nonNull).toList();
    }

    @Override
    public Optional<String> get(String id) throws UnreachableStoreException {
        return this.schemaStorage.get(id);
    }

    @Override
    public boolean contains(String id) throws UnreachableStoreException {
        return this.schemaStorage.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String id) throws UnreachableStoreException {
        LOGGER.info("[{}] Removing schema: {}", (Object)this.name, (Object)id);
        DefaultSomlSchemaManager defaultSomlSchemaManager = this;
        synchronized (defaultSomlSchemaManager) {
            if (this.schemaStorage.remove(id)) {
                this.clearBoundSchemaIf(id::equals);
                return true;
            }
            return false;
        }
    }

    @Override
    public void clearShaclSchema() {
        if (!this.isShaclConfigured()) {
            return;
        }
        String id = this.getSomlSchema().getId();
        if (!this.shaclManager.checkShaclEnabledForRepository()) {
            throw new ShaclBindException(ErrorMessages.get((String)"shacl.clear.repo.disabled"), ErrorCode.BAD_CONFIG_SHACL_NOT_ENABLED, 400);
        }
        if (!this.shaclSchemaConverter.isEnabled()) {
            throw new ShaclBindException(ErrorMessages.get((String)"shacl.clear.soaas.disabled"), ErrorCode.BAD_CONFIG_SHACL_NOT_ENABLED, 400);
        }
        LOGGER.info("[{}] Removing bound SHACL: {}", (Object)this.name, (Object)id);
        try {
            this.clearShacl();
        }
        catch (Exception ex) {
            throw new ShaclBindException(ErrorMessages.get((String)"shacl.clear.undefined.error", (Object[])new Object[]{ex.getMessage()}), ErrorCode.COULD_NOT_CLEAR_SHACL, 500);
        }
    }

    @Override
    public void setShaclTransactionMode(Boolean enable) {
        if (!this.isShaclConfigured()) {
            return;
        }
        LOGGER.info("Changing SHACL to: {}", (Object)(Boolean.TRUE.equals(enable) ? "enabled" : "disabled"));
        if (!this.shaclManager.isShaclRepo()) {
            throw new ShaclBindException(ErrorMessages.get((String)"shacl.clear.repo.disabled"), ErrorCode.BAD_CONFIG_SHACL_NOT_ENABLED, 400);
        }
        if (!this.shaclSchemaConverter.isEnabled()) {
            throw new ShaclBindException(ErrorMessages.get((String)"shacl.clear.soaas.disabled"), ErrorCode.BAD_CONFIG_SHACL_NOT_ENABLED, 400);
        }
        this.shaclManager.setInitialShaclMode(enable);
        try {
            if (this.hasBoundSchema()) {
                if (null == this.useUnrestricted().getShaclSchema()) {
                    LOGGER.warn("[{}] Trying to toggle SHACL validations, but the SHACL schema has been removed earlier.", (Object)this.name);
                    return;
                }
                this.useUnrestricted().getShaclSchema().setEnabledAtTransactionLevel(enable);
            }
        }
        catch (UnreachableStoreException use) {
            throw new PlatformConfigurationException("Could not connect to remote endpoint to change SHACL transaction mode: " + use.getMessage(), ErrorCode.SOML_STORE_UNREACHABLE);
        }
    }

    @Override
    public boolean getShaclTransactionMode() {
        return null != this.shaclManager && this.shaclManager.isEnabled() && this.shaclManager.getInitialShaclMode();
    }

    private void clearBoundSchemaIf(Predicate<String> condition) {
        try {
            this.idManager.getId().filter(condition).ifPresent(id -> {
                LOGGER.info("[{}] Bound schema {} has been deleted", (Object)this.name, id);
                SomlSchema oldSchema = this.getSomlSchema();
                this.resetDefaultSchema();
                this.clear();
                this.notifyListenerForRemovedSchema(oldSchema);
            });
        }
        catch (UnreachableStoreException use) {
            LOGGER.warn("Could not process event for schema unbound", (Throwable)use);
        }
    }

    private void updateBoundSchemaIf(Predicate<String> condition, String soml) {
        try {
            this.idManager.getId().filter(condition).ifPresent(id -> {
                LOGGER.info("[{}] Trying to update the bound schema {}", (Object)this.name, id);
                this.clear();
                try {
                    this.setStateForSchema(() -> this.schemaParser.parse(soml));
                    this.notifyListenerForUpdatedSchema(this.getSomlSchema());
                    LOGGER.info("[{}] Bound schema {} has been updated successfully", (Object)this.name, id);
                }
                catch (RuntimeException re) {
                    LOGGER.error("[{}] Failed to deploy the bound schema {} due to error: {}", new Object[]{this.name, id, re.getMessage()});
                }
            });
        }
        catch (UnreachableStoreException use) {
            LOGGER.warn("Could not handle event for schema update: {}", (Object)use.getMessage(), (Object)use);
        }
    }

    @Override
    public int size() throws UnreachableStoreException {
        return this.schemaStorage.size();
    }

    @Override
    public GraphQLSchema getGraphQlSchema() {
        return this.getState().getGraphQlSchema();
    }

    @Override
    public SomlSchema getSomlSchema() {
        return this.getState().getSomlSchema();
    }

    @Override
    public ShaclSchema getShaclSchema() {
        return this.getState().getShaclSchema();
    }

    @Override
    public Object getJsonLdFrame(String query) {
        return this.getState().getJsonLdFrame(query);
    }

    @Override
    public Map<String, Object> getJsonLdContext() {
        return this.getState().getJsonLdContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        DefaultSomlSchemaManager defaultSomlSchemaManager = this;
        synchronized (defaultSomlSchemaManager) {
            LOGGER.info("[{}] Reloading model...", (Object)this.name);
            this.clear();
            try {
                if (this.idManager.getId().isPresent()) {
                    this.getState();
                    LOGGER.info("[{}] Model reloaded!", (Object)this.name);
                } else {
                    LOGGER.info("[{}] No model is bound", (Object)this.name);
                }
            }
            catch (UnreachableStoreException use) {
                LOGGER.warn("Could not reload model due to communication problems", (Throwable)use);
            }
        }
    }

    @Override
    public void registerSchemaCreateListener(SchemaUpdateConsumer consumer) {
        this.schemaCreateListeners.add(consumer);
    }

    @Override
    public void registerSchemaChangeListener(SchemaUpdateConsumer consumer) {
        this.schemaUpdateListeners.add(consumer);
    }

    @Override
    public void registerSchemaBindListener(SchemaUpdateConsumer consumer) {
        this.schemaBindListeners.add(consumer);
    }

    @Override
    public void registerSchemaRemovedListener(SchemaUpdateConsumer consumer) {
        this.schemaRemoveListeners.add(consumer);
    }

    private void notifyListenerForCreatedSchema(SomlSchema updated) {
        this.schemaCreateListeners.forEach(consumer -> consumer.accept(updated));
    }

    private void notifyListenerForUpdatedSchema(SomlSchema updated) {
        this.schemaUpdateListeners.forEach(consumer -> consumer.accept(updated));
    }

    private void notifyListenerForBindSchema(SomlSchema updated) {
        this.schemaBindListeners.forEach(consumer -> consumer.accept(updated));
    }

    private void notifyListenerForRemovedSchema(SomlSchema oldSchema) {
        this.schemaRemoveListeners.forEach(consumer -> consumer.accept(oldSchema));
    }

    @Override
    public Pair<OperationResponse, SomlSchema> validateSchema(String schema) {
        SomlSchemaValidator schemaValidator = new SomlSchemaValidator();
        SomlSchema somlSchema = this.schemaParser.parse(schema);
        OperationResponse operationResponse = schemaValidator.validateSchema(somlSchema);
        if (!operationResponse.isValid()) {
            throw new InvalidSchemaException(ErrorMessages.get((String)"soml.validation.errors", (Object[])new Object[]{operationResponse}), operationResponse);
        }
        return Pair.of((Object)operationResponse, (Object)somlSchema);
    }

    @Override
    public Pair<OperationResponse, SomlSchema> validateSchema(String schema, boolean strict) {
        Pair<OperationResponse, SomlSchema> responsePair = this.validateSchema(schema);
        OperationResponse operationResponse = (OperationResponse)responsePair.getLeft();
        if (strict && operationResponse.hasWarnings()) {
            throw new InvalidSchemaException(ErrorMessages.get((String)VALIDATION_WARN_MSG, (Object[])new Object[]{operationResponse}), operationResponse);
        }
        return responsePair;
    }

    @Override
    public void validateSchemaBinding(SomlSchema somlSchema) {
        if (this.grahqlSchemaConverter != null) {
            try {
                this.grahqlSchemaConverter.convert(somlSchema);
            }
            catch (SomlConversionException ex) {
                throw new InvalidSchemaException(ErrorMessages.get((String)"soml.validation.binding", (Object[])new Object[]{ex.getMessage()}), (Throwable)ex);
            }
        }
    }

    private ManagerState getState() {
        this.setStateForSchema(this::loadSchemaFromStorage);
        return this.managerState;
    }

    private SomlSchema loadSchemaFromStorage() {
        String id;
        try {
            id = this.idManager.getId().orElseThrow(SomlBindException::somlNotBound);
        }
        catch (UnreachableStoreException use) {
            throw new PlatformConfigurationException("Could not get bound schema id.", ErrorCode.SOML_STORE_UNREACHABLE);
        }
        return this.getSchemaOrFail(id);
    }

    private SomlSchema getSchema(String schemaId) {
        try {
            return this.schemaStorage.getParsed(schemaId).orElse(null);
        }
        catch (UnreachableStoreException use) {
            throw new PlatformConfigurationException("Could not get bound schema id.", ErrorCode.SOML_STORE_UNREACHABLE);
        }
        catch (SomlStoreException sse) {
            throw SomlBindException.boundSchemaNotFound(schemaId);
        }
    }

    private SomlSchema getSchemaOrFail(String schemaId) {
        try {
            return this.schemaStorage.getParsed(schemaId).orElseThrow(() -> SomlBindException.boundSchemaNotFound(schemaId));
        }
        catch (UnauthorizedStoreException use) {
            throw new PlatformConfigurationException("Could not authenticate at schema store to load the schema.", ErrorCode.SCHEMA_STORE_UNAUTHENTICATED);
        }
        catch (UnreachableStoreException use) {
            throw new PlatformConfigurationException("Could not load bound schema.", ErrorCode.SOML_STORE_UNREACHABLE);
        }
        catch (MalformedSomlException sse) {
            throw new PlatformConfigurationException("The bound schema is corrupted and can not be loaded", ErrorCode.MALFORMED_SOML);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateForSchema(Supplier<SomlSchema> schemaSupplier) {
        if (this.managerState == null) {
            DefaultSomlSchemaManager defaultSomlSchemaManager = this;
            synchronized (defaultSomlSchemaManager) {
                if (this.managerState != null) {
                    return;
                }
                SomlSchema somlSchema = schemaSupplier.get();
                try {
                    this.managerState = new ManagerState(somlSchema, this.shaclManager, this.grahqlSchemaConverter, this.shaclSchemaConverter);
                }
                catch (ValidatingException vex) {
                    LOGGER.error(ErrorMessages.get((String)"soml.cannot.bind", (Object[])new Object[]{vex.getValidationReport()}));
                    this.clear();
                    this.resetDefaultSchema();
                    throw vex;
                }
                catch (ShaclBindException sbe) {
                    this.clear();
                    this.resetDefaultSchema();
                    throw sbe;
                }
            }
        }
    }

    private void clear() {
        try {
            this.clearShacl();
        }
        catch (PlatformConfigurationException pce) {
            LOGGER.warn("[{}] {}", (Object)this.name, (Object)pce.getMessage());
        }
        catch (ShaclBindException sbe) {
            LOGGER.warn("[{}] {}", (Object)this.name, (Object)ErrorMessages.get((String)"shacl.clear.undefined.error", (Object[])new Object[]{sbe.getMessage()}));
        }
        if (this.managerState != null) {
            LOGGER.info("Clearing the internal state");
        }
        this.managerState = null;
    }

    private void clearShacl() {
        if (this.isShaclConfigured() && this.shaclSchemaConverter.isEnabled()) {
            this.shaclManager.clear();
            if (null != this.managerState) {
                this.managerState.shaclSchema = null;
            }
        }
    }

    @Override
    public boolean hasBoundSchema() throws UnreachableStoreException {
        return this.idManager.getId().isPresent();
    }

    @Override
    public ShaclSchema revalidateShacl() {
        if (this.isShaclConfigured() && this.shaclSchemaConverter.isEnabled()) {
            this.shaclManager.revalidate(this.useUnrestricted().getShaclSchema());
        }
        return this.useUnrestricted().getShaclSchema();
    }

    @Override
    public ShaclSchema rebindShacl() {
        if (!this.isShaclConfigured()) {
            return null;
        }
        try {
            if (this.shaclSchemaConverter.isEnabled() && this.hasBoundSchema() && null == this.managerState.shaclSchema) {
                this.managerState.shaclSchema = this.redeployShaclSchema();
            } else if (!this.shaclSchemaConverter.isEnabled()) {
                throw new ShaclBindException("Requested SHACL bind, but the service is not SHACL-enabled.", ErrorCode.INVALID_SHACL_BIND_REQUEST, 400);
            }
        }
        catch (UnreachableStoreException use) {
            throw new PlatformConfigurationException("Could not connect to remote endpoint to rebind SHACL schema: " + use.getMessage(), ErrorCode.SOML_STORE_UNREACHABLE);
        }
        return this.useUnrestricted().getShaclSchema();
    }

    private boolean isShaclConfigured() {
        return this.shaclManager != null && this.shaclSchemaConverter != null;
    }

    @NotNull
    private ShaclSchema redeployShaclSchema() {
        try {
            ShaclSchema schema = (ShaclSchema)this.shaclSchemaConverter.convert(this.getSomlSchema());
            this.shaclManager.reloadSchema(schema);
            return schema;
        }
        catch (SomlConversionException re) {
            throw new InvalidSchemaException(ErrorMessages.get((String)SOML_CANNOT_CONVERT_SHACL, (Object[])new Object[]{re.getMessage()}), (Throwable)re);
        }
    }

    @Override
    public SomlSchemaManager useUnrestricted() {
        return this;
    }

    @Override
    public boolean rebindService() throws UnreachableStoreException {
        Optional<String> boundId = this.idManager.getId();
        if (boundId.isPresent()) {
            return this.rebindServiceInternal(boundId.get());
        }
        return false;
    }

    private boolean rebindServiceInternal(String id) throws UnreachableStoreException {
        String serviceHostname = this.getServiceAddress();
        this.schemaStorage.deregisterSchemaService(id, serviceHostname);
        try {
            this.schemaStorage.registerSchemaService(id, serviceHostname);
            return true;
        }
        catch (SomlNotFoundException snfe) {
            LOGGER.warn("[{}] Could not register service: {}", (Object)this.name, (Object)snfe.getMessage());
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ")";
    }

    public HealthResult runHealthCheck() {
        String serviceName = this.name + "-schema-manager";
        HealthResult healthResult = HealthResult.combine(() -> ((SomlSchemaStorage)this.schemaStorage).runHealthCheck(), this.idManager::runHealthCheck);
        healthResult.setName(serviceName);
        if (healthResult.isHealth() && this.managerState == null) {
            try {
                this.getSomlSchema();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (healthResult.getStatus() != HealthResult.Status.GREEN && this.managerState != null) {
            healthResult.setStatus(HealthResult.Status.YELLOW);
            healthResult.setMessage("Service initialized, but found store problems: " + healthResult.getMessage());
        }
        return healthResult;
    }

    private static class ManagerState {
        private final SomlSchema somlSchema;
        private final SomlSchemaConverter<GraphQLSchema> graphQlSchemaGenerator;
        private final SomlSchemaConverter<ShaclSchema> shaclSchemaGenerator;
        private JsonLdFrameGenerator frameGenerator;
        private QueryParser graphQlQueryParser;
        private GraphQLSchema graphQlSchema;
        private ShaclSchema shaclSchema;
        private ShaclManager shaclManager;

        private ManagerState(SomlSchema somlSchema, ShaclManager shaclManager, SomlSchemaConverter<GraphQLSchema> graphQlSchemaGenerator, SomlSchemaConverter<ShaclSchema> shaclSchemaGenerator) {
            this.somlSchema = somlSchema;
            this.shaclManager = shaclManager;
            this.graphQlSchemaGenerator = graphQlSchemaGenerator;
            this.shaclSchemaGenerator = shaclSchemaGenerator;
            this.init();
        }

        private void init() {
            if (this.graphQlSchemaGenerator != null) {
                this.frameGenerator = new JsonLdFrameGenerator(this.somlSchema);
                try {
                    this.graphQlSchema = (GraphQLSchema)this.graphQlSchemaGenerator.convert(this.somlSchema);
                    this.graphQlQueryParser = new GraphQlQueryParser(this.graphQlSchema, this.somlSchema);
                }
                catch (SomlConversionException re) {
                    throw new InvalidSchemaException(ErrorMessages.get((String)"soml.cannot.convert.graphql", (Object[])new Object[]{re.getMessage()}), (Throwable)re);
                }
            }
            if (this.shaclManager != null && this.shaclSchemaGenerator != null && this.shaclSchemaGenerator.isEnabled()) {
                if (!this.shaclManager.checkShaclEnabledForRepository()) {
                    throw new PlatformConfigurationException(ErrorMessages.get((String)"shacl.repository.not.enabled", (Object[])new Object[]{this.shaclManager.getRepositoryAddress()}), ErrorCode.BAD_CONFIG_SHACL_NOT_ENABLED);
                }
                try {
                    this.shaclSchema = (ShaclSchema)this.shaclSchemaGenerator.convert(this.somlSchema);
                    this.shaclManager.reloadSchema(this.shaclSchema);
                }
                catch (SomlConversionException re) {
                    throw new InvalidSchemaException(ErrorMessages.get((String)DefaultSomlSchemaManager.SOML_CANNOT_CONVERT_SHACL, (Object[])new Object[]{re.getMessage()}), (Throwable)re);
                }
            }
        }

        GraphQLSchema getGraphQlSchema() {
            return this.graphQlSchema;
        }

        ShaclSchema getShaclSchema() {
            return this.shaclSchema;
        }

        SomlSchema getSomlSchema() {
            return this.somlSchema;
        }

        Object getJsonLdFrame(String query) {
            if (this.graphQlQueryParser != null) {
                Query parsedQuery = (Query)this.graphQlQueryParser.parse((Object)query, SecurityContext.empty());
                return this.frameGenerator.getFrame(parsedQuery);
            }
            return null;
        }

        Map<String, Object> getJsonLdContext() {
            return this.frameGenerator.getContext();
        }
    }
}

