/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.graphql;

import com.github.jsonldjava.utils.JsonUtils;
import com.ontotext.graphdb.graphql.GdbDataAccessProxy;
import com.ontotext.graphdb.graphql.GraphQLShapeGenerationException;
import com.ontotext.graphdb.graphql.RdfToSomlConversionException;
import com.ontotext.graphdb.graphql.config.GraphQLSchemaCreateConfig;
import com.ontotext.graphdb.graphql.config.SimpleGraphQLSchemaCreateRequest;
import com.ontotext.metamodel.storage.rdf4j.Constants;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.platform.owl2soml.ConversionException;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.DataAccessFactory;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Owl2SomlConverter;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.platform.owl2soml.memory.InMemoryModelDataAccess;
import com.ontotext.platform.owl2soml.persistent.ResourceOntologyReference;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.concurrent.Timer;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.plugin.PluginsManager;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class RdfToSomlConversionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SparqlConnectionFactory connectionFactory;
    private final ValueFactory vf = SimpleValueFactory.getInstance();

    public RdfToSomlConversionManager(SparqlConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Owl2SomlConverter.Result convert(String repoId, MultipartFile[] files, String vocPfx, String id, String label, String lang, String stringMode) {
        try (DataAccess dataAccess = this.configureDataAccess(repoId);){
            Owl2SomlConverter.Builder builder = new Owl2SomlConverter.Builder().withDataAccess(dataAccess).vocPfx(vocPfx).id(id).label(label).lang(lang).stringMode(stringMode);
            this.attachModels(files, builder);
            Owl2SomlConverter converter = builder.build();
            Owl2SomlConverter.Result result = this.doConvert(id, converter, Timer.start());
            return result;
        }
    }

    public List<Owl2SomlConverter.Result> convert(String repoId, String[] ids, MultipartFile[] files, String vocPfx, String label, String lang, String stringMode) {
        try (DataAccess dataAccess = this.configureDataAccess(repoId);){
            Owl2SomlConverter.Builder builder = new Owl2SomlConverter.Builder();
            builder.withDataAccess(dataAccess);
            this.attachModels(files, builder);
            builder.vocPfx(vocPfx).label(label).lang(lang).stringMode(stringMode);
            List<Owl2SomlConverter.Result> list = this.convertModels(builder, List.of(ids));
            return list;
        }
    }

    public List<Owl2SomlConverter.Result> convert(String repoId, MultipartFile[] files, String vocPfx, String label, String lang, String stringMode) {
        Timer timer = Timer.start();
        try (DataAccess dataAccess = this.configureDataAccess(repoId);){
            List models;
            Owl2SomlConverter.Builder builder = new Owl2SomlConverter.Builder();
            builder.withDataAccess(dataAccess);
            this.attachModels(files, builder);
            builder.vocPfx(vocPfx).label(label).lang(lang).stringMode(stringMode);
            Owl2SomlConverter somlConverter = builder.id("DUMMY").build();
            try {
                models = somlConverter.retrieveGraphQlModels();
            }
            catch (ConversionException ex) {
                throw new RdfToSomlConversionException(ex.getMessage(), ErrorCode.RDF2SOML_CONVERSION_ERROR);
            }
            if (models.isEmpty()) {
                try {
                    models = somlConverter.retrieveOntologies();
                }
                catch (ConversionException ex) {
                    throw new RdfToSomlConversionException(ex.getMessage(), ErrorCode.RDF2SOML_CONVERSION_ERROR);
                }
            }
            builder.id(null);
            LOGGER.info("Detected {} models in {} ms", (Object)models.size(), (Object)timer.getDuration());
            List<Owl2SomlConverter.Result> list = this.convertModels(builder, models);
            return list;
        }
    }

    public Collection<GraphQlSchemaShape> getGraphQlSchemaShapes(String repoId) {
        try (DataAccess dataAccess = this.configureDataAccess(repoId);){
            dataAccess.loadConfigurations();
            Collection collection = dataAccess.getGraphQlSchemaShapes();
            return collection;
        }
    }

    public List<PrefixNamespaceResponse> getPossiblePrefixes(String repoId) {
        try (DataAccess dataAccess = this.configureDataAccess(repoId);){
            List responseList = dataAccess.getPossiblePrefixes(repoId);
            responseList.sort(Comparator.comparing(PrefixNamespaceResponse::prefix));
            responseList.addFirst(new PrefixNamespaceResponse("NONE", null, Collections.emptyList()));
            List list = responseList;
            return list;
        }
    }

    private List<Owl2SomlConverter.Result> convertModels(Owl2SomlConverter.Builder builder, List<String> models) {
        Timer timer = Timer.start();
        ArrayList<Owl2SomlConverter.Result> results = new ArrayList<Owl2SomlConverter.Result>(models.size());
        for (String id : models) {
            Owl2SomlConverter converter = builder.id(id).build();
            results.add(this.doConvert(id, converter, timer));
        }
        return results;
    }

    private Owl2SomlConverter.Result doConvert(String id, Owl2SomlConverter converter, Timer timer) {
        try {
            Owl2SomlConverter.Result result = converter.convert();
            String schemaId = Objects.toString(SomlSchemaParser.getId((String)result.getSchema()), id).replaceAll("[\n\r]", "_");
            LOGGER.info("Generated SOML model {} in: {} ms.", (Object)schemaId, (Object)timer.getDurationAndRestart());
            List messages = result.getMessages();
            if (!messages.isEmpty()) {
                LOGGER.warn("Found warnings during conversion: {}", (Object)messages);
            }
            return result;
        }
        catch (ConversionException ex) {
            throw new RdfToSomlConversionException(ex.getMessage(), ErrorCode.RDF2SOML_CONVERSION_ERROR);
        }
    }

    private void attachModels(MultipartFile[] files, Owl2SomlConverter.Builder builder) {
        for (MultipartFile file : files) {
            try {
                builder.ontology(file.getOriginalFilename(), file.getInputStream());
            }
            catch (IOException ex) {
                String message = String.format("File %s could not be read", file.getName());
                throw new RdfToSomlConversionException(message, ErrorCode.RDF_MODEL_PARSING_ERROR);
            }
        }
    }

    @NotNull
    private DataAccess configureDataAccess(String repoId) {
        List factoryList = PluginsManager.loadPlugins(DataAccessFactory.class);
        if (factoryList.isEmpty()) {
            Loggers.systemLogger().warn("Could not find any {}, falling back to {}", (Object)factoryList, InMemoryModelDataAccess.class);
            return new InMemoryModelDataAccess();
        }
        DataAccessFactory modelQueryDaoFactory = (DataAccessFactory)factoryList.getFirst();
        if (factoryList.size() > 1) {
            Loggers.systemLogger().warn("Found more than one {} {}, picking {}", new Object[]{DataAccessFactory.class, factoryList, modelQueryDaoFactory});
        }
        return modelQueryDaoFactory.create(repoId, new SparqlEndpoint(), this.connectionFactory);
    }

    public Owl2SomlConverter.Result generateNewSchema(String repository, List<String> namedGraphs, SimpleGraphQLSchemaCreateRequest createRequest) throws ConversionException {
        GdbDataAccessProxy dataAccess = new GdbDataAccessProxy(this.configureDataAccess(repository));
        GraphQLSchemaCreateConfig config = createRequest.getConfig();
        List<Message> messages = this.setDataAccessConfigurations(config, dataAccess);
        try {
            GdbDataAccessProxy gdbDataAccessProxy = dataAccess;
            try {
                Owl2SomlConverter.Builder builder = new Owl2SomlConverter.Builder();
                builder.withDataAccess((DataAccess)dataAccess);
                RdfToSomlConversionManager.setLangConfig(config, builder).id(StringUtils.trimToNull((String)createRequest.getId())).label(StringUtils.trimToNull((String)createRequest.getLabel())).description(StringUtils.trimToNull((String)createRequest.getDescription())).stringMode(config != null ? StringUtils.trimToNull((String)config.getStringMode()) : null).vocPfx(StringUtils.trimToNull((String)createRequest.getVocabPrefix()));
                if (CollectionUtils.isNotEmpty(namedGraphs) && namedGraphs.removeIf(graph -> Constants.STORE_CONTEXT.stringValue().equals(graph) || Constants.ID_STORE_CONTEXT.stringValue().equals(graph))) {
                    Loggers.systemLogger().warn("Excluded GraphQL system graphs ({}, {}) from endpoint generation.", (Object)Constants.STORE_CONTEXT, (Object)Constants.ID_STORE_CONTEXT);
                }
                if (CollectionUtils.isEmpty(namedGraphs)) {
                    Loggers.systemLogger().warn("Using all data in the repository.");
                    builder.ontology(this.vf.createIRI("http://www.ontotext.com/explicit")).ontology(this.vf.createIRI("http://www.ontotext.com/implicit"));
                } else {
                    namedGraphs.forEach(graphId -> builder.ontology(this.vf.createIRI(graphId)));
                }
                Owl2SomlConverter.Result result = builder.build().convert();
                if (gdbDataAccessProxy != null) {
                    gdbDataAccessProxy.close();
                }
                return result;
            }
            catch (Throwable throwable) {
                if (gdbDataAccessProxy != null) {
                    try {
                        gdbDataAccessProxy.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (!messages.isEmpty()) {
                LOGGER.warn("Warnings from the config import: {}", messages);
            }
            dataAccess.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSchemas(String repository, Collection<GraphQlSchemaShape> shapes, GraphQLSchemaCreateConfig configs, BiConsumer<Owl2SomlConverter.Result, GraphQLShapeGenerationException> resultConsumer) {
        if (CollectionUtils.isEmpty(shapes)) {
            LOGGER.warn("GraphQL endpoint generation skipped. Not input models provided");
            return;
        }
        GdbDataAccessProxy dataAccess = new GdbDataAccessProxy(this.configureDataAccess(repository));
        List<Message> messages = this.setDataAccessConfigurations(configs, dataAccess);
        try (GdbDataAccessProxy gdbDataAccessProxy = dataAccess;){
            for (GraphQlSchemaShape shape : shapes) {
                LOGGER.info("Generating endpoint: {}", (Object)shape.getId());
                Owl2SomlConverter.Builder builder = RdfToSomlConversionManager.setLangConfig(configs, new Owl2SomlConverter.Builder()).withDataAccess((DataAccess)dataAccess).id(shape.getId()).label(StringUtils.trimToNull((String)shape.getLabel())).description(StringUtils.trimToNull((String)shape.getDescription())).stringMode(configs != null ? StringUtils.trimToNull((String)configs.getStringMode()) : null).ontology(this.vf.createIRI("http://www.ontotext.com/explicit")).ontology(this.vf.createIRI("http://www.ontotext.com/implicit"));
                try {
                    resultConsumer.accept(builder.build().convert(), null);
                    LOGGER.info("Endpoint: {} generation completed", (Object)shape.getId());
                }
                catch (Exception ex) {
                    resultConsumer.accept(null, new GraphQLShapeGenerationException(shape.getId(), ex));
                }
            }
        }
        finally {
            if (!messages.isEmpty()) {
                LOGGER.warn("Warnings from the shapes config import: {}", messages);
            }
            dataAccess.doClose();
        }
    }

    private static Owl2SomlConverter.Builder setLangConfig(GraphQLSchemaCreateConfig configs, Owl2SomlConverter.Builder builder) {
        if (configs != null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)configs.getLangFetch())) {
                map.put("fetch", configs.getLangFetch());
            }
            if (StringUtils.isNotBlank((CharSequence)configs.getLangValidate())) {
                map.put("validate", configs.getLangValidate());
            }
            if (StringUtils.isNotBlank((CharSequence)configs.getLangFetch())) {
                map.put("implicit", configs.getLangImplicit());
            }
            if (!map.isEmpty()) {
                try {
                    builder.lang(JsonUtils.toString(map));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return builder;
    }

    private List<Message> setDataAccessConfigurations(GraphQLSchemaCreateConfig config, DataAccess dataAccess) {
        ArrayList<Message> messages = new ArrayList<Message>();
        this.buildConfigInputStream(config).map(input -> new ResourceOntologyReference("custom-config.ttl", input, dataAccess, messages)).ifPresent(arg_0 -> ((DataAccess)dataAccess).configureWith(arg_0));
        return messages;
    }

    private Optional<InputStream> buildConfigInputStream(GraphQLSchemaCreateConfig config) {
        String options = this.buildStringConfigs(config);
        if (options != null) {
            try {
                return Optional.of(((ReaderInputStream.Builder)ReaderInputStream.builder().setReader((Reader)new StringReader(options))).setCharset(StandardCharsets.UTF_8).get());
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to load config using the provided options.", ex);
            }
        }
        return Optional.empty();
    }

    private String buildStringConfigs(GraphQLSchemaCreateConfig config) {
        if (config == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("@prefix so: <").append("http://www.ontotext.com/semantic-object/").append("> .\n\n");
        builder.append("[] \n");
        boolean found = false;
        if (config.getReadShaclPropertyLabels() != null) {
            builder.append(this.formatConfig("readShaclPropertyLabels", config.getReadShaclPropertyLabels()));
            found = true;
        }
        if (config.getIncludeDeactivatedShapes() != null) {
            builder.append(this.formatConfig("includeDeactivatedShapes", config.getIncludeDeactivatedShapes()));
            found = true;
        }
        if (config.getCleanInvalidInverseOf() != null) {
            builder.append(this.formatConfig("cleanInvalidInverseOf", config.getCleanInvalidInverseOf()));
            found = true;
        }
        if (config.getUseUnions() != null) {
            builder.append(this.formatConfig("useUnions", config.getUseUnions()));
            found = true;
        }
        if (config.getDefaultMaxCardinality() != null) {
            builder.append(this.formatConfig("defaultMaxCardinality", config.getDefaultMaxCardinality()));
            found = true;
        }
        if (config.getForceInterfaceTypes() != null) {
            builder.append(this.formatConfig("forceInterfaceTypes", config.getForceInterfaceTypes()));
            found = true;
        }
        if (config.getRemoveUnknownRanges() != null) {
            builder.append(this.formatConfig("removeUnknownRanges", config.getRemoveUnknownRanges()));
            found = true;
        }
        if (config.getReadRBACRules() != null) {
            builder.append(this.formatConfig("readRBACRules", config.getReadRBACRules()));
            found = true;
        }
        builder.append(".");
        return found ? builder.toString() : null;
    }

    private String formatConfig(String key, Object value) {
        StringBuilder formatted = new StringBuilder();
        formatted.append("  so:").append(key).append(" ");
        if (value instanceof String) {
            formatted.append('\"').append(value).append('\"');
        } else {
            formatted.append(value);
        }
        formatted.append(" ; \n");
        return formatted.toString();
    }
}

