/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.graphql;

import com.ontotext.graphdb.graphql.GraphDB2SemanticObjectsConfigurationResolver;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.configuration.GraphQlQueryOptions;
import com.ontotext.soaas.configuration.GraphqlOptions;
import com.ontotext.soaas.configuration.IntrospectionCacheConfig;
import com.ontotext.soaas.configuration.MutationConfigurations;
import com.ontotext.soaas.configuration.SparqlOptimizations;
import com.ontotext.soaas.configuration.ValidatorConfigOptions;
import com.ontotext.sparql.SparqlEndpoint;

public class GraphQLConfigurations {
    private static final String MUTATION_MODE = "graphdb.graphql.query.optimizations.mutationMode";
    private static final String IN_THRESHOLD = "graphdb.graphql.query.optimizations.inThreshold";
    private static final String SO_TYPE_OPTIMIZATION_THRESHOLD = "graphdb.graphql.query.optimizations.soTypeOptimizationThreshold";
    private static final String DISABLE_UNION_TO_LATERAL_OPTIMIZATION = "graphdb.graphql.query.optimizations.disableUnionToLateralOptimization";
    private static final String FILTER_EXISTS_TO_SELECT_DISTINCT = "graphdb.graphql.query.optimizations.filterExistsToSelectDistinct";
    private static final String OPTIONAL_TO_UNION = "graphdb.graphql.query.optimizations.optionalToUnion";
    private static final String DISABLE_SINGLE_PROPERTIES_OPTIMIZATION_ENABLED = "graphdb.graphql.query.optimizations.disableSinglePropertiesOptimization";
    private static final String SINGLE_SO_TYPE_OPTIMIZATION = "graphdb.graphql.query.optimizations.singleSoTypeOptimizationEnabled";
    private static final String ENABLE_REDUCED_SCHEMA = "graphdb.graphql.enableReducedSchema";
    private static final String MUTATION_GENERATION_ENABLED = "graphdb.graphql.mutation.generation.enabled";
    private static final String ENABLE_OUTPUT_VALIDATIONS = "graphdb.graphql.enableOutputValidations";
    private static final String CACHE_ENABLED = "graphdb.graphql.introspectionQueryCache.enabled";
    private static final String CACHE_CONFIG = "graphdb.graphql.introspectionQueryCache.config";
    private static final String VALIDATION_FAILURE_MODE = "graphdb.graphql.mutation.validation.failureMode";
    private static final String ASYNC_VALIDATION = "graphdb.graphql.mutation.validation.asyncEnabled";
    private static final String MAX_CONCURRENT_VALIDATIONS_PER_REQUEST = "graphdb.graphql.mutation.validation.maxConcurrentPerRequest";
    private static final String ASYNC_VALIDATION_TIMEOUT = "graphdb.graphql.mutation.validation.asyncTimeoutSeconds";
    private static final String NULL_ARRAYS = "graphdb.graphql.response.json.nullArrays";
    private static final String COMPACT_ERROR_MESSAGES = "graphdb.graphql.response.compactErrorMessages";
    private static final String ENDPOINTS_CACHE_CONFIG = "graphdb.graphql.endpointsCacheConfig";
    private static final String ENABLE_QUERY_LOGGING = "graphdb.graphql.enableQueryLogging";
    private static final String DEPTH_LIMIT = "graphdb.graphql.query.depthLimit";
    private static final String MAX_OBJECTS_RETURNED = "graphdb.graphql.query.maxObjectsReturned";
    private static final String CARTESIAN_PRODUCT_CHECK = "graphdb.graphql.query.cartesianProductCheck";
    public static final String QUERY_MAX_TUPLE_RESULTS = "graphdb.graphql.query.maxTupleResults";
    public static final String QUERY_SUBQUERY_FULL_RESULT = "graphdb.graphql.query.subqueryFullResult";
    public static final String QUERY_EXECUTION_MODE = "graphdb.graphql.query.executionMode";
    public static final String ALLOW_PARTIAL_UPDATES = "graphdb.graphql.mutation.allowPartialUpdates";

    public static ConfigurationResolver getConfigurationResolver() {
        return GraphDB2SemanticObjectsConfigurationResolver.INSTANCE;
    }

    public SparqlOptimizations getSparqlOptimizations() {
        ConfigurationResolver resolver = GraphQLConfigurations.getConfigurationResolver();
        OperationBuilderOptions.MutationMode mode = (OperationBuilderOptions.MutationMode)resolver.resolve(MUTATION_MODE, OperationBuilderOptions.MutationMode.class, (Object)OperationBuilderOptions.MutationMode.DEFAULT);
        Boolean optionalToUnion = (Boolean)resolver.resolve(OPTIONAL_TO_UNION, Boolean.class, (Object)true);
        Boolean unionToLateral = (Boolean)resolver.resolve(DISABLE_UNION_TO_LATERAL_OPTIMIZATION, Boolean.class, (Object)false);
        Boolean existsToSelect = (Boolean)resolver.resolve(FILTER_EXISTS_TO_SELECT_DISTINCT, Boolean.class, (Object)true);
        int inThreshold = (Integer)resolver.resolve(IN_THRESHOLD, Integer.class, (Object)1000);
        int soTypeOptimizationThreshold = (Integer)resolver.resolve(SO_TYPE_OPTIMIZATION_THRESHOLD, Integer.class, (Object)2);
        Boolean disableSinglePropertiesOptimization = (Boolean)resolver.resolve(DISABLE_SINGLE_PROPERTIES_OPTIMIZATION_ENABLED, Boolean.class, (Object)false);
        Boolean singleSoTypeOptimizationEnabled = (Boolean)resolver.resolve(SINGLE_SO_TYPE_OPTIMIZATION, Boolean.class, (Object)false);
        SparqlOptimizations sparqlOptimizations = new SparqlOptimizations();
        sparqlOptimizations.setMutationMode(mode);
        sparqlOptimizations.setOptionalToUnion(optionalToUnion.booleanValue());
        sparqlOptimizations.setDisableUnionToLateralOptimization(unionToLateral.booleanValue());
        sparqlOptimizations.setFilterExistsToSelectDistinct(existsToSelect.booleanValue());
        sparqlOptimizations.setInThreshold(inThreshold);
        sparqlOptimizations.setSoTypeOptimizationThreshold(soTypeOptimizationThreshold);
        sparqlOptimizations.setDisableSinglePropertiesOptimization(disableSinglePropertiesOptimization.booleanValue());
        sparqlOptimizations.setSingleSoTypeOptimizationEnabled(singleSoTypeOptimizationEnabled.booleanValue());
        return sparqlOptimizations;
    }

    public OperationBuilderOptions getOperationBuilderOptions() {
        SparqlOptimizations optimizations = this.getSparqlOptimizations();
        return OperationBuilderOptions.custom().setMutationMode(optimizations.getMutationMode()).setInThreshold(optimizations.getInThreshold()).setSoTypeOptimizationThreshold(optimizations.getSoTypeOptimizationThreshold()).setDisableLateralOptimization(optimizations.isDisableUnionToLateralOptimization()).build();
    }

    public GraphqlOptions getGraphqlOptions() {
        ConfigurationResolver resolver = GraphQLConfigurations.getConfigurationResolver();
        Boolean enableOutputValidations = (Boolean)resolver.resolve(ENABLE_OUTPUT_VALIDATIONS, Boolean.class, (Object)true);
        Boolean enableReducedSchema = (Boolean)resolver.resolve(ENABLE_REDUCED_SCHEMA, Boolean.class, (Object)true);
        Boolean cacheEnabled = (Boolean)resolver.resolve(CACHE_ENABLED, Boolean.class, (Object)true);
        String cacheConfig = (String)resolver.resolve(CACHE_CONFIG, String.class, (Object)"maximumSize=100,initialCapacity=2,softValues,expireAfterAccess=30m");
        Boolean mutationGenerationEnabled = (Boolean)resolver.resolve(MUTATION_GENERATION_ENABLED, Boolean.class, (Object)true);
        ValidatorOptions.ValidationFailureMode validationMode = (ValidatorOptions.ValidationFailureMode)resolver.resolve(VALIDATION_FAILURE_MODE, ValidatorOptions.ValidationFailureMode.class, (Object)ValidatorOptions.ValidationFailureMode.DEFAULT);
        Boolean asyncValidation = (Boolean)resolver.resolve(ASYNC_VALIDATION, Boolean.class, (Object)true);
        Integer maxConcurrentValidations = (Integer)resolver.resolve(MAX_CONCURRENT_VALIDATIONS_PER_REQUEST, Integer.class, (Object)4);
        Integer asyncValidationTimeout = (Integer)resolver.resolve(ASYNC_VALIDATION_TIMEOUT, Integer.class, (Object)60);
        Boolean nullArrays = (Boolean)resolver.resolve(NULL_ARRAYS, Boolean.class, (Object)false);
        Boolean compactErrorMessages = (Boolean)resolver.resolve(COMPACT_ERROR_MESSAGES, Boolean.class, (Object)false);
        String endpointCacheConfig = (String)resolver.resolve(ENDPOINTS_CACHE_CONFIG, String.class, (Object)"maximumSize=100,expireAfterAccess=4h,softValues");
        Boolean enableQueryLogging = (Boolean)resolver.resolve(ENABLE_QUERY_LOGGING, Boolean.class, (Object)false);
        GraphqlOptions graphqlOptions = new GraphqlOptions();
        graphqlOptions.setEnableReducedSchema(enableReducedSchema.booleanValue());
        graphqlOptions.setEnableOutputValidations(enableOutputValidations.booleanValue());
        graphqlOptions.setEndpointsCacheConfig(endpointCacheConfig);
        IntrospectionCacheConfig cacheConfigObject = new IntrospectionCacheConfig();
        cacheConfigObject.setEnabled(cacheEnabled.booleanValue());
        cacheConfigObject.setConfig(cacheConfig);
        graphqlOptions.setIntrospectionQueryCache(cacheConfigObject);
        MutationConfigurations mutationConfigurations = new MutationConfigurations();
        mutationConfigurations.setEnabled(mutationGenerationEnabled.booleanValue());
        graphqlOptions.setMutation(mutationConfigurations);
        ValidatorConfigOptions validatorConfigOptions = new ValidatorConfigOptions();
        validatorConfigOptions.setAsyncValidationEnabled(asyncValidation.booleanValue());
        validatorConfigOptions.setMaxConcurrentValidationsPerRequest(maxConcurrentValidations.intValue());
        validatorConfigOptions.setAsyncValidationTimeoutSeconds((long)asyncValidationTimeout.intValue());
        validatorConfigOptions.setValidationFailureMode(validationMode);
        graphqlOptions.setValidation(validatorConfigOptions);
        GraphqlOptions.Response response = new GraphqlOptions.Response();
        GraphqlOptions.Json json = new GraphqlOptions.Json();
        json.setNullArrays(nullArrays.booleanValue());
        response.setCompactErrorMessages(compactErrorMessages.booleanValue());
        response.setJson(json);
        graphqlOptions.setResponse(response);
        graphqlOptions.setEnableQueryLogging(enableQueryLogging.booleanValue());
        return graphqlOptions;
    }

    public GraphQlQueryOptions getGraphQlQueryOptions() {
        ConfigurationResolver resolver = GraphQLConfigurations.getConfigurationResolver();
        Integer depthLimit = (Integer)resolver.resolve(DEPTH_LIMIT, Integer.class, (Object)15);
        Integer maxObjectsPerRequest = (Integer)resolver.resolve(MAX_OBJECTS_RETURNED, Integer.class, (Object)100000);
        GraphQlQueryOptions graphQlQueryOptions = new GraphQlQueryOptions();
        graphQlQueryOptions.setDepthLimit(depthLimit.intValue());
        graphQlQueryOptions.setMaxObjectsReturned(maxObjectsPerRequest.intValue());
        return graphQlQueryOptions;
    }

    public SparqlEndpoint setEndpointConfigurations(SparqlEndpoint sparqlEndpoint) {
        ConfigurationResolver resolver = GraphQLConfigurations.getConfigurationResolver();
        sparqlEndpoint.setMaxTupleResults(this.getMaxTupleResults());
        sparqlEndpoint.setSubqueryFullResult((Boolean)resolver.resolve(QUERY_SUBQUERY_FULL_RESULT, Boolean.class, (Object)false));
        sparqlEndpoint.setExecutionMode((SparqlEndpoint.ExecutionMode)resolver.resolve(QUERY_EXECUTION_MODE, SparqlEndpoint.ExecutionMode.class, (Object)SparqlEndpoint.ExecutionMode.SUBQUERY));
        sparqlEndpoint.setCartesianProtectionEnabled(((Boolean)resolver.resolve(CARTESIAN_PRODUCT_CHECK, Boolean.class, (Object)false)).booleanValue());
        return sparqlEndpoint;
    }

    public int getMaxTupleResults() {
        return (Integer)GraphQLConfigurations.getConfigurationResolver().resolve(QUERY_MAX_TUPLE_RESULTS, Integer.class, (Object)5000000);
    }

    public boolean allowPartialUpdates() {
        return (Boolean)GraphQLConfigurations.getConfigurationResolver().resolve(ALLOW_PARTIAL_UPDATES, Boolean.class, (Object)false);
    }
}

