/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.graphql;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Rbac;
import com.ontotext.models.Role;
import com.ontotext.models.RoleAction;
import com.ontotext.models.Roles;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import com.ontotext.soaas.plugin.Order;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Order(value=1000)
public class GraphDBRbacRoleNormalizationExtension
implements SchemaExtension {
    @NotNull
    private static final Set<String> GDB_SPECIFIC_ROLES = Arrays.stream(com.ontotext.graphdb.security.Role.values()).map(Enum::name).collect(Collectors.toSet());
    public static final String CUSTOM_ = "CUSTOM_";

    public boolean canHandle(SomlSchema somlSchema) {
        return somlSchema.getRbac() != null && somlSchema.getRbac().getRoles() != null;
    }

    public void postBaseSchemaMergeProcessing(SomlSchema somlSchema) {
        Rbac rbac = somlSchema.getRbac();
        GdbRoles gdbRoles = new GdbRoles(rbac.getRoles());
        gdbRoles.setContainedIn(rbac);
        rbac.setRoles((Roles)gdbRoles);
        Roles roles = rbac.getRoles();
        Map<String, List<String>> uniqueRoles = roles.keySet().stream().collect(Collectors.groupingBy(String::toUpperCase));
        if (uniqueRoles.size() != roles.size()) {
            String duplicateRoles = uniqueRoles.values().stream().filter(list -> list.size() > 1).map(Objects::toString).collect(Collectors.joining(", "));
            throw new InvalidSchemaException("RBAC role names should be unique when ignoring character case. Found duplicate roles: " + duplicateRoles);
        }
        Map<String, Role> reformatted = roles.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(CUSTOM_)).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(entry -> GraphDBRbacRoleNormalizationExtension.toGdbRoleName((String)entry.getKey()), entry -> {
            Role role = (Role)entry.getValue();
            Role newRole = new Role(true);
            newRole.setName(GraphDBRbacRoleNormalizationExtension.toGdbRoleName(role.getName()));
            newRole.setDescription(role.getDescription());
            newRole.setActions(GraphDBRbacRoleNormalizationExtension.cloneActions(role.getActions()));
            newRole.setNotActions(GraphDBRbacRoleNormalizationExtension.cloneActions(role.getNotActions()));
            newRole.expand(roles);
            return role;
        }));
        roles.putAll(reformatted);
    }

    private static List<RoleAction> cloneActions(List<RoleAction> actions) {
        if (actions == null) {
            return null;
        }
        return actions.stream().map(RoleAction::createDuplicate).collect(Collectors.toList());
    }

    private static String toGdbRoleName(String role) {
        if (GDB_SPECIFIC_ROLES.contains(role)) {
            return role;
        }
        if (role.toUpperCase().startsWith(CUSTOM_)) {
            return role;
        }
        return CUSTOM_ + role.toUpperCase();
    }

    public static class GdbRoles
    extends Roles {
        GdbRoles(Roles roles) {
            roles.forEach((key, value) -> {
                if (!"Federation_SystemRole".equals(key)) {
                    this.put((String)key, (Role)value);
                }
            });
            this.stopTracking();
        }

        public String toYaml(YamlPrinter.Configuration configuration) {
            YamlPrinter printer = new YamlPrinter(configuration).addField("roles", 2);
            this.forEach((key, role) -> {
                if (this.isTracked((String)key)) {
                    printer.addField(key, 3);
                    printer.addYaml((YamlRepresentable)role);
                }
            });
            return printer.asString();
        }
    }
}

