/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.IterableCode;
import com.github.mustachejava.reflect.SimpleObjectHandler;
import com.ontotext.soaas.mustache.CustomJoinerCode;
import com.ontotext.soaas.mustache.JoinerCode;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class OntoMustacheFactory
extends DefaultMustacheFactory {
    private static final Set<String> DISALLOWED_METHODS = new HashSet<String>(Arrays.asList("getClass", "hashCode", "clone", "toString", "notify", "notifyAll", "finalize", "wait"));
    public static final SimpleObjectHandler OBJECT_HANDLER = new SimpleObjectHandler(){

        protected void checkMethod(Method member) throws NoSuchMethodException {
            if (DISALLOWED_METHODS.contains(member.getName())) {
                throw new MustacheException("Disallowed: method " + member.getName() + " cannot be accessed");
            }
            if ((member.getModifiers() & 1) != 1) {
                throw new NoSuchMethodException("Only public members allowed");
            }
        }

        protected void checkField(Field member) throws NoSuchFieldException {
            if ((member.getModifiers() & 1) != 1) {
                throw new NoSuchFieldException("Only public members allowed");
            }
        }
    };

    public OntoMustacheFactory() {
        this.setup();
    }

    private void setup() {
        this.setObjectHandler((ObjectHandler)OBJECT_HANDLER);
    }

    public void encode(String value, Writer writer) {
        try {
            writer.write(value);
        }
        catch (IOException ioe) {
            throw new MustacheException("Failed to write value: " + value, (Throwable)ioe);
        }
    }

    public MustacheVisitor createMustacheVisitor() {
        return new CustomMustacheVisitor(this);
    }

    static class CustomMustacheVisitor
    extends DefaultMustacheVisitor {
        CustomMustacheVisitor(DefaultMustacheFactory df) {
            super(df);
        }

        public void pragma(TemplateContext tc, String pragma, String args) {
            throw new MustacheException("Disallowed: pragmas in templates");
        }

        public void iterable(TemplateContext templateContext, String variable, Mustache mustache) {
            if (JoinerCode.match(variable)) {
                this.list.add(new JoinerCode(templateContext, this.df, mustache));
            } else if (CustomJoinerCode.match(variable)) {
                this.list.add(new CustomJoinerCode(templateContext, this.df, mustache, variable));
            } else {
                this.list.add(new IterableCode(templateContext, this.df, mustache, variable));
            }
        }
    }
}

