/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.license;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.forest.core.graphdb.ErrorLicense;
import com.ontotext.forest.core.graphdb.InvalidLicense;
import com.ontotext.forest.core.graphdb.ValidLicense;
import com.ontotext.license.License;
import com.ontotext.license.LicenseNotSet;
import com.ontotext.license.LicenseRegistry;
import com.ontotext.license.LicenseValidationException;
import com.ontotext.trree.statistics.StatisticsSettings;
import com.ontotext.trree.statistics.SystemStatisticsCollector;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.io.IOUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class LicenseController
extends AbstractController {
    public static final String URL_MAPPING = "/rest/graphdb-settings/license";
    public static final String LICENSE_HARDCODED_URL_MAPPING = "/rest/graphdb-settings/license/hardcoded";

    public LicenseController() {
        this.setSupportedMethods(new String[]{"GET", "POST", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if ("GET".equals(request.getMethod())) {
            if (request.getRequestURI().endsWith(LICENSE_HARDCODED_URL_MAPPING)) {
                String hardcoded = Boolean.toString(LicenseRegistry.getInstance().hasHardcodedLicenseConfig());
                response.setStatus(200);
                response.setContentLength(hardcoded.length());
                response.setContentType("text/plain");
                PrintWriter writer = response.getWriter();
                writer.write(hardcoded);
            } else {
                try {
                    Object jsonLicense;
                    License license = LicenseRegistry.getInstance().getCurrentLicense();
                    try {
                        LicenseRegistry.getInstance().validateLicense();
                        jsonLicense = new ValidLicense(license);
                        jsonLicense.setInstallationId(StatisticsSettings.getInstance().getInstallationId());
                    }
                    catch (LicenseValidationException lve) {
                        jsonLicense = license instanceof LicenseNotSet ? new ErrorLicense((Exception)((Object)lve)) : new InvalidLicense(license, (Exception)((Object)lve));
                    }
                    ObjectMapper om = new ObjectMapper();
                    response.setContentType("application/json");
                    om.writeValue((OutputStream)response.getOutputStream(), jsonLicense);
                    return null;
                }
                catch (IOException ioe) {
                    response.sendError(417, ioe.getMessage());
                }
            }
            SystemStatisticsCollector.getInstance().setWorkbenchIsUsed();
        } else if ("POST".equals(request.getMethod())) {
            if (LicenseRegistry.getInstance().hasHardcodedLicenseConfig()) {
                response.sendError(412, "License configuration is hardcoded!");
            } else {
                byte[] licenseContent = IOUtils.toByteArray((InputStream)request.getInputStream());
                License license = LicenseRegistry.getInstance().loadLicenseFromBytes(licenseContent);
                try {
                    LicenseRegistry.getInstance().validateLicenseBasic(license);
                    LicenseRegistry.getInstance().setLicenseFromBytes(licenseContent);
                    response.setStatus(200);
                }
                catch (LicenseValidationException lve) {
                    response.sendError(412, lve.getMessage());
                }
            }
        } else if ("DELETE".equals(request.getMethod())) {
            if (LicenseRegistry.getInstance().hasHardcodedLicenseConfig()) {
                response.sendError(412, "License configuration is hardcoded!");
            }
            LicenseRegistry.getInstance().unsetLicense();
        }
        response.flushBuffer();
        return null;
    }
}

