/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.health;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.trree.health.CompositeHealthCheck;
import com.ontotext.trree.health.HealthCheck;
import com.ontotext.trree.health.HealthCheckable;
import com.ontotext.trree.health.RepositoryStateHealthCheck;
import com.ontotext.trree.sdk.CompositeHealthResult;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.util.ErrorUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.helpers.SailWrapper;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class HealthChecksController
extends AbstractController {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private SemanticDataManagement dataManagement;
    private ProxyToRemoteSesame proxy;

    public HealthChecksController() {
        this.setSupportedMethods(new String[]{"GET"});
    }

    public void setDataManagement(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }

    public void setProxy(ProxyToRemoteSesame proxy) {
        this.proxy = proxy;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation semanticLocation = this.dataManagement.getLocationFromHeaderOrThrow();
        if (semanticLocation.isLocal()) {
            String repositoryId = RepositoryInterceptor.getRepositoryID((HttpServletRequest)request);
            try {
                GraphDBRepositoryManager repositoryManager = (GraphDBRepositoryManager)semanticLocation.sesameManager();
                String passiveParam = request.getParameter("passive");
                boolean isPassiveCheck = passiveParam != null;
                GraphDBRepositoryManager.RepositoryState repositoryState = repositoryManager.getRepositoryState(repositoryId);
                Repository repository = null;
                if (repositoryState == GraphDBRepositoryManager.RepositoryState.RUNNING) {
                    isPassiveCheck = false;
                }
                if (StringUtils.isNotBlank((CharSequence)passiveParam)) {
                    int timeout = Integer.parseInt(passiveParam);
                    CompletableFuture<Repository> repositoryFuture = CompletableFuture.supplyAsync(() -> repositoryManager.getRepository(repositoryId));
                    try {
                        repository = repositoryFuture.get(timeout, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        isPassiveCheck = true;
                        repositoryState = repositoryManager.getRepositoryState(repositoryId);
                    }
                } else if (!isPassiveCheck) {
                    repository = repositoryManager.getRepository(repositoryId);
                }
                if (repository != null) {
                    return this.healthCheckResult(this.getHealthCheckForRepository(repository));
                }
                if (isPassiveCheck && repositoryState != null) {
                    return this.healthCheckResult(this.getHealthCheckForRepository(repositoryId, repositoryState));
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Error in health check", (Throwable)e);
                return this.healthCheckResult(this.getHealthCheckForRepositoryError(repositoryId, e));
            }
            throw new ClientHTTPException(404, "Unknown repository: " + repositoryId);
        }
        this.proxy.proxyRequest(request, response, semanticLocation);
        return null;
    }

    private ModelAndView healthCheckResult(final CompositeHealthCheck healthCheck) {
        return new ModelAndView(new View(){

            public String getContentType() {
                return ContentType.APPLICATION_JSON.toString();
            }

            public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
                CompositeHealthResult resultRoot = healthCheck.execute();
                response.setStatus(resultRoot.getStatus().getHttpStatus());
                response.setContentType(this.getContentType());
                HealthChecksController.this.objectMapper.writeValue((OutputStream)response.getOutputStream(), (Object)resultRoot);
            }
        });
    }

    private CompositeHealthCheck getHealthCheckForRepository(Repository repository) {
        CompositeHealthCheck healthCheck = null;
        while (!(repository instanceof HealthCheckable) && repository instanceof RepositoryWrapper) {
            repository = ((RepositoryWrapper)repository).getDelegate();
        }
        if (repository instanceof HealthCheckable) {
            healthCheck = ((HealthCheckable)repository).getHealthCheck();
        } else if (repository instanceof SailRepository) {
            Sail sail = ((SailRepository)repository).getSail();
            while (sail instanceof SailWrapper) {
                sail = ((SailWrapper)sail).getBaseSail();
            }
            if (!(sail instanceof HealthCheckable)) {
                throw new IllegalStateException("Health checks are not supported on non-GraphDB repositories/sails");
            }
            healthCheck = ((HealthCheckable)sail).getHealthCheck();
        } else {
            throw new IllegalStateException("Health checks are not supported on non-GraphDB repositories");
        }
        if (healthCheck == null) {
            throw new RuntimeException("No health check configured for repository.");
        }
        return healthCheck;
    }

    private CompositeHealthCheck getHealthCheckForRepository(String repositoryId, final GraphDBRepositoryManager.RepositoryState repositoryState) {
        return new CompositeHealthCheck(this, repositoryId){

            public List<HealthCheck<?>> getChildren() {
                return Collections.singletonList(new RepositoryStateHealthCheck(repositoryState));
            }
        };
    }

    private CompositeHealthCheck getHealthCheckForRepositoryError(final String repositoryId, final Exception error) {
        return new CompositeHealthCheck(this, repositoryId){

            public List<HealthCheck<?>> getChildren() {
                return Collections.emptyList();
            }

            public CompositeHealthResult processResult(CompositeHealthResult result) {
                return new CompositeHealthResult(repositoryId){

                    public HealthResult.Status getStatus() {
                        return HealthResult.Status.RED;
                    }

                    public String getMessage() {
                        return "Error running health check: " + ErrorUtil.getSimpleMessage((String)ErrorUtil.getSaneExtraMessage((Throwable)error));
                    }
                };
            }
        };
    }
}

