/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame.sos;

import com.ontotext.graphdb.sesame.sos.SOSSplitQuery;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;

public class SOSSplitQueryExtractor {
    private static final int[] WHITESPACE = new int[]{9, 10, 13, 32};
    private static final int[] SELECT = new int[]{83, 69, 76, 69, 67, 84};
    private static final int[] SELECT_L = new int[]{115, 101, 108, 101, 99, 116};
    private static final int[] CONSTRUCT = new int[]{67, 79, 78, 83, 84, 82, 85, 67, 84};
    private static final int[] CONSTRUCT_L = new int[]{99, 111, 110, 115, 116, 114, 117, 99, 116};
    private static final int[] ASK = new int[]{65, 83, 75};
    private static final int[] ASK_L = new int[]{97, 115, 107};
    private int ch;
    private PeekStringReader reader;
    private String query;
    private String baseAndPrefix;
    private SOSSplitQuery.Query.Builder queryBuilder;
    private Set<String> bindings = new LinkedHashSet<String>();

    public SOSSplitQueryExtractor(String query, String baseAndPrefix, SOSSplitQuery.Query.Builder queryBuilder) {
        this.query = query;
        this.baseAndPrefix = baseAndPrefix;
        this.queryBuilder = queryBuilder == null ? new SOSSplitQuery.Query.Builder() : queryBuilder;
        if (this.queryBuilder.querySupplier == null) {
            this.queryBuilder.querySupplier(this::getQuery);
        }
    }

    public SOSSplitQuery.Query.Builder process() {
        this.reader = new PeekStringReader(this, this.query);
        if (this.baseAndPrefix == null) {
            this.collectBaseAndPrefix();
        }
        this.collectBindings();
        this.extractSubQueries();
        return this.queryBuilder;
    }

    private String getQuery() {
        return (this.baseAndPrefix != null ? this.baseAndPrefix : "") + this.query;
    }

    private void collectBaseAndPrefix() {
        StringBuilder builder = new StringBuilder();
        while (!(this.read() <= 0 || this.isSelectClause() || this.isConstructClause() || this.isAskClause())) {
            builder.append((char)this.ch);
        }
        this.baseAndPrefix = builder.toString();
        this.query = this.query.substring(this.baseAndPrefix.length());
        this.reader = new PeekStringReader(this, this.query);
    }

    private void collectBindings() {
        this.read();
        while (this.reader.peek() != 123) {
            if (this.isWhitespace()) {
                this.read();
                continue;
            }
            if (this.skipComments()) continue;
        }
        if (this.isSelectClause()) {
            this.reader.skip(SELECT.length);
            while (this.read() > 0) {
                if (this.isWhitespace() || this.skipComments()) continue;
                if (this.ch != 63) break;
                this.bindings.add(this.readNextVar());
            }
        }
        if (!this.bindings.isEmpty() && this.queryBuilder.bindings.isEmpty()) {
            this.queryBuilder.bindings(this.bindings);
        }
    }

    private String readNextVar() {
        StringBuilder builder = new StringBuilder();
        while (true) {
            this.read();
            if (this.isWhitespace()) break;
            builder.append((char)this.ch);
        }
        return builder.toString();
    }

    private void extractSubQueries() {
        while (this.read() > 0) {
            if (this.ch != 123) continue;
            this.processSparqlBlock();
        }
    }

    private void processSparqlBlock() {
        this.reader.mark();
        if (this.isSparqlSubSelectBlock()) {
            this.reset();
            int start = this.findLocationOfPrevious('{');
            String select = this.readNextBlock();
            int end = this.reader.pos();
            SOSSplitQuery.Query.Builder childBuilder = this.createBuilderForSubQuery(select);
            if (childBuilder != null) {
                this.query = this.query.substring(0, start) + this.query.substring(end);
                this.reader = new PeekStringReader(this, this.query);
                select = this.removeEmptyValuesBlock(select, childBuilder.iterateOver);
            } else {
                childBuilder = this.queryBuilder;
            }
            new SOSSplitQueryExtractor(select, this.baseAndPrefix, childBuilder).process();
        } else {
            this.reset();
        }
    }

    private int findLocationOfPrevious(char c) {
        int pos = this.reader.pos();
        while (this.reader.peek(--pos) != c) {
        }
        return pos;
    }

    private String removeEmptyValuesBlock(String query, String varName) {
        String patStr = "VALUES\\s+\\?" + varName + "\\s*\\{\\s*\\}";
        Pattern pat = Pattern.compile(patStr);
        return pat.matcher(query).replaceAll("");
    }

    private SOSSplitQuery.Query.Builder createBuilderForSubQuery(String subQuery) {
        ParsedTupleQuery parsedQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)(this.baseAndPrefix + "\n" + subQuery), (String)"http://example.com");
        TupleExpr expr = parsedQuery.getTupleExpr();
        EmptyBindingSetChecker ebsc = new EmptyBindingSetChecker();
        expr.visit((QueryModelVisitor)ebsc);
        if (ebsc.hasEmptyVales) {
            SOSSplitQuery.Query.Builder childBuilder = this.queryBuilder.addSubStep();
            childBuilder.iterateOver(ebsc.valueName);
            return childBuilder;
        }
        return null;
    }

    private boolean isSparqlSubSelectBlock() {
        do {
            this.read();
            if (this.ch >= 0) continue;
            return false;
        } while (this.isWhitespace() || this.skipComments());
        return this.isSelectClause();
    }

    private boolean isSelectClause() {
        boolean isSelect = true;
        for (int i = 0; i < SELECT.length; ++i) {
            int actCh = this.reader.peek(this.reader.pos() - 1 + i);
            if (actCh == SELECT[i] || actCh == SELECT_L[i]) continue;
            isSelect = false;
            break;
        }
        return isSelect;
    }

    private boolean isConstructClause() {
        boolean isConstruct = true;
        for (int i = 0; i < CONSTRUCT.length; ++i) {
            int actCh = this.reader.peek(this.reader.pos() - 1 + i);
            if (actCh == CONSTRUCT[i] || actCh == CONSTRUCT_L[i]) continue;
            isConstruct = false;
            break;
        }
        return isConstruct;
    }

    private boolean isAskClause() {
        boolean isAsk = true;
        for (int i = 0; i < ASK.length; ++i) {
            int actCh = this.reader.peek(this.reader.pos() - 1 + i);
            if (actCh == ASK[i] || actCh == ASK_L[i]) continue;
            isAsk = false;
            break;
        }
        return isAsk;
    }

    private boolean isWhitespace() {
        return Arrays.binarySearch(WHITESPACE, this.ch) >= 0;
    }

    private boolean skipComments() {
        if (this.ch == 35) {
            this.readUntilNext(10);
            return true;
        }
        return false;
    }

    private String readNextBlock() {
        StringBuilder builder = new StringBuilder();
        int openBrack = 1;
        while (true) {
            this.read();
            if (this.ch == 123) {
                ++openBrack;
            }
            if (this.ch == 125 && --openBrack == 0) break;
            builder.append((char)this.ch);
        }
        return builder.toString();
    }

    private int read() {
        this.ch = this.reader.read();
        return this.ch;
    }

    private void readUntilNext(int c) {
        while (this.ch >= 0 && this.ch != c) {
            this.read();
        }
    }

    private void reset() {
        this.reader.reset();
        this.ch = this.reader.peek();
    }

    private class PeekStringReader {
        private String str;
        private int length;
        private int next = 0;
        private int mark = 0;

        public PeekStringReader(SOSSplitQueryExtractor sOSSplitQueryExtractor, String str) {
            this.str = str;
            this.length = str.length();
        }

        public int read() {
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next++);
        }

        public int peek(int pos) {
            if (pos >= this.length) {
                return -1;
            }
            return this.str.charAt(pos);
        }

        public int peek() {
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next);
        }

        public int pos() {
            return this.next;
        }

        public void skip(int n) {
            this.next += n;
        }

        public void mark() {
            this.mark = this.next;
        }

        public void reset() {
            this.next = this.mark;
            this.mark = 0;
        }

        public void close() {
            this.str = null;
        }
    }

    static class EmptyBindingSetChecker
    extends AbstractQueryModelVisitor<RuntimeException> {
        boolean hasEmptyVales = false;
        String valueName;

        EmptyBindingSetChecker() {
        }

        public void meet(BindingSetAssignment node) throws RuntimeException {
            if (!this.isOnRootLevelQuery(node)) {
                return;
            }
            if (!node.getBindingSets().iterator().hasNext() && node.getBindingNames().size() == 1) {
                this.hasEmptyVales = true;
                this.valueName = (String)node.getBindingNames().iterator().next();
            }
        }

        private boolean isOnRootLevelQuery(BindingSetAssignment node) {
            Projection parent = this.getParentProjection((QueryModelNode)node);
            return this.getParentProjection((QueryModelNode)parent) == null;
        }

        private Projection getParentProjection(QueryModelNode node) {
            Projection parent = null;
            for (QueryModelNode offer = node.getParentNode(); offer != null; offer = offer.getParentNode()) {
                if (!(offer instanceof Projection)) continue;
                parent = (Projection)offer;
                break;
            }
            return parent;
        }
    }
}

