/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame.handler;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.handler.RepositoryRequestHandler;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class GraphDBRepositoryRequestHandler
implements RepositoryRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(GraphDBRepositoryRequestHandler.class);
    private final SemanticDataManagement dataManagement;

    public GraphDBRepositoryRequestHandler(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }

    public ModelAndView handleDeleteRepositoryRequest(HttpServletRequest request) throws HTTPException {
        String repId = RepositoryInterceptor.getRepositoryID((HttpServletRequest)request);
        logger.info("DELETE request invoked for repository '" + repId + "'");
        if (request.getParameter("query") != null) {
            logger.warn("query supplied on repository delete request, aborting delete");
            throw new HTTPException(400, "Repository delete error: query supplied with request");
        }
        try {
            boolean success = this.dataManagement.removeRepositoryFromLocation(this.getCurrentLocation(), repId);
            if (success) {
                logger.info("DELETE request successfully completed");
                return new ModelAndView((View)EmptySuccessView.getInstance());
            }
            logger.error("error while attempting to delete repository '" + repId + "'");
            throw new HTTPException(400, "could not locate repository configuration for repository '" + repId + "'.");
        }
        catch (RDF4JException e) {
            logger.error("error while attempting to delete repository '" + repId + "'", (Throwable)e);
            throw new ServerHTTPException("Repository delete error: " + e.getMessage(), (Throwable)e);
        }
    }

    public ModelAndView handleCreateOrUpdateRepositoryRequest(HttpServletRequest request) throws IOException, HTTPException {
        String repId = RepositoryInterceptor.getRepositoryID((HttpServletRequest)request);
        logger.info("PUT request invoked for repository '" + repId + "'");
        try {
            RepositoryManager repositoryManager = this.getRepositoryManager();
            if (repositoryManager.hasRepositoryConfig(repId)) {
                ErrorInfo errorInfo = new ErrorInfo(ErrorType.REPOSITORY_EXISTS, "repository already exists: " + repId);
                throw new ClientHTTPException(409, errorInfo.toString());
            }
            Model model = Rio.parse((InputStream)request.getInputStream(), (String)"http://www.openrdf.org/config/repository#", (RDFFormat)((RDFFormat)Rio.getParserFormatForMIMEType((String)request.getContentType()).orElseThrow(() -> new HTTPException(400, "unrecognized content type " + request.getContentType()))), (Resource[])new Resource[0]);
            RepositoryConfig config = RepositoryConfigUtil.getRepositoryConfig((Model)model, (String)repId);
            if (config == null) {
                throw new RepositoryConfigException("could not read repository config from supplied data");
            }
            repositoryManager.addRepositoryConfig(config);
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (RepositoryConfigException e) {
            ErrorInfo errorInfo = new ErrorInfo(ErrorType.MALFORMED_DATA, "Supplied repository configuration is invalid: " + e.getMessage());
            throw new ClientHTTPException(400, errorInfo.toString());
        }
        catch (RDF4JException e) {
            logger.error("error while attempting to create/configure repository '" + repId + "'", (Throwable)e);
            throw new ServerHTTPException("Repository create error: " + e.getMessage(), (Throwable)e);
        }
    }

    private RepositoryManager getRepositoryManager() {
        return this.getCurrentLocation().sesameManager();
    }

    private SemanticLocation getCurrentLocation() {
        return this.dataManagement.getCurrentLocationOrThrow();
    }
}

