/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame.handler;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.sesame.ControllerUtil;
import com.ontotext.graphdb.sesame.GraphQueryResultView;
import com.ontotext.graphdb.sesame.TupleQueryResultView;
import com.ontotext.graphdb.sesame.sos.SOSSplitQuery;
import com.ontotext.trree.SailConnectionImpl;
import com.ontotext.trree.SystemGraphs;
import it.unibz.inf.ontop.rdf4j.query.impl.OntopBooleanQuery;
import it.unibz.inf.ontop.rdf4j.query.impl.OntopGraphQuery;
import it.unibz.inf.ontop.rdf4j.query.impl.OntopTupleQuery;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.repository.BooleanQueryResultView;
import org.eclipse.rdf4j.http.server.repository.handler.DefaultQueryRequestHandler;
import org.eclipse.rdf4j.http.server.repository.resolver.RepositoryResolver;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.AbstractParserQuery;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.springframework.web.servlet.View;

public class GraphDBQueryResultHandler
extends DefaultQueryRequestHandler {
    protected static final String COUNT_PARAM_NAME = "count";
    protected static final String EXPLAIN_PARAM_NAME = "explain";
    protected static final String EXPLAIN_TYPE_PARAM_NAME = "explainType";
    protected static final IRI COUNT_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/count");
    protected static final IRI EXPLAIN_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/explain");

    public GraphDBQueryResultHandler(RepositoryResolver repositoryResolver) {
        super(repositoryResolver);
    }

    public Query getQuery(HttpServletRequest request, RepositoryConnection repositoryCon, String queryString) throws IOException, HTTPException {
        if ("true".equalsIgnoreCase(request.getHeader("X-GraphDB-SplitQuery"))) {
            SOSSplitQuery splitQuery;
            int limit = Integer.MAX_VALUE;
            if (request.getHeader("X-GraphDB-SplitQueryLimit") != null) {
                limit = Integer.parseInt(request.getHeader("X-GraphDB-SplitQueryLimit"));
            }
            if ((splitQuery = SOSSplitQuery.parse(queryString, limit)).getRootQuery().hasSubSteps()) {
                int numOfThreads = Config.getPropertyAsInt((String)"graphdb.sos.cluster.numOfThreads", (int)1);
                splitQuery.setParserOp(arg_0 -> ((RepositoryConnection)repositoryCon).prepareTupleQuery(arg_0));
                splitQuery.build(numOfThreads);
                this.setQueryParameters(request, repositoryCon, (Query)splitQuery);
                return splitQuery;
            }
        }
        return super.getQuery(request, repositoryCon, queryString);
    }

    protected Object evaluateQuery(Query query, long limit, long offset, boolean distinct) throws ClientHTTPException {
        if (query instanceof SOSSplitQuery) {
            return this.evaluateSoSplitQuery((SOSSplitQuery)query);
        }
        return super.evaluateQuery(query, limit, offset, distinct);
    }

    protected TupleQueryResult evaluateSoSplitQuery(SOSSplitQuery query) {
        return query.evaluate();
    }

    protected SimpleDataset getDataset(HttpServletRequest request, ValueFactory valueFactory, Query query) throws ClientHTTPException {
        if (query instanceof OntopTupleQuery || query instanceof OntopGraphQuery || query instanceof OntopBooleanQuery) {
            return null;
        }
        SimpleDataset dataset = super.getDataset(request, valueFactory, query);
        boolean isCount = ControllerUtil.parseBoolean(request.getParameter(COUNT_PARAM_NAME), false);
        boolean isExplain = ControllerUtil.parseBoolean(request.getParameter(EXPLAIN_PARAM_NAME), false);
        boolean isSameAs = ControllerUtil.parseBoolean(request.getParameter("sameAs"), true);
        if (isCount || isExplain || !isSameAs) {
            Dataset queryDataset;
            if (dataset == null) {
                dataset = new SimpleDataset();
            }
            if ((queryDataset = query.getDataset()) == null && query instanceof AbstractParserQuery) {
                queryDataset = ((AbstractParserQuery)query).getActiveDataset();
            }
            if (queryDataset != null && !queryDataset.getDefaultGraphs().isEmpty() && dataset.getDefaultGraphs().isEmpty()) {
                for (IRI g : queryDataset.getDefaultGraphs()) {
                    dataset.addDefaultGraph(g);
                }
            }
            if (!isSameAs) {
                dataset.addDefaultGraph(SystemGraphs.DISABLE_SAMEAS_GRAPH.getUri());
            }
            if (isCount) {
                dataset.addDefaultGraph(COUNT_URI);
            } else if (isExplain) {
                String explainType = request.getParameter(EXPLAIN_TYPE_PARAM_NAME);
                if ("gpt".equals(explainType)) {
                    dataset.addDefaultGraph(SailConnectionImpl.EXPLAIN_URI_GPT);
                } else {
                    dataset.addDefaultGraph(EXPLAIN_URI);
                }
            }
        }
        return dataset;
    }

    protected View getViewFor(Query query) {
        if (query instanceof TupleQuery) {
            return TupleQueryResultView.getInstance();
        }
        if (query instanceof GraphQuery) {
            return GraphQueryResultView.getInstance();
        }
        if (query instanceof BooleanQuery) {
            return BooleanQueryResultView.getInstance();
        }
        return null;
    }
}

