/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.ontotext.graphdb.sesame.GDBRDFHandler;
import com.ontotext.graphdb.sesame.QueryResultViewBase;
import com.ontotext.rio.jsonld.JSONLD11AbstractRDFWriter;
import com.ontotext.rio.jsonld.JsonLDUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;

public class GraphQueryResultView
extends QueryResultViewBase<RDFWriterFactory, RDFFormat> {
    private static final GraphQueryResultView INSTANCE = new GraphQueryResultView();

    public static GraphQueryResultView getInstance() {
        return INSTANCE;
    }

    private GraphQueryResultView() {
    }

    @Override
    protected RDFFormat getResultFormat(RDFWriterFactory factory) {
        return factory.getRDFFormat();
    }

    @Override
    protected void renderQueryResult(Map model, HttpServletRequest request, HttpServletResponse response, RDFWriterFactory writerFactory, RDFFormat format, OutputStream out) {
        RDFWriter rdfWriter = writerFactory.getWriter(out);
        if (rdfWriter instanceof JSONLD11AbstractRDFWriter) {
            JsonLDUtils.JsonLDProfile jsonLDProfile = JsonLDUtils.parseProfile((String)request.getHeader("Accept"), (String)request.getHeader("Link"));
            ((JSONLD11AbstractRDFWriter)rdfWriter).setProfile(jsonLDProfile);
            ((JSONLD11AbstractRDFWriter)rdfWriter).setRepoConnection((RepositoryConnection)model.get("connection"));
        }
        GraphQueryResult graphQueryResult = (GraphQueryResult)model.get("queryResult");
        QueryResults.report((GraphQueryResult)graphQueryResult, (RDFHandler)new GDBRDFHandler(rdfWriter));
    }
}

