/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.config.AbstractParameter;
import com.ontotext.config.Memory;
import com.ontotext.config.Parameter;
import com.ontotext.config.ParametersSource;
import com.ontotext.rio.jsonld.GraphDBJSONLD11Writer;
import com.ontotext.trree.util.RuntimeOutOfMemoryException;
import java.util.Collection;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.rdfjson.RDFJSONWriter;

public class GDBRDFHandler
implements RDFWriter,
RDFHandler {
    private final RDFWriter delegate;
    protected final boolean isNotStreaming;
    protected long statementCounter = 0L;
    private static final AbstractParameter.MemoryParameter FREE_MEMORY_THRESHOLD = new AbstractParameter.MemoryParameter("graphdb.free.memory.threshold", Memory.of((String)"500m"));
    protected long memorySafetyMargin;

    public GDBRDFHandler(RDFWriter rdfWriter) {
        this.delegate = rdfWriter;
        this.isNotStreaming = this.delegate instanceof RDFJSONWriter || this.delegate instanceof GraphDBJSONLD11Writer;
        this.memorySafetyMargin = ((Memory)ParametersSource.parameters().get((Parameter)FREE_MEMORY_THRESHOLD)).getValue();
    }

    public void startRDF() throws RDFHandlerException {
        this.delegate.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        this.delegate.endRDF();
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.delegate.handleNamespace(prefix, uri);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        ++this.statementCounter;
        if (this.isNotStreaming && this.statementCounter % 10000L == 0L) {
            this.checkMemorySafetyMargin();
        }
        this.delegate.handleStatement(st);
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.delegate.handleComment(comment);
    }

    public RDFFormat getRDFFormat() {
        return this.delegate.getRDFFormat();
    }

    public RDFWriter setWriterConfig(WriterConfig config) {
        return this.delegate.setWriterConfig(config);
    }

    public WriterConfig getWriterConfig() {
        return this.delegate.getWriterConfig();
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        return this.delegate.getSupportedSettings();
    }

    public <T> RDFWriter set(RioSetting<T> setting, T value) {
        return this.delegate.set(setting, value);
    }

    @VisibleForTesting
    protected void checkMemorySafetyMargin() {
        long freeMemory;
        long totalMemory;
        long usedMemory;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long availableMemory = maxMemory - (usedMemory = (totalMemory = runtime.totalMemory()) - (freeMemory = runtime.freeMemory()));
        if (availableMemory < this.memorySafetyMargin) {
            throw new RuntimeOutOfMemoryException("File size exceeds available memory");
        }
    }
}

