/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ContextsController
extends org.eclipse.rdf4j.http.server.repository.contexts.ContextsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextsController.class);

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)ProtocolUtil.getAcceptableService((HttpServletRequest)request, (HttpServletResponse)response, (FileFormatServiceRegistry)TupleQueryResultWriterRegistry.getInstance());
        if ("GET".equals(request.getMethod())) {
            try (RepositoryConnection repositoryConnection = RepositoryInterceptor.getRepositoryConnection((HttpServletRequest)request);
                 RepositoryResult contextIter = repositoryConnection.getContextIDs();){
                List<String> columnNames = List.of("contextID");
                Integer limit = this.parsePaginationParameter(request, "limit");
                List<BindingSet> contexts = this.collectContexts((CloseableIteration<? extends Resource>)contextIter, columnNames, limit);
                this.populateModel(model, columnNames, contexts, factory, repositoryConnection, request);
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
        return new ModelAndView((View)TupleQueryResultView.getInstance(), model);
    }

    private Integer parsePaginationParameter(HttpServletRequest request, String paramName) {
        String paramValue = request.getParameter(paramName);
        try {
            return paramValue == null ? null : Integer.valueOf(Integer.parseInt(paramValue));
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Invalid pagination parameter {}: {}. Exception: {}", new Object[]{paramName, paramValue, e.getMessage()});
            return null;
        }
    }

    private List<BindingSet> collectContexts(CloseableIteration<? extends Resource> contextIter, List<String> columnNames, Integer limit) throws RepositoryException {
        ArrayList<BindingSet> contexts = new ArrayList<BindingSet>();
        if (limit == null) {
            while (contextIter.hasNext()) {
                contexts.add(this.createBindingSet(columnNames, (Resource)contextIter.next()));
            }
        } else {
            for (int count = 0; contextIter.hasNext() && count < limit; ++count) {
                contexts.add(this.createBindingSet(columnNames, (Resource)contextIter.next()));
            }
        }
        return contexts;
    }

    private void populateModel(Map<String, Object> model, List<String> columnNames, List<BindingSet> contexts, TupleQueryResultWriterFactory factory, RepositoryConnection repositoryCon, HttpServletRequest request) {
        model.put("queryResult", new IteratingTupleQueryResult(columnNames, contexts));
        model.put("filenameHint", "contexts");
        model.put("factory", factory);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        model.put("connection", repositoryCon);
    }

    private BindingSet createBindingSet(List<String> columnNames, Resource context) {
        return new ListBindingSet(columnNames, new Value[]{context});
    }
}

