/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.http;

import com.ontotext.graphdb.http.RequestFilter;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class DefaultRequestFilter
implements RequestFilter {
    public static final RequestFilter INSTANCE = new DefaultRequestFilter();

    @Override
    public boolean canHandleByFollower(HttpServletRequest servletRequest) {
        return this.isAlreadyProxied(servletRequest);
    }

    protected boolean isAlreadyProxied(HttpServletRequest servletRequest) {
        String proxiedHeader = servletRequest.getHeader("X-GraphDB-Proxied-From");
        return StringUtils.hasText((String)proxiedHeader) && proxiedHeader.startsWith("cluster-proxy;");
    }
}

