/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.role;

import com.google.common.collect.ImmutableSet;
import com.ontotext.graphdb.security.Role;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public final class RoleToSpring {
    private static final EnumMap<Role, GrantedAuthority> ROLE_TO_GRANTED_AUTHORITY = new EnumMap(Role.class);
    private static final EnumMap<Role, Set<GrantedAuthority>> ROLE_TO_EXPANDED_GRANTED_AUTHORITIES = new EnumMap(Role.class);

    public static GrantedAuthority toGrantedAuthority(Role role) {
        return ROLE_TO_GRANTED_AUTHORITY.get(role);
    }

    public static Set<GrantedAuthority> expandGrantedAuthorities(Role role) {
        return ROLE_TO_EXPANDED_GRANTED_AUTHORITIES.getOrDefault(role, Collections.emptySet());
    }

    static {
        for (Role role : Role.values()) {
            SimpleGrantedAuthority ga = new SimpleGrantedAuthority(role.name());
            ROLE_TO_GRANTED_AUTHORITY.put(role, (GrantedAuthority)ga);
            ImmutableSet.Builder expandedGaBuilder = ImmutableSet.builder();
            expandedGaBuilder.add((Object)ga);
            role.getInherits().forEach(ir -> expandedGaBuilder.add((Object)new SimpleGrantedAuthority(ir.name())));
            ROLE_TO_EXPANDED_GRANTED_AUTHORITIES.put(role, (Set<GrantedAuthority>)expandedGaBuilder.build());
        }
    }
}

