/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ontotext.forest.security.AuthenticatedAuthenticationToken;
import com.ontotext.forest.security.role.RoleToSpring;
import com.ontotext.graphdb.security.Role;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AuthenticatedUser
implements UserDetails,
CredentialsContainer {
    private String username;
    private String password;
    @JsonDeserialize(contentAs=SimpleGrantedAuthority.class)
    @JsonSerialize(contentAs=SimpleGrantedAuthority.class)
    private Collection<? extends GrantedAuthority> authorities;
    private Map<String, Object> appSettings;
    private boolean external;

    public AuthenticatedUser() {
        this(null, null, null, false, null);
    }

    public AuthenticatedUser(String username, String password, Collection<? extends GrantedAuthority> authorities, boolean external, Map<String, Object> appSettings) {
        this.username = username;
        this.password = password;
        this.authorities = authorities != null ? authorities : new LinkedList<GrantedAuthority>();
        this.external = external;
        if (appSettings != null) {
            this.appSettings = appSettings;
        }
    }

    public void eraseCredentials() {
        this.password = "[CREDENTIALS]";
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public int hashCode() {
        return (String.valueOf(this.getClass()) + this.username).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthenticatedUser) {
            return this.username.equals(((AuthenticatedUser)obj).username);
        }
        return false;
    }

    public Map<String, Object> getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(Map<String, Object> appSettings) {
        this.appSettings = appSettings;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getExpandedAuthorities() {
        HashSet expandedAuthorities = new HashSet();
        this.getAuthorities().forEach(a -> {
            try {
                expandedAuthorities.addAll(RoleToSpring.expandGrantedAuthorities(Role.valueOf((String)a.getAuthority())));
            }
            catch (IllegalArgumentException e) {
                expandedAuthorities.add(a);
            }
        });
        return expandedAuthorities;
    }

    public AuthenticatedAuthenticationToken toAuthentication() {
        return new AuthenticatedAuthenticationToken(this);
    }
}

