/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4.hl;

import com.ontotext.trree.plugin.externalsync.api.SnippetResult;
import com.ontotext.trree.sdk.PluginException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;

public final class HLHelperFastVector {
    private final String[] fields;
    private final IndexSearcher searcher;
    private final int snippetSize;
    private FieldQuery fieldQuery = null;
    private FastVectorHighlighter highlighter = null;
    private static final String[] POST_TAGS = new String[]{"</span>"};

    public HLHelperFastVector(String[] fields, Query query, IndexSearcher searcher, String snippetPre, String snippetPost, int snippetSize) {
        this.fields = fields;
        this.searcher = searcher;
        this.snippetSize = snippetSize;
        this.highlighter = HLHelperFastVector.getHighlighter(snippetPre, snippetPost);
        try {
            this.fieldQuery = this.highlighter.getFieldQuery(query, searcher.getIndexReader());
        }
        catch (IOException e) {
            throw new PluginException("Couldn't create field query...", (Throwable)e);
        }
    }

    public Collection<SnippetResult> getSnippetsForResultIndex(TopDocs topDocs, int index) {
        ArrayList<SnippetResult> snippets = new ArrayList<SnippetResult>(this.fields.length);
        try {
            for (String field : this.fields) {
                int maxNumFragments = 20;
                String[] s = this.highlighter.getBestFragments(this.fieldQuery, this.searcher.getIndexReader(), topDocs.scoreDocs[index].doc, field, this.snippetSize, maxNumFragments);
                if (s == null) continue;
                SnippetResult snippetResult = new SnippetResult(field, Arrays.asList(s));
                snippets.add(snippetResult);
            }
        }
        catch (IOException e) {
            throw new PluginException("Couldn't retrieve snippet", (Throwable)e);
        }
        return snippets;
    }

    private static FastVectorHighlighter getHighlighter(String pre, String post) {
        String[] preTags = new String[]{pre};
        String[] postTags = new String[]{post};
        SimpleFragListBuilder fragListBuilder = new SimpleFragListBuilder();
        ScoreOrderFragmentsBuilder fragmentsBuilder = new ScoreOrderFragmentsBuilder(preTags, postTags);
        return new FastVectorHighlighter(true, true, (FragListBuilder)fragListBuilder, (FragmentsBuilder)fragmentsBuilder);
    }
}

