/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import com.google.common.collect.ImmutableSet;
import com.ontotext.graphdb.Config;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.ConnectorException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.api.SyncDocument;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.OptionsUtil;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.CreateAnalyzerUtil;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Keep2CommitsPolicy;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4Plugin;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4SearchOptions;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.QueryUtils;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.plugin.externalsync.util.ValuesUtil;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.SearcherTaxonomyManager;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.facet.taxonomy.writercache.LruTaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.json.simple.JSONObject;

public final class Lucene4ExternalStore
extends AbstractExternalStore<Document> {
    private static final String FIELD_TYPES_KEY = "fieldTypes";
    private static final String INDEXED_FIELDS_KEY = "indexedFields";
    private static final String TAXONOMY_SUBDIR = "taxonomy";
    private static final IndexDeletionPolicy DELETION_POLICY = new Keep2CommitsPolicy();
    private static final FieldType TYPE_FTS_STORED_WITH_VECTORS = new FieldType();
    public static final String FIELD_SUBJECT = "subject";
    private static final String FIELD_BOOST = "boost";
    private static final String NON_LITERAL_TYPE = "<non-literal>";
    private static final boolean STORED_ENABLED = Config.getPropertyAsBoolean((String)"graphdb.connectors.lucene.enable-stored", (boolean)false);
    private static final int DEFAULT_CACHE_SIZE = 4000;
    private boolean indexedAtLeastOne;
    Map<String, String> fieldTypes = new HashMap<String, String>();
    Map<String, Boolean> indexedFields = new LinkedHashMap<String, Boolean>();
    String[] indexedFieldsArray = new String[0];
    private static final Set<IRI> supportedDatatypes = ImmutableSet.builder().add((Object)XSD.LONG).add((Object)XSD.INT).add((Object)XSD.DOUBLE).add((Object)XSD.FLOAT).add((Object)XSD.DATETIME).add((Object)XSD.DATE).add((Object)XSD.BOOLEAN).add((Object)XSD.STRING).build();
    private final Set<String> existingFields = new LinkedHashSet<String>();
    private SearcherTaxonomyManager searcherManager;
    private IndexWriter indexWriter;
    private DirectoryTaxonomyWriter taxonomyWriter;
    private final FacetsConfig facetsConfig;
    private final File indexDir;
    private FSDirectory luceneDir;
    private FSDirectory taxonomyDir;
    private ThreadLocal<QueryParser> defaultBoostsQueryParser;
    Analyzer searchAnalyzer;
    private final long[] boostProperties;
    private final FunctionQuery docBoostScoringQuery;

    static Lucene4ExternalStore open(String name, Options options, Lucene4Plugin plugin, PluginConnection pluginConnection) {
        return new Lucene4ExternalStore(name, options, false, 0L, plugin, pluginConnection, pluginConnection.getEntities());
    }

    static Lucene4ExternalStore create(String name, Options options, Lucene4Plugin plugin, PluginConnection pluginConnection, Entities entitiesForCreation) throws IOException {
        Lucene4ExternalStore handler = new Lucene4ExternalStore(name, options, true, 0L, plugin, pluginConnection, entitiesForCreation);
        handler.createIndex(true);
        return handler;
    }

    private Lucene4ExternalStore(String name, Options options, boolean wasJustCreated, long initialFingerprint, Lucene4Plugin plugin, PluginConnection pluginConnection, Entities entities) {
        super(name, options, wasJustCreated, initialFingerprint, (ExternalSyncPlugin)plugin, pluginConnection, entities);
        List boostOption = (List)options.getValueOr(Lucene4Plugin.BOOST_PROPERTIES, new ArrayList());
        this.boostProperties = OptionsUtil.resolveAllEntities((Collection)boostOption, (Entities)entities);
        if (this.hasBoostProperty()) {
            FloatFieldSource docBoostValueSource = new FloatFieldSource(FIELD_BOOST);
            this.docBoostScoringQuery = new FunctionQuery((ValueSource)docBoostValueSource);
        } else {
            this.docBoostScoringQuery = null;
        }
        this.facetsConfig = new FacetsConfig();
        if (!wasJustCreated) {
            for (Property property : this.getProperties()) {
                if (!property.isIndexed()) continue;
                this.indexedFields.put(property.getFieldNameWithoutSuffix(), property.isAnalyzed());
            }
            this.updateIndexedFieldsArray();
        }
        this.indexedAtLeastOne = false;
        this.indexDir = new File(plugin.getDataDir(), name);
    }

    protected void createIndex(boolean cleanupAfterFailure) {
        try {
            this.indexDir.mkdirs();
            if (!this.indexDir.exists() || !this.indexDir.isDirectory()) {
                throw new ConnectorServerException("Cannot create index directory " + this.indexDir.getAbsolutePath());
            }
            this.init();
        }
        catch (Exception e) {
            if (cleanupAfterFailure) {
                try {
                    this.remove(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e instanceof ConnectorException) {
                throw e;
            }
            throw new ConnectorServerException("Unable to create connector: " + e.getMessage(), (Throwable)e);
        }
    }

    private void openPrevious() throws IOException {
        this.open(Keep2CommitsPolicy.getPreviousCommit((Directory)this.luceneDir));
    }

    private void open(@Nullable IndexCommit commit) throws IOException {
        Analyzer analyzer = CreateAnalyzerUtil.createAnalyzerFromClassName((String)this.options.getValue(Lucene4Plugin.analyzer));
        IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        iwc.setIndexDeletionPolicy(DELETION_POLICY);
        if (commit != null) {
            iwc.setIndexCommit(commit);
        }
        this.indexWriter = new IndexWriter((Directory)this.luceneDir, iwc);
        this.taxonomyWriter = new DirectoryTaxonomyWriter((Directory)this.taxonomyDir, IndexWriterConfig.OpenMode.CREATE_OR_APPEND, (TaxonomyWriterCache)new LruTaxonomyWriterCache(4000));
        this.searcherManager = new SearcherTaxonomyManager(this.indexWriter, true, null, this.taxonomyWriter);
    }

    protected Document newNativeDocument() {
        return new Document();
    }

    protected boolean syncEntity(long subject, long predicate, long context, SyncDocument<Document> syncDoc, List<Property> propertiesToSync, @Nonnull Entities entities, Statements statements, boolean skip) {
        boolean anyProperty = this.syncEntityToDocument(syncDoc, subject, predicate, context, propertiesToSync, entities, statements);
        if (anyProperty) {
            float docBoost = this.computeDocumentBoost(subject, entities, statements);
            this.applyDocumentBoost((Document)syncDoc.nativeDocument, docBoost);
            String subjectUri = EntitiesUtil.valueToString((Value)entities.get(subject));
            ((Document)syncDoc.nativeDocument).add((IndexableField)new StringField(FIELD_SUBJECT, subjectUri, Field.Store.YES));
            if (this.convertSyncDocumentToNativeDocument(syncDoc, propertiesToSync)) {
                try {
                    if (!skip) {
                        this.indexWriter.updateDocument(this.getSubjectTerm(subjectUri), (Iterable)this.facetsConfig.build((TaxonomyWriter)this.taxonomyWriter, (Document)syncDoc.nativeDocument));
                    }
                    this.indexedAtLeastOne = true;
                    return true;
                }
                catch (IOException e) {
                    throw new ClientErrorException("Unable to index document.", (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean writePropertyValueToNativeDocument(Document doc, Property property, String fieldName, Value value) {
        indexedAny = false;
        if (!(Lucene4ExternalStore.$assertionsDisabled || property.isIndexed() || property.isStored() || property.isFacet())) {
            throw new AssertionError();
        }
        if (!property.isMultivalued() && doc.get(fieldName) != null) {
            return false;
        }
        strValue = EntitiesUtil.valueToString((Value)value);
        field = null;
        sortField = null;
        storeField = null;
        v0 = stored = Lucene4ExternalStore.STORED_ENABLED != false && property.isStored() != false;
        if (property.isAnalyzed() && property.isIndexed()) {
            type = property.getNativeType();
            if (type == null && (type = this.fieldTypes.get(fieldName)) == null) {
                if (value instanceof Literal) {
                    uriType = ((Literal)value).getDatatype();
                    type = this.getNativeTypeFromDatatype((IRI)uriType, property.isMultivalued());
                    if (type == null) {
                        type = "string";
                    }
                } else {
                    type = "<non-literal>";
                }
            }
            try {
                uriType = type;
                var13_14 = -1;
                switch (uriType.hashCode()) {
                    case 3327612: {
                        if (!uriType.equals("long")) break;
                        var13_14 = 0;
                        break;
                    }
                    case 104431: {
                        if (!uriType.equals("int")) break;
                        var13_14 = 1;
                        break;
                    }
                    case -1325958191: {
                        if (!uriType.equals("double")) break;
                        var13_14 = 2;
                        break;
                    }
                    case 97526364: {
                        if (!uriType.equals("float")) break;
                        var13_14 = 3;
                        break;
                    }
                    case 1792749467: {
                        if (!uriType.equals("dateTime")) break;
                        var13_14 = 4;
                        break;
                    }
                    case 3076014: {
                        if (!uriType.equals("date")) break;
                        var13_14 = 5;
                        break;
                    }
                    case 64711720: {
                        if (!uriType.equals("boolean")) break;
                        var13_14 = 6;
                        break;
                    }
                    case 485370539: {
                        if (!uriType.equals("<non-literal>")) break;
                        var13_14 = 7;
                        break;
                    }
                    case -891985903: {
                        if (!uriType.equals("string")) break;
                        var13_14 = 8;
                    }
                }
                switch (var13_14) {
                    case 0: {
                        field = new LongPoint(fieldName, new long[]{this.asLiteral(value).longValue()});
                        break;
                    }
                    case 1: {
                        field = new IntPoint(fieldName, new int[]{this.asLiteral(value).intValue()});
                        break;
                    }
                    case 2: {
                        field = new DoublePoint(fieldName, new double[]{this.asLiteral(value).doubleValue()});
                        break;
                    }
                    case 3: {
                        field = new FloatPoint(fieldName, new float[]{this.asLiteral(value).floatValue()});
                        break;
                    }
                    case 4: {
                        safeLiteralValue = EntitiesUtil.valueToString((Value)this.asLiteral(value));
                        dateTimeValue = ValuesUtil.INSTANCE.xsdTemporalAsNormalizedCompactISO(safeLiteralValue, XSD.DATETIME);
                        if (dateTimeValue.length() > 14) {
                            this.logger.warn("[{}] Indexing dateTime value that is out of range of lexicographic search: {}", (Object)this.name, (Object)safeLiteralValue);
                        }
                        field = new Field(fieldName, (CharSequence)dateTimeValue, (IndexableFieldType)StringField.TYPE_NOT_STORED);
                        break;
                    }
                    case 5: {
                        safeLiteralValue = EntitiesUtil.valueToString((Value)this.asLiteral(value));
                        dateValue = ValuesUtil.INSTANCE.xsdTemporalAsNormalizedCompactDateOnlyISO(safeLiteralValue, XSD.DATE);
                        if (dateValue.length() > 8) {
                            this.logger.warn("[{}] Indexing date value that is out of range of lexicographic search: {}", (Object)this.name, (Object)safeLiteralValue);
                        }
                        field = new Field(fieldName, (CharSequence)dateValue, (IndexableFieldType)StringField.TYPE_NOT_STORED);
                        break;
                    }
                    case 6: {
                        booleanValue = this.asLiteral(value).booleanValue();
                        field = new Field(fieldName, (CharSequence)Boolean.toString(booleanValue), (IndexableFieldType)(stored != false ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED));
                        break;
                    }
                    case 7: {
                        field = this.nonAnalyzedField(fieldName, strValue, stored);
                        break;
                    }
                    default: {
                        type = "string";
                        if (((Boolean)this.options.getValueOr(Lucene4Plugin.stripMarkup, (Object)false)).booleanValue()) {
                            strValue = QueryUtils.stripMarkup(strValue);
                        }
                        field = new Field(fieldName, (CharSequence)strValue, (IndexableFieldType)(property.isStored() != false ? Lucene4ExternalStore.TYPE_FTS_STORED_WITH_VECTORS : TextField.TYPE_NOT_STORED));
                    }
                }
                if (!property.isMultivalued()) {
                    uriType = type;
                    var13_14 = -1;
                    switch (uriType.hashCode()) {
                        case 3327612: {
                            if (!uriType.equals("long")) break;
                            var13_14 = 0;
                            break;
                        }
                        case 104431: {
                            if (!uriType.equals("int")) break;
                            var13_14 = 1;
                            break;
                        }
                        case -1325958191: {
                            if (!uriType.equals("double")) break;
                            var13_14 = 2;
                            break;
                        }
                        case 97526364: {
                            if (!uriType.equals("float")) break;
                            var13_14 = 3;
                            break;
                        }
                        case 1792749467: {
                            if (!uriType.equals("dateTime")) break;
                            var13_14 = 4;
                            break;
                        }
                        case 3076014: {
                            if (!uriType.equals("date")) break;
                            var13_14 = 5;
                            break;
                        }
                        case 64711720: {
                            if (!uriType.equals("boolean")) break;
                            var13_14 = 6;
                            break;
                        }
                        case -891985903: {
                            if (!uriType.equals("string")) break;
                            var13_14 = 7;
                            break;
                        }
                        case 485370539: {
                            if (!uriType.equals("<non-literal>")) break;
                            var13_14 = 8;
                        }
                    }
                    switch (var13_14) {
                        case 0: {
                            sortField = new NumericDocValuesField(fieldName, this.asLiteral(value).longValue());
                            break;
                        }
                        case 1: {
                            sortField = new NumericDocValuesField(fieldName, (long)this.asLiteral(value).intValue());
                            break;
                        }
                        case 2: {
                            sortField = new DoubleDocValuesField(fieldName, this.asLiteral(value).doubleValue());
                            break;
                        }
                        case 3: {
                            sortField = new FloatDocValuesField(fieldName, this.asLiteral(value).floatValue());
                            break;
                        }
                        case 4: {
                            sortField = new NumericDocValuesField(fieldName, ValuesUtil.INSTANCE.xsdTemporalAsMillis(strValue, XSD.DATETIME));
                            break;
                        }
                        case 5: {
                            sortField = new NumericDocValuesField(fieldName, ValuesUtil.INSTANCE.xsdTemporalAsMillis(strValue, XSD.DATE));
                            break;
                        }
                        case 6: {
                            booleanValue = this.asLiteral(value).booleanValue();
                            sortField = new NumericDocValuesField(fieldName, booleanValue != false ? 1L : 0L);
                            break;
                        }
                        default: {
                            sortField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)strValue));
                        }
                    }
                }
                if (stored) {
                    uriType = type;
                    var13_14 = -1;
                    switch (uriType.hashCode()) {
                        case 3327612: {
                            if (!uriType.equals("long")) break;
                            var13_14 = 0;
                            break;
                        }
                        case 104431: {
                            if (!uriType.equals("int")) break;
                            var13_14 = 1;
                            break;
                        }
                        case -1325958191: {
                            if (!uriType.equals("double")) break;
                            var13_14 = 2;
                            break;
                        }
                        case 97526364: {
                            if (!uriType.equals("float")) break;
                            var13_14 = 3;
                        }
                    }
                    switch (var13_14) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            storeField = new StoredField(fieldName, strValue);
                        }
                    }
                }
                if (this.fieldTypes.containsKey(fieldName)) ** GOTO lbl199
                this.fieldTypes.put(fieldName, type);
                this.dynamicOptionsUpdated = true;
            }
            catch (RuntimeException e) {
                if (property.isIgnoreInvalidValues()) {
                    this.notifyIgnoreInvalidValue(fieldName, type, value);
                    return false;
                }
                throw e;
            }
        } else {
            if (property.isIndexed()) {
                field = this.nonAnalyzedField(fieldName, strValue, stored);
            }
            if (!property.isMultivalued()) {
                sortField = this.sortField(fieldName, strValue);
            }
        }
lbl199:
        // 5 sources

        if (field != null) {
            if (property.isIndexed() && this.indexedFields.put(fieldName, property.isAnalyzed()) == null) {
                this.dynamicOptionsUpdated = true;
            }
            doc.add((IndexableField)field);
            if (sortField != null) {
                doc.add((IndexableField)sortField);
            }
            if (storeField != null) {
                doc.add(storeField);
            }
            indexedAny = true;
        }
        if (property.isFacet()) {
            if (property.isMultivalued()) {
                this.facetsConfig.setMultiValued(fieldName, true);
            }
            if (!strValue.isEmpty()) {
                doc.add((IndexableField)new FacetField(fieldName, new String[]{strValue}));
                indexedAny = true;
            } else {
                this.logger.debug("[{}] Skipping empty value for field {}", (Object)this.name, (Object)fieldName);
            }
        }
        this.existingFields.add(fieldName);
        this.logger.debug("[{}] Indexing: '{}' = '{}'", new Object[]{this.name, fieldName, value});
        return indexedAny;
    }

    private Field nonAnalyzedField(String fieldName, String strValue, boolean stored) {
        return new Field(fieldName, (CharSequence)strValue, (IndexableFieldType)(stored ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED));
    }

    private Field sortField(String fieldName, String strValue) {
        return new SortedDocValuesField(fieldName, new BytesRef((CharSequence)strValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float computeDocumentBoost(long subject, Entities entities, Statements statements) {
        float boost = 1.0f;
        for (long property : this.boostProperties) {
            try (StatementIterator sit = statements.get(subject, property, 0L);){
                while (sit.next()) {
                    boost *= this.getFloatValueForBoost(subject, property, sit.object, entities);
                }
            }
        }
        return boost;
    }

    private float getFloatValueForBoost(long subject, long property, long object, Entities entities) {
        Value v = entities.get(object);
        if (v instanceof Literal) {
            try {
                return ((Literal)v).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ClientErrorException(String.valueOf(entities.get(subject)) + " has invalid boostProperty (" + String.valueOf(entities.get(property)) + ") value: " + String.valueOf(v));
    }

    private void applyDocumentBoost(Document doc, float boost) {
        doc.add((IndexableField)new NumericDocValuesField(FIELD_BOOST, (long)Float.floatToIntBits(boost)));
    }

    protected void deleteEntity(long subject, Value subjectValue) {
        try {
            this.indexWriter.deleteDocuments(new Term[]{this.getSubjectTerm(EntitiesUtil.valueToString((Value)subjectValue))});
        }
        catch (IOException e) {
            throw new ClientErrorException("Unable to refresh entity.", (Throwable)e);
        }
    }

    Term getSubjectTerm(String subjectUri) {
        return new Term(FIELD_SUBJECT, subjectUri);
    }

    public void drop(boolean force) throws Exception {
        this.closeLuceneResources();
        super.drop(force);
    }

    public void close() throws IOException {
        this.closeLuceneResources();
        super.close();
    }

    private void closeLuceneResources() {
        try {
            if (this.searcherManager != null) {
                this.searcherManager.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.name + "] Error closing Lucene searcher manager.", (Throwable)e);
        }
        try {
            if (this.taxonomyWriter != null) {
                this.taxonomyWriter.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.name + "] Error closing Lucene connector taxonomy writer.", (Throwable)e);
        }
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.name + "] Error closing Lucene connector index writer.", (Throwable)e);
        }
    }

    Query parseQuery(String queryStr, Lucene4SearchOptions searchOptions, boolean scoreBQRewrite) throws ParseException {
        QueryParser parser = searchOptions.boosts == null ? this.defaultBoostsQueryParser.get() : this.createQueryParser(searchOptions.boosts);
        parser.setMultiTermRewriteMethod(scoreBQRewrite ? MultiTermQuery.SCORING_BOOLEAN_REWRITE : MultiTermQuery.CONSTANT_SCORE_REWRITE);
        return parser.parse(queryStr);
    }

    private QueryParser createQueryParser(Map<String, Float> boosts) {
        return QueryUtils.createQueryParser(this, boosts);
    }

    SearcherTaxonomyManager.SearcherAndTaxonomy acquireSearcher() throws IOException {
        return (SearcherTaxonomyManager.SearcherAndTaxonomy)this.searcherManager.acquire();
    }

    void releaseSearcherQuietly(SearcherTaxonomyManager.SearcherAndTaxonomy searcher) {
        try {
            this.searcherManager.release((Object)searcher);
        }
        catch (IOException e) {
            this.logger.error("[" + this.name + "] Error releasing an IndexSearcher", (Throwable)e);
        }
    }

    public String toString() {
        return "lucene4index: " + this.name;
    }

    public boolean transactionCompleted(PluginConnection pluginConnection) {
        boolean hasCommitted = false;
        if (this.initialised.get()) {
            try {
                this.commit();
            }
            catch (IOException e) {
                throw new ClientErrorException("[" + this.name + "] Unable to commit Lucene4 transaction.", (Throwable)e);
            }
            hasCommitted = this.indexedAtLeastOne;
            this.indexedAtLeastOne = false;
        }
        super.transactionCompleted(pluginConnection);
        return hasCommitted;
    }

    private void commit() throws IOException {
        long time = System.currentTimeMillis();
        this.taxonomyWriter.commit();
        time = System.currentTimeMillis() - time;
        this.logger.debug("[{}] taxonomyWriter.commit() took {}ms", (Object)this.name, (Object)time);
        time = System.currentTimeMillis();
        this.indexWriter.commit();
        time = System.currentTimeMillis() - time;
        this.logger.debug("[{}] indexWriter.commit() took {}ms", (Object)this.name, (Object)time);
        time = System.currentTimeMillis();
        this.searcherManager.maybeRefresh();
        time = System.currentTimeMillis() - time;
        this.logger.debug("[{}] searcherManager.maybeRefresh() took {}ms", (Object)this.name, (Object)time);
        if (this.indexedFields.size() != this.indexedFieldsArray.length) {
            this.updateIndexedFieldsArray();
        }
    }

    private void updateIndexedFieldsArray() {
        this.indexedFieldsArray = this.indexedFields.keySet().toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackCurrent(PluginConnection pluginConnection) throws IOException {
        super.rollbackCurrent(pluginConnection);
        if (this.initialised.get()) {
            Lucene4ExternalStore lucene4ExternalStore = this;
            synchronized (lucene4ExternalStore) {
                this.indexedAtLeastOne = false;
                try {
                    this.searcherManager.close();
                    this.taxonomyWriter.rollback();
                }
                catch (Exception e) {
                    this.logger.warn("[" + this.name + "] Error on rollback() of taxonomyWriter, continuing anyway.", (Throwable)e);
                }
                try {
                    this.taxonomyDir.close();
                }
                catch (Exception e) {
                    this.logger.warn("[" + this.name + "] Error on close() of taxonomyDir, continuing anyway.", (Throwable)e);
                }
                try {
                    this.indexWriter.rollback();
                }
                catch (Exception e) {
                    this.logger.warn("[" + this.name + "] Error on rollback() of indexWriter, continuing anyway.", (Throwable)e);
                }
                try {
                    this.luceneDir.close();
                }
                catch (Exception e) {
                    this.logger.warn("[" + this.name + "] Error on close() of luceneDir, continuing anyway.", (Throwable)e);
                }
                try {
                    this.searchAnalyzer.close();
                }
                catch (Exception e) {
                    this.logger.warn("[" + this.name + "] Error on close() of searchAnalyzer, continuing anyway.", (Throwable)e);
                }
                this.initialised.set(false);
                this.init();
            }
        }
    }

    public void rollbackLastCommitted(PluginConnection pluginConnection) throws IOException {
        super.rollbackLastCommitted(pluginConnection);
        if (this.initialised.get()) {
            this.indexedAtLeastOne = false;
            this.closeLuceneResources();
            this.openPrevious();
        }
    }

    public ExternalRetrieve createRetrieve(MasterResultIterator mri, ExternalSyncRequestContext requestContext) {
        this.init();
        return new Lucene4ExternalRetrieve(this.logger, this, mri, requestContext, this);
    }

    @Nonnull
    public List<String> getSyncedFields() {
        ArrayList<String> result = new ArrayList<String>();
        for (String field : this.existingFields) {
            if (!this.isValidFieldName(field, true)) continue;
            result.add(field);
        }
        return result;
    }

    public FunctionQuery getDocBoostScoringQuery() {
        return this.docBoostScoringQuery;
    }

    FacetsConfig getFacetsConfig() {
        return this.facetsConfig;
    }

    boolean hasBoostProperty() {
        return this.boostProperties.length > 0;
    }

    public long[] getExtraPropertiesToListenFor() {
        long[] parentExtraProperties = super.getExtraPropertiesToListenFor();
        long[] allProperties = new long[parentExtraProperties.length + this.boostProperties.length];
        System.arraycopy(parentExtraProperties, 0, allProperties, 0, parentExtraProperties.length);
        System.arraycopy(this.boostProperties, 0, allProperties, parentExtraProperties.length, this.boostProperties.length);
        return allProperties;
    }

    protected boolean isValidFieldNameImplementation(String fieldName, boolean isTopField) {
        return true;
    }

    protected String getNativeTypeFromDatatype(IRI datatype, boolean multivalued) {
        if (supportedDatatypes.contains(datatype)) {
            return datatype.getLocalName();
        }
        return null;
    }

    public void removeAllEntities() {
        try {
            this.init();
            this.indexWriter.deleteAll();
            super.removeAllEntities();
        }
        catch (IOException e) {
            throw new ClientErrorException("Unable to remove documents.", (Throwable)e);
        }
    }

    public JSONObject getSettingsAsJSON() {
        JSONObject settings = super.getSettingsAsJSON();
        settings.put((Object)FIELD_TYPES_KEY, this.fieldTypes);
        settings.put((Object)INDEXED_FIELDS_KEY, this.indexedFields);
        return settings;
    }

    public void setSettingsFromJSON(JSONObject json) {
        JSONObject indexedFieldsJson;
        super.setSettingsFromJSON(json);
        JSONObject fieldTypesObject = (JSONObject)json.get((Object)FIELD_TYPES_KEY);
        if (fieldTypesObject != null) {
            this.fieldTypes = new HashMap<String, String>((Map<String, String>)fieldTypesObject);
        }
        if ((indexedFieldsJson = (JSONObject)json.get((Object)INDEXED_FIELDS_KEY)) != null) {
            this.indexedFields = new LinkedHashMap<String, Boolean>((Map<String, Boolean>)indexedFieldsJson);
            this.updateIndexedFieldsArray();
        }
    }

    protected void initImpl() {
        try {
            this.luceneDir = FSDirectory.open((Path)this.indexDir.toPath());
            File taxonomyDirFile = new File(this.indexDir, TAXONOMY_SUBDIR);
            taxonomyDirFile.mkdirs();
            this.taxonomyDir = FSDirectory.open((Path)taxonomyDirFile.toPath());
            this.open(null);
            this.searchAnalyzer = QueryUtils.createSearchAnalyzer(this.indexWriter.getAnalyzer());
            List properties = this.getProperties();
            HashMap<String, Float> propertiesWithFloatWeights = new HashMap<String, Float>(properties.size());
            for (Property p : properties) {
                if (p.getPropertyParam() == null) continue;
                propertiesWithFloatWeights.put(p.getFieldNameWithoutSuffix(), Float.valueOf(Float.parseFloat(p.getPropertyParam())));
            }
            this.defaultBoostsQueryParser = new QueryUtils.ThreadLocalQueryParser(this, propertiesWithFloatWeights);
        }
        catch (Exception e) {
            this.closeLuceneResources();
            this.luceneDir = null;
            this.taxonomyDir = null;
            this.indexWriter = null;
            this.searchAnalyzer = null;
            this.defaultBoostsQueryParser = null;
            throw new PluginException("Unable to init Lucene index.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthResult runHealthCheckInternal() {
        SearcherTaxonomyManager.SearcherAndTaxonomy searcherAndTaxonomy = null;
        try {
            searcherAndTaxonomy = this.acquireSearcher();
            MatchAllDocsQuery query = new MatchAllDocsQuery();
            long startTime = System.currentTimeMillis();
            TopDocs topDocs = searcherAndTaxonomy.searcher.search((Query)query, 1);
            long endTime = System.currentTimeMillis();
            long hits = topDocs.totalHits.value;
            String message = String.format("query took %d ms, %d hits", endTime - startTime, hits);
            if (hits == 0L) {
                HealthResult healthResult = new HealthResult(this.name, HealthResult.Status.YELLOW, message);
                return healthResult;
            }
            HealthResult healthResult = new HealthResult(this.name, HealthResult.Status.GREEN, message);
            return healthResult;
        }
        catch (Exception e) {
            HealthResult healthResult = new HealthResult(this.name, HealthResult.Status.RED, "query cannot be run: " + e.getMessage());
            return healthResult;
        }
        finally {
            if (searcherAndTaxonomy != null) {
                this.releaseSearcherQuietly(searcherAndTaxonomy);
            }
        }
    }

    protected void applyUpdatedOptions() {
    }

    static {
        TYPE_FTS_STORED_WITH_VECTORS.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        TYPE_FTS_STORED_WITH_VECTORS.setStored(true);
        TYPE_FTS_STORED_WITH_VECTORS.setStoreTermVectors(true);
        TYPE_FTS_STORED_WITH_VECTORS.setStoreTermVectorOffsets(true);
        TYPE_FTS_STORED_WITH_VECTORS.setStoreTermVectorPositions(true);
        TYPE_FTS_STORED_WITH_VECTORS.freeze();
    }
}

