/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.stateless;

import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.graphdb.security.TokenManager;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class SignatureAuthenticationService {
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired
    private AccountsService accountService;

    public Authentication getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token != null && token.startsWith("GDB-Signature ")) {
            if (TokenManager.getInstance().verifyRequest(request, token)) {
                String authContext = request.getHeader("X-GraphDB-Auth-Context");
                if (authContext == null) {
                    throw new BadCredentialsException("Missing signature context");
                }
                if (authContext.equals("full")) {
                    return this.securityConfig.getRemoteAuthentication();
                }
                if (authContext.startsWith("user;")) {
                    String username = authContext.substring("user;".length());
                    return this.accountService.loadUserByUsername(username).toAuthentication();
                }
                throw new BadCredentialsException("Invalid signature context: " + authContext);
            }
            throw new BadCredentialsException("Invalid signature");
        }
        return null;
    }
}

