/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import java.util.List;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

public class OpenIdAudienceValidator
implements OAuth2TokenValidator<Jwt> {
    private final String audience;

    OpenIdAudienceValidator(String audience) {
        this.audience = audience;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        List audiences = jwt.getAudience();
        if (audiences == null) {
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "Missing aud claim", null)});
        }
        if (!audiences.contains(this.audience)) {
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "The aud claim is not valid", null)});
        }
        return OAuth2TokenValidatorResult.success();
    }
}

