/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.ldap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.ontotext.forest.security.provider.ldap.LdapConfig;
import com.ontotext.forest.security.provider.ldap.LdapDirectGrantedAuthority;
import com.ontotext.forest.security.role.RoleToSpring;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.security.Role;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;

public class LdapAuthoritiesMapper
implements GrantedAuthoritiesMapper {
    private final boolean caseInsensitive;
    private final String administratorRole;
    private final String repoManagerRole;
    private final Multimap<String, String> repositoryReadRoles;
    private final Multimap<String, String> repositoryWriteRoles;
    private final Multimap<String, String> genericRoles;

    public LdapAuthoritiesMapper(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        this.administratorRole = this.stringWithCaseSetting(Config.getProperty((String)"graphdb.auth.ldap.role.map.administrator"));
        this.repoManagerRole = this.stringWithCaseSetting(Config.getProperty((String)"graphdb.auth.ldap.role.map.repositoryManager"));
        this.repositoryReadRoles = ArrayListMultimap.create();
        this.repositoryWriteRoles = ArrayListMultimap.create();
        this.genericRoles = ArrayListMultimap.create();
        Config.getProperties().forEach((property, value) -> {
            String repository;
            if (property.startsWith("graphdb.auth.ldap.role.map.repository.read.") && !(repository = property.substring("graphdb.auth.ldap.role.map.repository.read.".length())).isEmpty()) {
                this.repositoryReadRoles.put((Object)this.stringWithCaseSetting((String)value), (Object)repository);
            }
            if (property.startsWith("graphdb.auth.ldap.role.map.repository.write.") && !(repository = property.substring("graphdb.auth.ldap.role.map.repository.write.".length())).isEmpty()) {
                this.repositoryWriteRoles.put((Object)this.stringWithCaseSetting((String)value), (Object)repository);
            }
            if (property.startsWith("graphdb.auth.ldap.role.map.graphdb.")) {
                String role = property.substring("graphdb.auth.ldap.role.map.graphdb.".length());
                if ((role = LdapConfig.normalizeRole(role)) == null) {
                    throw new RuntimeException(String.format("Invalid role specified in property '%s', it must be one of the GraphDB roles", property));
                }
                this.genericRoles.put((Object)this.stringWithCaseSetting((String)value), (Object)role);
            }
        });
    }

    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> ldapAuthorities) {
        HashSet<Object> mappedAuthorities = new HashSet<Object>();
        Role assignedRole = Role.ROLE_USER;
        for (GrantedAuthority grantedAuthority : ldapAuthorities) {
            if (grantedAuthority instanceof LdapDirectGrantedAuthority) {
                mappedAuthorities.add(((LdapDirectGrantedAuthority)grantedAuthority).toSimpleGrantedAuthority());
                continue;
            }
            String authority = this.stringWithCaseSetting(grantedAuthority.getAuthority());
            if (authority.equals(this.administratorRole)) {
                assignedRole = Role.ROLE_ADMIN;
            }
            if (assignedRole != Role.ROLE_ADMIN && authority.equals(this.repoManagerRole)) {
                assignedRole = Role.ROLE_REPO_MANAGER;
            }
            this.repositoryReadRoles.get((Object)authority).forEach(repository -> mappedAuthorities.add(new SimpleGrantedAuthority(Role.Repo.readForRepo((String)repository))));
            this.repositoryWriteRoles.get((Object)authority).forEach(repository -> {
                mappedAuthorities.add(new SimpleGrantedAuthority(Role.Repo.readForRepo((String)repository)));
                mappedAuthorities.add(new SimpleGrantedAuthority(Role.Repo.writeForRepo((String)repository)));
            });
            this.genericRoles.get((Object)authority).forEach(role -> mappedAuthorities.add(new SimpleGrantedAuthority(role)));
        }
        mappedAuthorities.add(RoleToSpring.toGrantedAuthority((Role)assignedRole));
        return mappedAuthorities;
    }

    private String stringWithCaseSetting(String string) {
        return this.caseInsensitive && string != null ? string.toLowerCase() : string;
    }
}

