/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.persistence;

import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.core.semantic.repository.RepositoryIdChangedListener;
import com.ontotext.forest.security.SecurityConfig;
import jakarta.inject.Named;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class RenamedRepoAccountListener
extends RepositoryIdChangedListener {
    @Autowired
    private AccountsService accountsService;
    @Autowired
    private SecurityConfig securityConfig;

    protected void updateAfterChangedRepoId(String oldRepoId, String newRepoId) {
        if (this.accountsService.isLocal()) {
            for (Account account : this.accountsService.getAll()) {
                HashSet<CallSite> newAuthorities = new HashSet<CallSite>();
                HashSet<String> deleteAuthorities = new HashSet<String>();
                for (String authority : account.getGrantedAuthorities()) {
                    if (!authority.endsWith(oldRepoId)) continue;
                    String newAuthority = authority.substring(0, authority.lastIndexOf(oldRepoId)) + newRepoId;
                    newAuthorities.add((CallSite)((Object)newAuthority));
                    deleteAuthorities.add(authority);
                }
                account.getGrantedAuthorities().removeAll(deleteAuthorities);
                account.getGrantedAuthorities().addAll(newAuthorities);
                this.accountsService.editUserAccount(account, false);
            }
        }
        LinkedList<String> newDefaultAuthorities = new LinkedList<String>();
        for (String authority : this.securityConfig.getFreeAccessAuthorities()) {
            if (authority.endsWith(oldRepoId)) {
                String newAuthority = authority.substring(0, authority.lastIndexOf(oldRepoId)) + newRepoId;
                newDefaultAuthorities.add(newAuthority);
                continue;
            }
            newDefaultAuthorities.add(authority);
        }
        this.securityConfig.setFreeAccessAuthorities(newDefaultAuthorities);
    }
}

