/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.custom.roles;

import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.custom.roles.CustomRoleException;
import com.ontotext.graphdb.security.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomRoleService {
    private static final Logger logger = LoggerFactory.getLogger(CustomRoleService.class);
    @Autowired
    private AccountsService accountsService;

    public Map<String, List<String>> getAllRoles() {
        TreeMap<String, List<String>> usersWithRoles = new TreeMap<String, List<String>>();
        this.accountsService.getAll().forEach(account -> account.getGrantedAuthorities().stream().filter(role -> role.startsWith("CUSTOM_")).forEach(role -> usersWithRoles.computeIfAbsent((String)role, k -> new ArrayList()).add(account.getUsername())));
        return usersWithRoles;
    }

    public Set<String> getUsersForRole(String roleName) {
        this.validateRoleName(roleName);
        LinkedHashSet<String> users = new LinkedHashSet<String>();
        this.accountsService.getAll().forEach(account -> {
            if (account.getGrantedAuthorities().contains(roleName.toUpperCase())) {
                users.add(account.getUsername());
            }
        });
        return users;
    }

    public void setUsersForRole(Set<String> usernames, String roleName) {
        this.validateRoleName(roleName);
        this.validateUsernamesExist(usernames);
        this.accountsService.getAll().forEach(account -> {
            LinkedHashSet<String> grantedAuthorities = new LinkedHashSet<String>(account.getGrantedAuthorities());
            boolean userWasChanged = usernames.contains(account.getUsername()) ? grantedAuthorities.add(roleName.toUpperCase()) : grantedAuthorities.remove(roleName.toUpperCase());
            if (userWasChanged) {
                account.setGrantedAuthorities(grantedAuthorities);
                this.accountsService.editUserAccount(account, false);
            }
        });
    }

    public void addUsersToRole(Set<String> usernames, String roleName) {
        this.validateRoleName(roleName);
        this.validateUsernamesExist(usernames);
        usernames.forEach(user -> {
            Account account = this.accountsService.getAccount(user);
            if (account != null) {
                LinkedHashSet<String> grantedAuthorities = new LinkedHashSet<String>(account.getGrantedAuthorities());
                grantedAuthorities.add(roleName.toUpperCase());
                account.setGrantedAuthorities(grantedAuthorities);
                this.accountsService.editUserAccount(account, false);
            } else {
                logger.warn("Possible race condition with user account management: {}", user);
            }
        });
    }

    public void deleteUsersFromRole(Set<String> usernames, String roleName) {
        this.validateRoleName(roleName);
        usernames.forEach(user -> {
            Account account = this.accountsService.getAccount(user);
            if (account != null) {
                Collection grantedAuthorities = account.getGrantedAuthorities();
                grantedAuthorities.remove(roleName.toUpperCase());
                account.setGrantedAuthorities(grantedAuthorities);
                this.accountsService.editUserAccount(account, false);
            }
        });
    }

    public void setAllRoles(Map<String, Set<String>> customRoles) {
        HashSet unprocessedUsers = new HashSet();
        customRoles.forEach((roleName, usernames) -> {
            this.validateRoleName((String)roleName);
            this.validateUsernamesExist((Set<String>)usernames);
            unprocessedUsers.addAll(usernames);
        });
        this.accountsService.getAll().forEach(account -> {
            HashSet removedRoles = new HashSet();
            LinkedHashSet addedRoles = new LinkedHashSet();
            Set updatedRoles = account.getGrantedAuthorities().stream().filter(r -> {
                boolean isCustomRole = r.startsWith("CUSTOM_");
                if (isCustomRole) {
                    removedRoles.add(r);
                }
                return !isCustomRole;
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            customRoles.forEach((roleName, usernames) -> {
                if (usernames.contains(account.getUsername())) {
                    addedRoles.add(roleName.toUpperCase());
                }
            });
            if (!addedRoles.equals(removedRoles)) {
                updatedRoles.addAll(addedRoles);
                account.setGrantedAuthorities((Collection)updatedRoles);
                this.accountsService.editUserAccount(account, false);
            }
            unprocessedUsers.remove(account.getUsername());
        });
        unprocessedUsers.forEach(user -> logger.warn("Possible race condition with user account management: {}", user));
    }

    private void validateRoleName(String roleName) {
        try {
            Role.validateCustomRole((String)roleName.toUpperCase(), null);
        }
        catch (IllegalArgumentException e) {
            throw new CustomRoleException(e.getMessage());
        }
    }

    private void validateUsernamesExist(Set<String> usernames) {
        Optional<String> nonExisting = usernames.stream().filter(user -> this.accountsService.getAccount(user) == null).findFirst();
        if (nonExisting.isPresent()) {
            throw new CustomRoleException(String.format("User %s doesn't exist.", nonExisting.get()));
        }
    }
}

