/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.acl;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.graphdb.security.ACLUtils;
import com.ontotext.graphdb.security.AccessControlEntry;
import com.ontotext.graphdb.security.ClearGraphAccessControlEntry;
import com.ontotext.graphdb.security.PluginAccessControlEntry;
import com.ontotext.graphdb.security.StatementAccessControlEntry;
import com.ontotext.graphdb.security.SystemAccessControlEntry;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import com.ontotext.trree.monitorRepository.MonitorRepositoryConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.Repository;
import org.springframework.stereotype.Service;

@Service
public class AccessControlService {
    public List<AccessControlEntry> listAclRules(String repositoryID, SemanticLocation location, String scope, String operation, String subject, String predicate, String object, String context, String plugin, String role, String policy) {
        ArrayList<AccessControlEntry> matchingRules = new ArrayList<AccessControlEntry>();
        try (MonitorRepositoryConnection connection = this.getRepositoryConnection(repositoryID, location);){
            List aclRules = connection.getSailConnectionImpl().getAclRules();
            for (AccessControlEntry rule : aclRules) {
                if (scope != null && AccessControlEntry.Scope.fromValue((String)scope) != rule.getScope() || !this.hasMatchingOperation(operation, rule) || !this.hasMatchingSubject(subject, rule) || !this.hasMatchingPredicate(predicate, rule) || !this.hasMatchingObject(object, rule) || !this.hasMatchingContext(context, rule) || !this.hasMatchingPlugin(plugin, rule) || policy != null && rule.getPolicy() != AccessControlEntry.Policy.fromValue((String)policy) || role != null && !rule.getRole().equalsIgnoreCase(role)) continue;
                matchingRules.add(rule);
            }
            ArrayList<AccessControlEntry> arrayList = matchingRules;
            return arrayList;
        }
    }

    private boolean hasMatchingOperation(String operation, AccessControlEntry ace) {
        if (operation == null) {
            return true;
        }
        AccessControlEntry.Operation ot = AccessControlEntry.Operation.fromValue((String)operation);
        return ace instanceof StatementAccessControlEntry && ((StatementAccessControlEntry)ace).getOperation() == ot || ace instanceof PluginAccessControlEntry && ((PluginAccessControlEntry)ace).getOperation() == ot || ace instanceof SystemAccessControlEntry && ((SystemAccessControlEntry)ace).getOperation() == ot;
    }

    private boolean hasMatchingSubject(String subject, AccessControlEntry ace) {
        return subject == null || ace instanceof StatementAccessControlEntry && this.matchesRdfValue((Value)((StatementAccessControlEntry)ace).getSubject(), subject);
    }

    private boolean hasMatchingPredicate(String predicate, AccessControlEntry ace) {
        return predicate == null || ace instanceof StatementAccessControlEntry && this.matchesRdfValue((Value)((StatementAccessControlEntry)ace).getPredicate(), predicate);
    }

    private boolean hasMatchingObject(String object, AccessControlEntry ace) {
        return object == null || ace instanceof StatementAccessControlEntry && this.matchesRdfValue(((StatementAccessControlEntry)ace).getObject(), object);
    }

    private boolean hasMatchingContext(String context, AccessControlEntry ace) {
        return context == null || ace instanceof StatementAccessControlEntry && this.matchesRdfValue((Value)((StatementAccessControlEntry)ace).getContext(), context) || ace instanceof ClearGraphAccessControlEntry && this.matchesRdfValue((Value)((ClearGraphAccessControlEntry)ace).getContext(), context);
    }

    private boolean hasMatchingPlugin(String plugin, AccessControlEntry ace) {
        return plugin == null || ace instanceof PluginAccessControlEntry && ACLUtils.serializeWildcardable((Object)((PluginAccessControlEntry)ace).getPlugin(), Function.identity()).equals(plugin);
    }

    private boolean matchesRdfValue(Value value, String strValue) {
        return ACLUtils.serializeValue((Value)value).equals(strValue);
    }

    public void addAclRules(String repositoryID, SemanticLocation location, List<AccessControlEntry> aclRulesToUpdate, Integer position) {
        try (MonitorRepositoryConnection connection = this.getRepositoryConnection(repositoryID, location);){
            connection.begin();
            ArrayList<AccessControlEntry> rules = new ArrayList<AccessControlEntry>(connection.getSailConnectionImpl().getAclRules());
            AccessControlService.validateUniqueACLRules(aclRulesToUpdate, rules);
            if (position == null) {
                rules.addAll(aclRulesToUpdate);
            } else {
                rules.addAll(position, aclRulesToUpdate);
            }
            connection.getSailConnectionImpl().setAclRules(rules);
            connection.commit();
        }
    }

    public void deleteAclRules(String repositoryID, SemanticLocation location, List<AccessControlEntry> aclRulesToDelete) {
        try (MonitorRepositoryConnection connection = this.getRepositoryConnection(repositoryID, location);){
            connection.begin();
            ArrayList rules = new ArrayList(connection.getSailConnectionImpl().getAclRules());
            rules.removeAll(aclRulesToDelete);
            connection.getSailConnectionImpl().setAclRules(rules);
            connection.commit();
        }
    }

    public void updateAclRules(String repositoryID, SemanticLocation location, List<AccessControlEntry> aclRulesToUpdate) {
        AccessControlService.validateUniqueACLRules(aclRulesToUpdate, List.of());
        try (MonitorRepositoryConnection connection = this.getRepositoryConnection(repositoryID, location);){
            connection.begin();
            connection.getSailConnectionImpl().setAclRules(aclRulesToUpdate);
            connection.commit();
        }
    }

    private MonitorRepositoryConnection getRepositoryConnection(String repositoryID, SemanticLocation location) {
        Repository repository = location.getRepository(repositoryID).getRepository();
        if (repository instanceof MonitorRepository) {
            return (MonitorRepositoryConnection)repository.getConnection();
        }
        throw new GraphDBWorkbenchException("Repository must be a GraphDB repository: " + repositoryID);
    }

    private static void validateUniqueACLRules(List<AccessControlEntry> aclRulesToUpdate, List<AccessControlEntry> rules) {
        HashSet<AccessControlEntry> uniqueRules = new HashSet<AccessControlEntry>(aclRulesToUpdate);
        if (uniqueRules.size() != aclRulesToUpdate.size()) {
            throw new IllegalArgumentException();
        }
        for (AccessControlEntry rule : rules) {
            if (!uniqueRules.contains(rule)) continue;
            throw new IllegalArgumentException();
        }
    }
}

