/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.AuthenticationMethod;
import com.ontotext.forest.security.provider.ldap.LdapAccountsService;
import com.ontotext.forest.security.provider.local.LocalAccountsService;
import com.ontotext.forest.security.provider.openid.OAuthAccountsService;
import com.ontotext.forest.security.role.RoleToSpring;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.ConfigException;
import com.ontotext.graphdb.ServerMaintenanceListener;
import com.ontotext.graphdb.security.Role;
import com.ontotext.license.LicenseRegistry;
import com.ontotext.license.LicenseValidationException;
import com.ontotext.license.LicenseValidationHook;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.trree.statistics.SystemStatisticsCollector;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

@Named(value="securityConfig")
public class SecurityConfig
implements ApplicationEventPublisherAware,
ServerMaintenanceListener {
    private final ResourceUtils resourceUtils;
    public static final String DEFAULT_USERNAME = "admin";
    public static final String SECURITY_ENABLED_KEY = "security.enabled";
    public static final String SECURITY_FREE_ACCESS_KEY = "security.free.access";
    public static final String SECURITY_FREE_ACCESS_AUTHORITIES = "security.free.access.authorities";
    public static final String SECURITY_FREE_ACCESS_SETTINGS = "security.free.access.settings";
    public static final String SECURITY_DEFAULT_AUTH_SETTINGS = "security.default.auth.settings";
    public static final String SECURITY_DEFAULT_AUTH_ENABLED = "graphdb.workbench.default.auth";
    public static final String DATABASE_CASE_INSENSITIVE = "graphdb.auth.database.case_insensitive";
    public static final String REAUTHORIZE_ATTRIBUTE = "graphdb-reauthorize";
    private static final String AUTH_DATABASE_PROPERTY_NAME = "graphdb.auth.database";
    private static final String AUTH_DATABASE_LEGACY_PROPERTY_NAME = "graphdb.auth.module";
    private static final String KERBEROS_AUTH_ENABLED_LEGACY_PROPERTY_NAME = "graphdb.auth.kerberos.enabled";
    private static final String FREE_ACCESS_USERNAME = "<free access user>";
    private static final String OVERRIDE_USERNAME = "<override user>";
    private static final String REMOTE_USERNAME = "<remote user>";
    private final List<LicenseValidationHook> licenseValidationHooks = new ArrayList<LicenseValidationHook>();
    private boolean enableSecurity;
    private boolean enableFreeAccess;
    private boolean enabledDefaultAuth;
    private Class<? extends AccountsService> accountsServiceImplClass;
    private boolean basicAuthEnabled;
    private boolean gdbAuthEnabled;
    private boolean x509AuthEnabled;
    private boolean kerberosAuthEnabled;
    private boolean openIdAuthEnabled;
    private List<String> freeAccessAuthorities = new ArrayList<String>();
    private Map<String, Object> freeAccessSettings = new HashMap<String, Object>();
    private Map<String, Object> defaultAuthSettings = new HashMap<String, Object>();
    private ApplicationEventPublisher publisher;
    private Authentication freeAccessAuthentication;
    private Authentication overrideAuthentication;
    private Authentication remoteAuthentication;
    @Autowired
    private SemanticDataManagement dataManagement;

    @Autowired
    public SecurityConfig(ResourceUtils resourceUtils) {
        this.resourceUtils = resourceUtils;
    }

    @PostConstruct
    public void init() {
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
        this.enableSecurity = (Boolean)this.resourceUtils.getProperty(SECURITY_ENABLED_KEY);
        this.enableFreeAccess = (Boolean)this.resourceUtils.getProperty(SECURITY_FREE_ACCESS_KEY);
        this.enabledDefaultAuth = (Boolean)this.resourceUtils.getProperty(SECURITY_DEFAULT_AUTH_ENABLED);
        SystemStatisticsCollector.getInstance().updateSecurityOnChange(this.enableSecurity);
        Stream.of(((String)this.resourceUtils.getProperty(SECURITY_FREE_ACCESS_AUTHORITIES)).split(",")).filter(s -> !s.isEmpty()).forEach(this.freeAccessAuthorities::add);
        Stream.of(((String)this.resourceUtils.getProperty(SECURITY_FREE_ACCESS_SETTINGS)).split(",")).filter(s -> !s.isEmpty()).forEach(s -> {
            String[] sp = s.split("=", 2);
            Object value = this.readSettingValue(sp);
            this.freeAccessSettings.put(sp[0], value);
        });
        Stream.of(((String)this.resourceUtils.getProperty(SECURITY_DEFAULT_AUTH_SETTINGS)).split(",")).filter(s -> !s.isEmpty()).forEach(s -> {
            String[] sp = s.split("=", 2);
            Object value = this.readSettingValue(sp);
            this.defaultAuthSettings.put(sp[0], value);
        });
        this.updateFreeAccessAuthentication();
        this.updateOverrideAuthentication();
        this.remoteAuthentication = new AuthenticatedUser(REMOTE_USERNAME, "", Collections.singletonList(RoleToSpring.toGrantedAuthority((Role)Role.ROLE_ADMIN)), false, Collections.emptyMap()).toAuthentication();
        String authDB = Config.getPropertyOrLegacyProperty((String)AUTH_DATABASE_PROPERTY_NAME, (String)AUTH_DATABASE_LEGACY_PROPERTY_NAME);
        if (authDB == null) {
            authDB = "local";
        }
        switch (authDB) {
            case "local": {
                this.accountsServiceImplClass = LocalAccountsService.class;
                break;
            }
            case "ldap": {
                this.addLicenseValidationHook("LDAP for authorization");
                this.accountsServiceImplClass = LdapAccountsService.class;
                break;
            }
            case "oauth": {
                this.addLicenseValidationHook("OAuth for authorization");
                this.accountsServiceImplClass = OAuthAccountsService.class;
                break;
            }
            default: {
                throw new ConfigException("Unknown authorization database implementation: " + authDB);
            }
        }
        this.openIdAuthEnabled = false;
        this.kerberosAuthEnabled = false;
        this.x509AuthEnabled = false;
        this.gdbAuthEnabled = false;
        this.basicAuthEnabled = false;
        String authMethods = Config.getProperty((String)"graphdb.auth.methods");
        if (authMethods == null) {
            String authMethodKerberosLegacy = Config.getLegacyProperty((String)"graphdb.auth.methods", (String)KERBEROS_AUTH_ENABLED_LEGACY_PROPERTY_NAME);
            this.basicAuthEnabled = true;
            this.gdbAuthEnabled = true;
            if (Boolean.parseBoolean(authMethodKerberosLegacy)) {
                this.kerberosAuthEnabled = true;
            }
        } else {
            String[] authMethodsValues;
            String[] stringArray = authMethodsValues = authMethods.split("\\s*,\\s*");
            int n = stringArray.length;
            block24: for (int i = 0; i < n; ++i) {
                String authMethodValue;
                switch (authMethodValue = stringArray[i]) {
                    case "basic": {
                        this.basicAuthEnabled = true;
                        this.checkSupportedAuthDatabaseAndMethod(authDB, authMethodValue, AuthenticationMethod.Basic.class);
                        continue block24;
                    }
                    case "gdb": {
                        this.gdbAuthEnabled = true;
                        this.checkSupportedAuthDatabaseAndMethod(authDB, authMethodValue, AuthenticationMethod.GDB.class);
                        continue block24;
                    }
                    case "x509": {
                        this.addLicenseValidationHook("X.509 for authentication");
                        this.x509AuthEnabled = true;
                        this.checkSupportedAuthDatabaseAndMethod(authDB, authMethodValue, AuthenticationMethod.X509.class);
                        continue block24;
                    }
                    case "kerberos": {
                        this.addLicenseValidationHook("Kerberos for authentication");
                        this.kerberosAuthEnabled = true;
                        this.checkSupportedAuthDatabaseAndMethod(authDB, authMethodValue, AuthenticationMethod.Kerberos.class);
                        continue block24;
                    }
                    case "openid": {
                        this.addLicenseValidationHook("OpenID for authentication");
                        this.openIdAuthEnabled = true;
                        this.checkSupportedAuthDatabaseAndMethod(authDB, authMethodValue, AuthenticationMethod.OpenId.class);
                        continue block24;
                    }
                    default: {
                        throw new ConfigException("Unsupported authentication method: " + authMethodValue);
                    }
                }
            }
        }
        if (!(this.basicAuthEnabled || this.gdbAuthEnabled || this.x509AuthEnabled || this.kerberosAuthEnabled || this.openIdAuthEnabled)) {
            throw new ConfigException("At least one authentication method must be specified");
        }
    }

    @PreDestroy
    public void destroy() {
        this.licenseValidationHooks.forEach(hook -> LicenseRegistry.getInstance().removeLicenseValidationHook(hook));
    }

    private Object readSettingValue(String[] sp) {
        return switch (sp[0]) {
            case "DEFAULT_SAMEAS", "DEFAULT_INFERENCE", "EXECUTE_COUNT", "DEFAULT_VIS_GRAPH_SCHEMA", "IGNORE_SHARED_QUERIES" -> Boolean.parseBoolean(sp[1]);
            default -> sp[1];
        };
    }

    private void checkSupportedAuthDatabaseAndMethod(String database, String method, Class<?> authInterface) {
        if (!authInterface.isAssignableFrom(this.accountsServiceImplClass)) {
            throw new ConfigException(String.format("Authorization database '%s' does not support authentication method '%s'", database, method));
        }
    }

    public boolean isEnabledSecurity() {
        return this.enableSecurity && !this.hasOverrideAuthority();
    }

    public boolean isEnabledFreeAccess() {
        return this.enableFreeAccess;
    }

    public boolean hasToCheckAuthentication() {
        return this.isEnabledSecurity() || this.hasOverrideAuthority();
    }

    public boolean hasOverrideAuthority() {
        return this.enabledDefaultAuth;
    }

    private void publishEvent(String eventId, String value, boolean withReplication) {
        if (withReplication && this.dataManagement.isClusterExisting()) {
            this.publisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, eventId + ".replicated", value));
        }
        this.publisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, eventId, value));
    }

    public void setEnableFreeAccess(boolean enableFreeAccess) {
        this.setEnableFreeAccess(enableFreeAccess, true);
    }

    public void setEnableFreeAccess(boolean enableFreeAccess, boolean withReplication) {
        if (withReplication) {
            this.validateLeadership();
        }
        this.enableFreeAccess = enableFreeAccess;
        try {
            this.publishEvent(SECURITY_FREE_ACCESS_KEY, Boolean.toString(enableFreeAccess), withReplication);
        }
        catch (RuntimeException e) {
            this.enableFreeAccess = !enableFreeAccess;
            throw e;
        }
    }

    public void setEnabledSecurity(boolean isEnabledSecurity) {
        this.setEnabledSecurity(isEnabledSecurity, true);
    }

    public void setEnabledSecurity(boolean isEnabledSecurity, boolean withReplication) {
        if (withReplication) {
            this.validateLeadership();
        }
        this.enableSecurity = isEnabledSecurity;
        try {
            this.publishEvent(SECURITY_ENABLED_KEY, Boolean.toString(isEnabledSecurity), withReplication);
        }
        catch (RuntimeException e) {
            this.enableSecurity = !isEnabledSecurity;
            throw e;
        }
        SystemStatisticsCollector.getInstance().updateSecurityOnChange(isEnabledSecurity);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public List<String> getFreeAccessAuthorities() {
        return this.freeAccessAuthorities;
    }

    public void setFreeAccessAuthorities(List<String> freeAccessAuthorities) {
        this.setFreeAccessAuthorities(freeAccessAuthorities, true);
    }

    public void setFreeAccessAuthorities(List<String> defaultAuthorities, boolean withReplication) {
        if (withReplication) {
            this.validateLeadership();
        }
        List<String> prevFreeAccessAuthorities = this.getFreeAccessAuthorities();
        this.freeAccessAuthorities = defaultAuthorities;
        this.updateFreeAccessAuthentication();
        try {
            this.publishEvent(SECURITY_FREE_ACCESS_AUTHORITIES, StringUtils.collectionToDelimitedString(defaultAuthorities, (String)","), withReplication);
        }
        catch (RuntimeException e) {
            this.freeAccessAuthorities = prevFreeAccessAuthorities;
            this.updateFreeAccessAuthentication();
            throw e;
        }
    }

    public void setFreeAccessSettings(Map<String, Object> freeAccessSettings) {
        this.setFreeAccessSettings(freeAccessSettings, true);
    }

    public void setFreeAccessSettings(Map<String, Object> freeAccessSettings, boolean withReplication) {
        if (withReplication) {
            this.validateLeadership();
        }
        Map<String, Object> prevAccessSettings = this.getFreeAccessSettings();
        this.freeAccessSettings = freeAccessSettings;
        try {
            this.publishEvent(SECURITY_FREE_ACCESS_SETTINGS, StringUtils.collectionToDelimitedString(freeAccessSettings.entrySet(), (String)","), withReplication);
        }
        catch (RuntimeException e) {
            this.freeAccessSettings = prevAccessSettings;
            throw e;
        }
    }

    public Map<String, Object> getFreeAccessSettings() {
        return this.freeAccessSettings;
    }

    public String getOverrideAuthority() {
        return Role.ROLE_REPO_MANAGER.name();
    }

    public Map<String, Object> getOverrideAuthSettings() {
        return this.defaultAuthSettings;
    }

    public void setOverrideAuthSettings(Map<String, Object> defaultAuthSettings) {
        this.setOverrideAuthSettings(defaultAuthSettings, true);
    }

    public void setOverrideAuthSettings(Map<String, Object> defaultAuthSettings, boolean withReplication) {
        if (withReplication) {
            this.validateLeadership();
        }
        this.defaultAuthSettings = defaultAuthSettings;
        Map<String, Object> prevDefaultAuthSettings = this.getOverrideAuthSettings();
        try {
            this.publishEvent(SECURITY_DEFAULT_AUTH_SETTINGS, StringUtils.collectionToDelimitedString(defaultAuthSettings.entrySet(), (String)","), withReplication);
        }
        catch (RuntimeException e) {
            this.defaultAuthSettings = prevDefaultAuthSettings;
            throw e;
        }
    }

    public Class<? extends AccountsService> getAccountsServiceImplClass() {
        return this.accountsServiceImplClass;
    }

    private void updateFreeAccessAuthentication() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String authority : this.getFreeAccessAuthorities()) {
            authorities.add(new SimpleGrantedAuthority(authority));
        }
        this.freeAccessAuthentication = new AuthenticatedUser(FREE_ACCESS_USERNAME, "", authorities, false, this.getFreeAccessSettings()).toAuthentication();
    }

    public Authentication getFreeAccessAuthentication() {
        return this.freeAccessAuthentication;
    }

    private void updateOverrideAuthentication() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority(this.getOverrideAuthority()));
        this.overrideAuthentication = new AuthenticatedUser(OVERRIDE_USERNAME, "", authorities, false, this.getOverrideAuthSettings()).toAuthentication();
    }

    public Authentication getOverrideAuthentication() {
        return this.overrideAuthentication;
    }

    public Authentication getRemoteAuthentication() {
        return this.remoteAuthentication;
    }

    public String getAuthenticatedUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null ? authentication.getName() : DEFAULT_USERNAME;
    }

    public boolean isUsernameFreeAccess(String username) {
        return FREE_ACCESS_USERNAME.equals(username);
    }

    public boolean isKerberosAuthEnabled() {
        return this.kerberosAuthEnabled;
    }

    public boolean isBasicAuthEnabled() {
        return this.basicAuthEnabled;
    }

    public boolean isGDBAuthEnabled() {
        return this.gdbAuthEnabled;
    }

    public boolean isX509AuthEnabled() {
        return this.x509AuthEnabled;
    }

    public boolean isX509HeaderExtractionEnabled() {
        return this.isX509AuthEnabled() && Config.getPropertyAsBoolean((String)"graphdb.auth.methods.x509.headers", (boolean)false);
    }

    public boolean isDirectPasswordAuthEnabled() {
        return this.basicAuthEnabled || this.gdbAuthEnabled;
    }

    public boolean isOpenIdAuthEnabled() {
        return this.openIdAuthEnabled;
    }

    @VisibleForTesting
    public SecurityConfig copy() {
        SecurityConfig securityConfig = new SecurityConfig(this.resourceUtils);
        securityConfig.init();
        return securityConfig;
    }

    public void unlockAfterMaintenance() {
        this.init();
    }

    private void validateLeadership() {
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster != null) {
            try {
                replicationCluster.validateLeadership();
            }
            catch (UpdateExecutionException e) {
                throw new GraphDBWorkbenchException(e.getMessage());
            }
            if (!replicationCluster.isPrimaryCluster()) {
                throw new GraphDBWorkbenchException("Unable to execute operation as node is in secondary cluster mode.");
            }
        }
    }

    private void addLicenseValidationHook(String feature) {
        LicenseValidationHook licenseValidationHook = license -> {
            if (!license.getProduct().isStandardOrEnterprise()) {
                throw new LicenseValidationException(String.format("Using %s requires a GraphDB Enterprise license but the current license is GraphDB %s. Upgrade to GraphDB Enterprise or change your security config.", feature, StringUtils.capitalize((String)license.getProduct().toHumanReadable())));
            }
        };
        this.licenseValidationHooks.add(licenseValidationHook);
        LicenseRegistry.getInstance().addLicenseValidationHook(licenseValidationHook);
    }
}

