/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.security.MainAuthenticationEntryPoint;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.provider.openid.HeaderParamBearerTokenResolver;
import com.ontotext.forest.security.provider.openid.LoggingBearerTokenAuthenticationEntryPoint;
import com.ontotext.forest.security.stateless.GDBSignatureAuthenticationFilter;
import com.ontotext.forest.security.stateless.GDBTokenAuthenticationFilter;
import com.ontotext.forest.security.x509.X509HeaderExtractionFilter;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.security.TlsContext;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.kerberos.web.authentication.SpnegoAuthenticationProcessingFilter;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationFilter;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.filter.CompositeFilter;

public class MainAuthenticationFilter
extends CompositeFilter {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private MainAuthenticationEntryPoint mainAuthenticationEntryPoint;
    @Autowired
    private SecurityConfig securityConfig;

    @PostConstruct
    public void init() {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.securityConfig.isBasicAuthEnabled()) {
            BasicAuthenticationFilter basic = new BasicAuthenticationFilter(this.authenticationManager, (AuthenticationEntryPoint)this.mainAuthenticationEntryPoint);
            filters.add(basic);
        }
        GDBSignatureAuthenticationFilter signature = (GDBSignatureAuthenticationFilter)((Object)this.applicationContext.getBean(GDBSignatureAuthenticationFilter.class));
        filters.add((Object)signature);
        if (this.securityConfig.isGDBAuthEnabled()) {
            GDBTokenAuthenticationFilter stateless = (GDBTokenAuthenticationFilter)((Object)this.applicationContext.getAutowireCapableBeanFactory().createBean(GDBTokenAuthenticationFilter.class));
            filters.add((Object)stateless);
        }
        if (this.securityConfig.isKerberosAuthEnabled()) {
            SpnegoAuthenticationProcessingFilter spnego = new SpnegoAuthenticationProcessingFilter();
            spnego.setAuthenticationManager(this.authenticationManager);
            spnego.setFailureHandler((AuthenticationFailureHandler)this.mainAuthenticationEntryPoint);
            filters.add(spnego);
        }
        if (this.securityConfig.isX509HeaderExtractionEnabled()) {
            X509HeaderExtractionFilter x509HeaderExtractionFilter = new X509HeaderExtractionFilter(TlsContext.getDefaultTlsContext().getTrustManagers());
            x509HeaderExtractionFilter.setCertificateHeader(Config.getProperty((String)"graphdb.auth.methods.x509.headers.clientCert", (String)x509HeaderExtractionFilter.getCertificateHeader()));
            x509HeaderExtractionFilter.setEscapedCertificateHeader(Config.getProperty((String)"graphdb.auth.methods.x509.headers.escapedClientCert", (String)x509HeaderExtractionFilter.getEscapedCertificateHeader()));
            filters.add((Object)x509HeaderExtractionFilter);
        }
        if (this.securityConfig.isX509AuthEnabled()) {
            X509AuthenticationFilter x509AuthenticationFilter = new X509AuthenticationFilter();
            x509AuthenticationFilter.setAuthenticationManager(this.authenticationManager);
            SubjectDnX509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();
            principalExtractor.setSubjectDnRegex(Config.getProperty((String)"graphdb.auth.methods.x509.subject.dn.pattern", (String)"CN=(.*?)(?:,|$)"));
            x509AuthenticationFilter.setPrincipalExtractor((X509PrincipalExtractor)principalExtractor);
            filters.add(x509AuthenticationFilter);
        }
        if (this.securityConfig.isOpenIdAuthEnabled()) {
            BearerTokenAuthenticationFilter bearer = new BearerTokenAuthenticationFilter(this.authenticationManager);
            bearer.setAuthenticationEntryPoint((AuthenticationEntryPoint)new LoggingBearerTokenAuthenticationEntryPoint());
            bearer.setBearerTokenResolver((BearerTokenResolver)new HeaderParamBearerTokenResolver());
            filters.add(bearer);
        }
        this.setFilters(filters);
    }

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
    }
}

