/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.guardrail;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.rag.AugmentationResult;
import java.util.Map;

public final class GuardrailRequestParams {
    private final ChatMemory chatMemory;
    private final AugmentationResult augmentationResult;
    private final String userMessageTemplate;
    private final Map<String, Object> variables;

    private GuardrailRequestParams(Builder builder) {
        this.chatMemory = builder.chatMemory;
        this.augmentationResult = builder.augmentationResult;
        this.userMessageTemplate = ValidationUtils.ensureNotNull(builder.userMessageTemplate, "userMessageTemplate");
        this.variables = ValidationUtils.ensureNotNull(builder.variables, "variables");
    }

    public ChatMemory chatMemory() {
        return this.chatMemory;
    }

    public AugmentationResult augmentationResult() {
        return this.augmentationResult;
    }

    public String userMessageTemplate() {
        return this.userMessageTemplate;
    }

    public Map<String, Object> variables() {
        return this.variables;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ChatMemory chatMemory;
        private AugmentationResult augmentationResult;
        private String userMessageTemplate;
        private Map<String, Object> variables;

        public Builder chatMemory(ChatMemory chatMemory) {
            this.chatMemory = chatMemory;
            return this;
        }

        public Builder augmentationResult(AugmentationResult augmentationResult) {
            this.augmentationResult = augmentationResult;
            return this;
        }

        public Builder userMessageTemplate(String userMessageTemplate) {
            this.userMessageTemplate = userMessageTemplate;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public GuardrailRequestParams build() {
            return new GuardrailRequestParams(this);
        }
    }
}

