/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.guardrail;

import dev.langchain4j.Internal;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.guardrail.ChatExecutor;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.util.List;

@Internal
abstract class AbstractChatExecutor
implements ChatExecutor {
    protected final ChatRequest chatRequest;

    protected AbstractChatExecutor(ChatExecutor.AbstractBuilder<?> builder) {
        this.chatRequest = ValidationUtils.ensureNotNull(builder.chatRequest, "chatRequest");
    }

    @Override
    public ChatResponse execute(List<ChatMessage> chatMessages) {
        ChatRequest newChatRequest = this.chatRequest.toBuilder().messages(chatMessages).build();
        return this.execute(newChatRequest);
    }

    @Override
    public ChatResponse execute() {
        return this.execute(this.chatRequest);
    }

    protected abstract ChatResponse execute(ChatRequest var1);
}

