/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedLongCollection;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

public class SynchronizedLongSet
extends AbstractSynchronizedLongCollection
implements MutableLongSet {
    private static final long serialVersionUID = 1L;

    public SynchronizedLongSet(MutableLongSet set) {
        super((MutableLongCollection)set);
    }

    public SynchronizedLongSet(MutableLongSet set, Object newLock) {
        super((MutableLongCollection)set, newLock);
    }

    public static SynchronizedLongSet of(MutableLongSet set) {
        return new SynchronizedLongSet(set);
    }

    public static SynchronizedLongSet of(MutableLongSet set, Object lock) {
        return new SynchronizedLongSet(set, lock);
    }

    private MutableLongSet getMutableLongSet() {
        return (MutableLongSet)this.getLongCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongSet without(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongSet with(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongSet withAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongSet withoutAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongSet select(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongSet reject(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyIterable<LongLongPair> cartesianProduct(LongSet set) {
        Object object = this.getLock();
        synchronized (object) {
            return LongSets.cartesianProduct((LongSet)this, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyLongIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyLongIterableAdapter((LongIterable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongSet asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return new UnmodifiableLongSet(this);
        }
    }

    public MutableLongSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableLongSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongSet newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().newEmpty();
        }
    }
}

