/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.BooleanSets;
import org.eclipse.collections.api.factory.primitive.ByteSets;
import org.eclipse.collections.api.factory.primitive.CharSets;
import org.eclipse.collections.api.factory.primitive.DoubleSets;
import org.eclipse.collections.api.factory.primitive.FloatSets;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.factory.primitive.ShortSets;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.set.ImmutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionImmutableSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.CollectIfProcedure;
import org.eclipse.collections.impl.block.procedure.CollectProcedure;
import org.eclipse.collections.impl.block.procedure.FlatCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MultimapEachPutProcedure;
import org.eclipse.collections.impl.block.procedure.MultimapPutProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionPredicate2Procedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.RejectProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.block.procedure.SelectProcedure;
import org.eclipse.collections.impl.collection.immutable.AbstractImmutableCollection;
import org.eclipse.collections.impl.lazy.parallel.set.NonParallelUnsortedSetIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import org.eclipse.collections.impl.partition.set.PartitionUnifiedSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.internal.SetIterables;

public abstract class AbstractImmutableSet<T>
extends AbstractImmutableCollection<T>
implements ImmutableSet<T>,
Set<T> {
    public Set<T> castToSet() {
        return this;
    }

    protected int nullSafeHashCode(Object element) {
        return element == null ? 0 : element.hashCode();
    }

    public ImmutableSet<T> newWith(T element) {
        if (!this.contains(element)) {
            MutableSet result = Sets.mutable.withAll((Iterable)this);
            result.add(element);
            return result.toImmutable();
        }
        return this;
    }

    public ImmutableSet<T> newWithout(T element) {
        if (this.contains(element)) {
            MutableSet result = Sets.mutable.withAll((Iterable)this);
            result.remove(element);
            return result.toImmutable();
        }
        return this;
    }

    public ImmutableSet<T> newWithAll(Iterable<? extends T> elements) {
        MutableSet result = Sets.mutable.withAll(elements);
        result.addAll((Collection)this);
        return result.toImmutable();
    }

    public ImmutableSet<T> newWithoutAll(Iterable<? extends T> elements) {
        MutableSet result = Sets.mutable.withAll((Iterable)this);
        this.removeAllFrom(elements, result);
        return result.toImmutable();
    }

    public ImmutableSet<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    public ImmutableSet<T> select(Predicate<? super T> predicate) {
        FastList intermediateResult = FastList.newList();
        this.forEach(new SelectProcedure<T>(predicate, intermediateResult));
        return Sets.immutable.withAll(intermediateResult);
    }

    public <P> ImmutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public ImmutableSet<T> reject(Predicate<? super T> predicate) {
        FastList intermediateResult = FastList.newList();
        this.forEach(new RejectProcedure<T>(predicate, intermediateResult));
        return Sets.immutable.withAll(intermediateResult);
    }

    public <P> ImmutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public PartitionImmutableSet<T> partition(Predicate<? super T> predicate) {
        PartitionUnifiedSet partitionMutableSet = new PartitionUnifiedSet();
        this.forEach(new PartitionProcedure<T>(predicate, partitionMutableSet));
        return partitionMutableSet.toImmutable();
    }

    public <P> PartitionImmutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionUnifiedSet partitionMutableSet = new PartitionUnifiedSet();
        this.forEach(new PartitionPredicate2Procedure<T, P>(predicate, parameter, partitionMutableSet));
        return partitionMutableSet.toImmutable();
    }

    public <S> ImmutableSet<S> selectInstancesOf(Class<S> clazz) {
        MutableSet result = Sets.mutable.withInitialCapacity(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result.toImmutable();
    }

    public <V> ImmutableSet<V> collect(Function<? super T, ? extends V> function) {
        MutableSet result = Sets.mutable.empty();
        this.forEach(new CollectProcedure<T, V>(function, result));
        return result.toImmutable();
    }

    public ImmutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        MutableBooleanSet result = BooleanSets.mutable.empty();
        return ((MutableBooleanSet)this.collectBoolean(booleanFunction, (MutableBooleanCollection)result)).toImmutable();
    }

    public ImmutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        MutableByteSet result = ByteSets.mutable.empty();
        return ((MutableByteSet)this.collectByte(byteFunction, (MutableByteCollection)result)).toImmutable();
    }

    public ImmutableCharSet collectChar(CharFunction<? super T> charFunction) {
        MutableCharSet result = CharSets.mutable.empty();
        return ((MutableCharSet)this.collectChar(charFunction, (MutableCharCollection)result)).toImmutable();
    }

    public ImmutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        MutableDoubleSet result = DoubleSets.mutable.empty();
        return ((MutableDoubleSet)this.collectDouble(doubleFunction, (MutableDoubleCollection)result)).toImmutable();
    }

    public ImmutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        MutableFloatSet result = FloatSets.mutable.empty();
        return ((MutableFloatSet)this.collectFloat(floatFunction, (MutableFloatCollection)result)).toImmutable();
    }

    public ImmutableIntSet collectInt(IntFunction<? super T> intFunction) {
        MutableIntSet result = IntSets.mutable.empty();
        return ((MutableIntSet)this.collectInt(intFunction, (MutableIntCollection)result)).toImmutable();
    }

    public ImmutableLongSet collectLong(LongFunction<? super T> longFunction) {
        MutableLongSet result = LongSets.mutable.empty();
        return ((MutableLongSet)this.collectLong(longFunction, (MutableLongCollection)result)).toImmutable();
    }

    public ImmutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        MutableShortSet result = ShortSets.mutable.empty();
        return ((MutableShortSet)this.collectShort(shortFunction, (MutableShortCollection)result)).toImmutable();
    }

    public <P, V> ImmutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    public <V> ImmutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        MutableSet result = Sets.mutable.empty();
        this.forEach(new CollectIfProcedure<T, V>(result, function, predicate));
        return result.toImmutable();
    }

    public <V> ImmutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        MutableSet result = Sets.mutable.empty();
        this.forEach(new FlatCollectProcedure(function, result));
        return result.toImmutable();
    }

    public ImmutableSet<T> toImmutable() {
        return this;
    }

    public <V> ImmutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, UnifiedSetMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        this.forEach(MultimapPutProcedure.on(target, function));
        return target;
    }

    public <V> ImmutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, UnifiedSetMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.forEach(MultimapEachPutProcedure.on(target, function));
        return target;
    }

    @Deprecated
    public <S> ImmutableSet<Pair<T, S>> zip(Iterable<S> that) {
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            UnifiedSet target = UnifiedSet.newSet(Math.min(this.size(), thatSize));
            return this.zip(that, target).toImmutable();
        }
        return this.zip(that, Sets.mutable.empty()).toImmutable();
    }

    @Deprecated
    public ImmutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(Sets.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    protected MutableCollection<T> newMutable(int size) {
        return Sets.mutable.withInitialCapacity(size);
    }

    public ImmutableSet<T> union(SetIterable<? extends T> set) {
        return SetIterables.union(this, set).toImmutable();
    }

    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.unionInto(this, set, targetSet);
    }

    public ImmutableSet<T> intersect(SetIterable<? extends T> set) {
        return SetIterables.intersect(this, set).toImmutable();
    }

    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.intersectInto(this, set, targetSet);
    }

    public ImmutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        return SetIterables.difference(this, subtrahendSet).toImmutable();
    }

    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        return SetIterables.differenceInto(this, subtrahendSet, targetSet);
    }

    public ImmutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        return SetIterables.symmetricDifference(this, setB).toImmutable();
    }

    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.symmetricDifferenceInto(this, set, targetSet);
    }

    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isSubsetOf(this, candidateSuperset);
    }

    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isProperSubsetOf(this, candidateSuperset);
    }

    public ImmutableSet<UnsortedSetIterable<T>> powerSet() {
        return SetIterables.immutablePowerSet(this);
    }

    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        return SetIterables.cartesianProduct(this, set);
    }

    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        Objects.requireNonNull(executorService);
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be greater than zero, but was: " + batchSize);
        }
        return new NonParallelUnsortedSetIterable(this);
    }

    protected abstract class ImmutableSetIterator
    implements Iterator<T> {
        private int next;

        protected ImmutableSetIterator() {
        }

        protected abstract T getElement(int var1);

        @Override
        public boolean hasNext() {
            return this.next < AbstractImmutableSet.this.size();
        }

        @Override
        public T next() {
            return this.getElement(this.next++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from an ImmutableSet");
        }
    }
}

