/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;

public class LabelConfig {
    IRI labelIRI;
    long labelId;
    Set<String> languages;

    LabelConfig(IRI labelIRI, long labelId, String languagesString) {
        this.labelIRI = labelIRI;
        this.labelId = labelId;
        this.languages = Collections.emptySet();
        if (!languagesString.isEmpty()) {
            this.languages = new LinkedHashSet<String>(Arrays.asList(languagesString.split(",\\s*")));
        }
    }

    boolean languageMatches(String language) {
        if (this.languages.isEmpty()) {
            return true;
        }
        return this.languages.contains(language == null ? "empty" : language);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LabelConfig)) {
            return false;
        }
        LabelConfig other = (LabelConfig)obj;
        return other.labelIRI.equals((Object)this.labelIRI) && other.languages.equals(this.languages);
    }
}

