/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import com.google.common.primitives.Longs;
import com.ontotext.trree.plugin.autocomplete.AutocompletePlugin;
import com.ontotext.trree.plugin.autocomplete.AutocompletePluginUtils;
import com.ontotext.trree.plugin.autocomplete.AutocompleteSuggester;
import com.ontotext.trree.plugin.autocomplete.CompositeInputIterator;
import com.ontotext.trree.plugin.autocomplete.EntitiesIterator;
import com.ontotext.trree.plugin.autocomplete.IndexStatus;
import com.ontotext.trree.plugin.autocomplete.LabelConfig;
import com.ontotext.trree.plugin.autocomplete.LabelsIterator;
import com.ontotext.trree.plugin.autocomplete.WellKnownEntitiesIterator;
import com.ontotext.trree.plugin.autocomplete.lucene.LocalNameAnalyzer;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.RDFRankProvider;
import com.ontotext.trree.sdk.Statements;
import com.ontotext.trree.sdk.ThreadsafePluginConnecton;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.search.suggest.analyzing.BlendedInfixSuggester;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutocompleteIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutocompleteIndex.class);
    private static final Pattern ALL_UPPER_PATTERN = Pattern.compile("\\p{Lu}\\p{Lu}\\p{Lu}+");
    private Path indexDir;
    private LocalNameAnalyzer analyzer;
    private AnalyzingInfixSuggester suggester;
    private final AutocompletePlugin autocompletePlugin;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future<?> buildIndexTask;
    private Throwable error;
    private RDFRankProvider rdfRankPlugin;
    private boolean loadedRDFPlugin = false;
    private boolean shouldInterrupt;
    private ThreadsafePluginConnecton threadsafePluginConnecton;
    static final Set<String> SPECIAL_ENTITIES = new HashSet<String>(){
        {
            this.add("http://www.ontotext.com/check_prp_irp");
            this.add("http://www.ontotext.com/check_prp_npa2");
            this.add("http://www.ontotext.com/scm_int");
            this.add("http://www.ontotext.com/_owl_allDisjProp");
            this.add("http://www.ontotext.com/check_prp_npa1");
            this.add("http://www.ontotext.com/check_prp_asyp");
            this.add("http://www.ontotext.com/check_cls_nothing2");
            this.add("http://www.ontotext.com/check_cls_com");
            this.add("http://www.ontotext.com/check_prp_pdw");
            this.add("http://www.ontotext.com/_cls-oo");
            this.add("http://www.ontotext.com/_interOf");
            this.add("http://www.ontotext.com/_AllDisjointClasses");
            this.add("http://www.ontotext.com/_oneOf");
            this.add("http://www.ontotext.com/_owl_allDisjClasses");
            this.add("http://www.ontotext.com/_AllDisjointProperties");
            this.add("http://www.ontotext.com/_allTypes");
            this.add("http://www.ontotext.com/isInconsistentWith");
            this.add("http://www.ontotext.com/check_cax_dw");
            this.add("http://www.ontotext.com/_typeByInt");
            this.add("http://www.ontotext.com/_cls-oo");
            this.add("http://www.ontotext.com/_unionOf");
            this.add("http://www.ontotext.com/_interOf");
            this.add("http://www.ontotext.com/_oneOf");
            this.add("http://www.ontotext.com/_allTypes");
            this.add("http://www.ontotext.com/_union");
            this.add("http://www.ontotext.com/_typeByInt");
        }
    };
    boolean hasBuiltIndex;

    public boolean isShouldInterrupt() {
        return this.shouldInterrupt;
    }

    AutocompleteIndex(AutocompletePlugin plugin) {
        this.autocompletePlugin = plugin;
        this.initLuceneConfig();
    }

    private void initLuceneConfig() {
        this.indexDir = AutocompletePluginUtils.resolveIndexDirectory(this.autocompletePlugin.getDataDir());
        try {
            if (Files.exists(this.indexDir, new LinkOption[0]) && !Files.isDirectory(this.indexDir, new LinkOption[0])) {
                Files.delete(this.indexDir);
            }
            this.analyzer = new LocalNameAnalyzer();
            this.restartLuceneConfig();
            try (Stream<Path> list = Files.list(this.indexDir);){
                if (list.count() > 0L) {
                    this.hasBuiltIndex = true;
                }
            }
        }
        catch (IOException e) {
            throw new PluginException("Could not create index directory: " + this.indexDir, (Throwable)e);
        }
        catch (Exception e1) {
            LOGGER.error("Could not create suggester", (Throwable)e1);
            throw new PluginException("Could not create suggester", (Throwable)e1);
        }
        catch (Error e2) {
            LOGGER.error("Could not create suggester", (Throwable)e2);
            throw e2;
        }
    }

    private void restartLuceneConfig() throws IOException {
        FSDirectory directory = FSDirectory.open((Path)this.indexDir);
        this.suggester = new AutocompleteSuggester((Directory)directory, this.analyzer, this.analyzer, 4, BlendedInfixSuggester.BlenderType.POSITION_LINEAR, 1, true);
    }

    long getWeight(long id, String localName) {
        RDFRankProvider rdfRankPlugin = this.getRDFRankProvider();
        double rank = 0.0;
        if (rdfRankPlugin != null && id > 0L) {
            rank = rdfRankPlugin.getNormalizedRank(id);
        }
        if (rank > 0.01) {
            rank = 1.0 - rank;
            return Math.round(10000.0 - rank * rank * rank * rank * 1000.0);
        }
        return 1000 - localName.length();
    }

    Set<BytesRef> getURINamespaceAsContext(IRI currentURI) {
        return Collections.singleton(new BytesRef((CharSequence)currentURI.getNamespace()));
    }

    Set<BytesRef> getLabelContexts() {
        return Collections.singleton(new BytesRef((CharSequence)"label"));
    }

    BytesRef getEntityIDAsPayload(long id, boolean isLabel) {
        BytesRefBuilder bb = new BytesRefBuilder();
        bb.append(Longs.toByteArray((long)id), 0, 8);
        if (isLabel) {
            bb.append((byte)1);
        } else {
            bb.append((byte)0);
        }
        return bb.get();
    }

    BytesRef getIRIAsPayload(IRI iri, boolean isLabel) {
        BytesRefBuilder bb = new BytesRefBuilder();
        bb.append(Longs.toByteArray((long)0L), 0, 8);
        if (isLabel) {
            bb.append((byte)1);
        } else {
            bb.append((byte)0);
        }
        byte[] bytes = iri.stringValue().getBytes(StandardCharsets.UTF_8);
        bb.append(bytes, 0, bytes.length);
        return bb.get();
    }

    IndexStatus status() {
        if (this.error != null) {
            return IndexStatus.ERROR;
        }
        if (this.buildIndexTask == null) {
            return this.hasBuiltIndex ? (this.autocompletePlugin.configuredAndActualConfigsDiffer ? IndexStatus.READY_CONFIG : IndexStatus.READY) : IndexStatus.NONE;
        }
        if (this.isShouldInterrupt()) {
            return IndexStatus.CANCELED;
        }
        if (this.buildIndexTask.isDone()) {
            return this.autocompletePlugin.configuredAndActualConfigsDiffer ? IndexStatus.READY_CONFIG : IndexStatus.READY;
        }
        return IndexStatus.BUILDING;
    }

    String error() {
        if (this.error != null) {
            if (this.error instanceof ClosedByInterruptException || this.error instanceof AlreadyClosedException) {
                return "Indexing was interrupted.";
            }
            return this.error.toString();
        }
        return null;
    }

    synchronized void interrupt() {
        if (this.status() != IndexStatus.BUILDING || this.buildIndexTask == null) {
            LOGGER.info("Index status is " + (Object)((Object)this.status()));
            return;
        }
        LOGGER.info("Interrupting building index. " + (Object)((Object)this.status()));
        this.shouldInterrupt = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void buildIndex(PluginConnection pluginConnection) {
        if (this.status() == IndexStatus.BUILDING) {
            LOGGER.info("Index is already building.");
            return;
        }
        AutocompletePlugin autocompletePlugin = this.autocompletePlugin;
        synchronized (autocompletePlugin) {
            this.shouldInterrupt = false;
            this.hasBuiltIndex = false;
            this.error = null;
            AutocompleteIndex that = this;
            if (this.threadsafePluginConnecton != null) {
                this.threadsafePluginConnecton.close();
            }
            this.threadsafePluginConnecton = pluginConnection.getThreadsafeConnection();
            Entities threadsafeEntities = this.threadsafePluginConnecton.getEntities();
            Statements threadsafeStatements = this.threadsafePluginConnecton.getStatements();
            this.buildIndexTask = this.executor.submit(() -> {
                try {
                    AutocompletePlugin autocompletePlugin = this.autocompletePlugin;
                    synchronized (autocompletePlugin) {
                        this.autocompletePlugin.updateActualConfig(threadsafeEntities);
                        LOGGER.info("Start Building Index..");
                        ArrayList<InputIterator> iterators = new ArrayList<InputIterator>();
                        if (this.autocompletePlugin.actualShouldIndexIRIs) {
                            iterators.add(new WellKnownEntitiesIterator(that));
                            iterators.add(new EntitiesIterator(threadsafeEntities, that));
                        }
                        for (LabelConfig labelConfig : this.autocompletePlugin.labelConfigs) {
                            if (labelConfig.labelId <= 0L) continue;
                            iterators.add(new LabelsIterator(threadsafeEntities, threadsafeStatements, labelConfig, that));
                        }
                        if (iterators.isEmpty()) {
                            LOGGER.warn("Neither IRIs nor labels are configured for autocomplete indexing. The index will be empty.");
                        }
                        try (CompositeInputIterator iterator = new CompositeInputIterator(iterators);){
                            this.suggester.build((InputIterator)iterator);
                        }
                        if (this.shouldInterrupt) {
                            this.rollback();
                            LOGGER.info("Building index was interrupted.");
                        } else {
                            this.commitAndRefresh();
                            this.hasBuiltIndex = true;
                            LOGGER.info("Index built. Ready to use!");
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Index was not built.", (Throwable)e);
                    that.error = e;
                }
                catch (Throwable t) {
                    LOGGER.error("Index was not built.", t);
                    that.error = t;
                    throw new PluginException("Could not build index", t);
                }
                finally {
                    this.threadsafePluginConnecton.close();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void index(long id, IRI currentURI) {
        try {
            String localName = currentURI.getLocalName();
            BytesRef uriLocalNameForIndex = new BytesRef((CharSequence)localName);
            AutocompletePlugin autocompletePlugin = this.autocompletePlugin;
            synchronized (autocompletePlugin) {
                this.suggester.add(uriLocalNameForIndex, this.getURINamespaceAsContext(currentURI), this.getWeight(id, localName), this.getEntityIDAsPayload(id, false));
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not index uri. ", (Throwable)e);
            throw new PluginException("Could not index uri: " + currentURI, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void index(long id, String string) {
        try {
            BytesRef stringForIndex = new BytesRef((CharSequence)string);
            AutocompletePlugin autocompletePlugin = this.autocompletePlugin;
            synchronized (autocompletePlugin) {
                if (id == 0L) {
                    this.suggester.update(stringForIndex, null, 0L, null);
                } else {
                    this.suggester.add(stringForIndex, this.getLabelContexts(), this.getWeight(id, string), this.getEntityIDAsPayload(id, true));
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not index string. ", (Throwable)e);
            throw new PluginException("Could not index string: " + string, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitAndRefresh() throws IOException {
        if (this.suggester == null) {
            return;
        }
        AutocompletePlugin autocompletePlugin = this.autocompletePlugin;
        synchronized (autocompletePlugin) {
            this.suggester.commit();
            this.suggester.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() throws IOException {
        if (this.suggester == null) {
            return;
        }
        AutocompletePlugin autocompletePlugin = this.autocompletePlugin;
        synchronized (autocompletePlugin) {
            this.suggester.close();
            try {
                this.restartLuceneConfig();
            }
            catch (Exception e) {
                LOGGER.error("Something went wrong when rolling back, disabling plugin.", (Throwable)e);
            }
        }
    }

    Collection<Result> findEntities(String namespace, String query, Entities entities, int count) {
        List<Object> results;
        if (this.suggester == null) {
            throw new PluginException("Suggester should not be null ");
        }
        IndexStatus st = this.status();
        if (!IndexStatus.statusIsOk(st)) {
            LOGGER.info("Index is not ready. Status: " + (Object)((Object)st));
            if (st == IndexStatus.ERROR) {
                LOGGER.error("Error is: " + this.error());
            }
            return Collections.emptyList();
        }
        try {
            if (this.suggester.getCount() == 0L) {
                results = Collections.emptyList();
            } else {
                results = this.getResultsForQuery(query, namespace, count);
                if (ALL_UPPER_PATTERN.matcher(query).matches()) {
                    String altQuery = query.substring(0, query.length() - 1) + " " + query.charAt(query.length() - 1);
                    results = this.mergeResults(results, this.getResultsForQuery(altQuery, namespace, count), count);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not execute query. ", (Throwable)e);
            throw new PluginException("Could not execute query: " + query, (Throwable)e);
        }
        catch (Exception e1) {
            LOGGER.error("Could not lookup results. ", (Throwable)e1);
            throw new PluginException("Could not lookup results. Try index rebuild. ", (Throwable)e1);
        }
        LinkedHashMap<String, Result> resultEntities = new LinkedHashMap<String, Result>();
        for (Lookup.LookupResult lookupResult : results) {
            Value val;
            if (lookupResult.payload.bytes.length == 0) continue;
            long id = Longs.fromByteArray((byte[])lookupResult.payload.bytes);
            if (id == 0L) {
                String iri = new String(lookupResult.payload.bytes, 9, lookupResult.payload.bytes.length - 9, StandardCharsets.UTF_8);
                val = SimpleValueFactory.getInstance().createIRI(iri);
            } else {
                val = entities.get(id);
                if (val == null) continue;
            }
            if (!(val instanceof IRI) && !(val instanceof Triple)) {
                LOGGER.error("Oops, found a non URI or Triple in results. This should not happen: " + id + " => " + val);
                assert (false);
                continue;
            }
            Result newResult = new Result(id, (Resource)val, lookupResult.highlightKey.toString(), lookupResult.payload.bytes[8] != 0);
            Result previousResult = (Result)resultEntities.get(newResult.resource.stringValue());
            if (previousResult != null && !newResult.isBetterThan(previousResult)) continue;
            resultEntities.put(newResult.resource.stringValue(), newResult);
        }
        return resultEntities.values();
    }

    public void shutDown() {
        try {
            this.suggester.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not shutdown suggester. ", (Throwable)e);
        }
    }

    public RDFRankProvider getRDFRankProvider() {
        if (!this.loadedRDFPlugin) {
            this.rdfRankPlugin = this.autocompletePlugin.getPluginLocator().locateRDFRankProvider();
            this.loadedRDFPlugin = true;
            if (this.rdfRankPlugin == null) {
                LOGGER.warn("The RDF Rank plugin was not found and will not be used.");
            }
        }
        return this.rdfRankPlugin;
    }

    private List<Lookup.LookupResult> getResultsForQuery(String query, String namespace, int maxResults) throws IOException {
        if (!StringUtils.isEmpty((CharSequence)namespace)) {
            return this.suggester.lookup((CharSequence)query, Collections.singleton(new BytesRef((CharSequence)namespace)), false, maxResults);
        }
        return this.suggester.lookup((CharSequence)query, false, maxResults);
    }

    private List<Lookup.LookupResult> mergeResults(@Nullable List<Lookup.LookupResult> result1, @Nullable List<Lookup.LookupResult> result2, int maxResults) {
        if (result2 == null || result2.isEmpty()) {
            if (result1 == null) {
                return Collections.emptyList();
            }
            return result1;
        }
        if (result1 == null || result1.isEmpty()) {
            return result2;
        }
        ArrayList<Lookup.LookupResult> mergedResult = new ArrayList<Lookup.LookupResult>(Math.min(result1.size() + result2.size(), maxResults));
        Iterator<Lookup.LookupResult> resultIterator1 = result1.iterator();
        Iterator<Lookup.LookupResult> resultIterator2 = result2.iterator();
        while (mergedResult.size() < maxResults && (resultIterator1.hasNext() || resultIterator2.hasNext())) {
            if (resultIterator1.hasNext()) {
                mergedResult.add(resultIterator1.next());
            }
            if (!resultIterator2.hasNext()) continue;
            mergedResult.add(resultIterator2.next());
        }
        return mergedResult;
    }

    static class Result {
        long id;
        Resource resource;
        String highlight;
        boolean isLabel;

        Result(long id, Resource resource, String highlight, boolean isLabel) {
            this.id = id;
            this.resource = resource;
            this.isLabel = isLabel;
            if (isLabel) {
                this.highlight = highlight + " " + NTriplesUtil.toNTriplesString((Resource)resource);
            } else if (resource instanceof IRI) {
                this.highlight = ((IRI)resource).getNamespace() + highlight;
            }
            this.highlight = AutocompleteSuggester.htmlifyHighlight(this.highlight);
        }

        boolean isBetterThan(Result other) {
            return this.isLabel && !other.isLabel || this.isLabel == other.isLabel && this.highlight.length() < other.highlight.length();
        }
    }
}

