/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history.collection.nonfactored;

import com.ontotext.graphdb.plugin.history.collection.AbstractHistoryStorage;
import com.ontotext.trree.big.collections.Utils;
import com.ontotext.trree.big.collections.storage.ArrayPools;
import java.util.Arrays;

public class NonFactoredHistoryStorage
extends AbstractHistoryStorage {
    private long[] dateTimeElement;

    NonFactoredHistoryStorage(ArrayPools factory, int size, int entityIdSize) {
        super(factory, size, entityIdSize);
        this.dateTimeElement = factory == null ? new long[size] : factory.allocateLongArray(size);
    }

    @Override
    protected int readDateTime(byte[] bytes, int offset, int size) {
        int startOffset = offset;
        int idx = 0;
        while (idx < size) {
            this.dateTimeElement[idx] = Utils.restoreLong((byte[])bytes, (int)offset);
            ++idx;
            offset += 8;
        }
        return offset - startOffset;
    }

    @Override
    protected int readDateTime(int index, byte[] bytes, int offset) {
        this.dateTimeElement[index] = Utils.restoreLong((byte[])bytes, (int)offset);
        return 8;
    }

    @Override
    protected int writeDateTime(byte[] bytes, int offset, int size) {
        int startOffset = offset;
        int idx = 0;
        while (idx < size) {
            Utils.serializeLong((long)this.dateTimeElement[idx], (byte[])bytes, (int)offset);
            ++idx;
            offset += 8;
        }
        return offset - startOffset;
    }

    @Override
    protected int writeDateTime(int index, byte[] bytes, int offset) {
        Utils.serializeLong((long)this.dateTimeElement[index], (byte[])bytes, (int)offset);
        return 8;
    }

    @Override
    protected void setDateTime(int index, long[] tuple, int tupleIndex) {
        this.dateTimeElement[index] = tuple[tupleIndex];
    }

    @Override
    protected void getDateTime(int index, long[] tuple, int tupleIndex) {
        tuple[tupleIndex] = this.dateTimeElement[index];
    }

    @Override
    protected long getDateTime(int index) {
        return this.dateTimeElement[index];
    }

    @Override
    protected void setDateTime(int index, long value) {
        this.dateTimeElement[index] = value;
    }

    public NonFactoredHistoryStorage clone(ArrayPools factory, boolean copyData) {
        NonFactoredHistoryStorage cloned = new NonFactoredHistoryStorage(factory, this.size(), this.getEntityIdSize());
        if (copyData) {
            System.arraycopy(this.dateTimeElement, 0, cloned.dateTimeElement, 0, this.dateTimeElement.length);
            this.copyInherited(cloned);
        }
        return cloned;
    }

    @Override
    public void resizeDateTime(int newSize) {
        this.dateTimeElement = Arrays.copyOf(this.dateTimeElement, newSize);
    }

    @Override
    protected int dateTimeByteSize() {
        return 8;
    }

    @Override
    protected int compareDateTime(int index, long[] tuple, int tupleIndex) {
        return Utils.compare((long)tuple[tupleIndex], (long)this.dateTimeElement[index]);
    }

    @Override
    public void cleanDateTime(ArrayPools factory) {
        if (factory != null && this.dateTimeElement != null) {
            factory.release(this.dateTimeElement);
            this.dateTimeElement = null;
        }
    }
}

