/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history.collection;

import com.ontotext.trree.big.collections.Utils;
import com.ontotext.trree.big.collections.storage.ArrayPools;
import com.ontotext.trree.big.collections.storage.Storage;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;

public abstract class AbstractHistoryStorage
extends Storage {
    private int[] subjectElement;
    private int[] predicateElement;
    private int[] objectElement;
    private int[] contextElement;
    private byte[] status;
    private byte[] subjectElementExt;
    private byte[] predicateElementExt;
    private byte[] objectElementExt;
    private byte[] contextElementExt;

    public AbstractHistoryStorage(ArrayPools factory, int size, int entityIdSize) {
        super(factory, size);
        if (factory == null) {
            this.subjectElement = new int[size];
            this.predicateElement = new int[size];
            this.objectElement = new int[size];
            this.contextElement = new int[size];
            this.status = new byte[size];
        } else {
            this.subjectElement = factory.allocateIntArray(size);
            this.predicateElement = factory.allocateIntArray(size);
            this.objectElement = factory.allocateIntArray(size);
            this.contextElement = factory.allocateIntArray(size);
            this.status = factory.allocateByteArray(size);
        }
        if (entityIdSize == 32) {
            this.subjectElementExt = null;
            this.predicateElementExt = null;
            this.objectElementExt = null;
            this.contextElementExt = null;
        } else if (entityIdSize == 40) {
            if (factory == null) {
                this.subjectElementExt = new byte[this.size()];
                this.predicateElementExt = new byte[this.size()];
                this.objectElementExt = new byte[this.size()];
                this.contextElementExt = new byte[this.size()];
            } else {
                this.subjectElementExt = factory.allocateByteArray(this.size());
                this.predicateElementExt = factory.allocateByteArray(this.size());
                this.objectElementExt = factory.allocateByteArray(this.size());
                this.contextElementExt = factory.allocateByteArray(this.size());
            }
        } else {
            throw new IllegalArgumentException("Invalid entity ID size: " + entityIdSize);
        }
    }

    protected int getEntityIdSize() {
        return this.subjectElementExt != null ? 40 : 32;
    }

    private boolean isExtended() {
        return this.subjectElementExt != null;
    }

    public final int read(byte[] bytes, int offset) {
        int startOffset = offset;
        int size = this.size();
        offset += this.readDateTime(bytes, offset, size);
        int idx = 0;
        while (idx < size) {
            this.subjectElement[idx] = Utils.restoreInt((byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        idx = 0;
        while (idx < size) {
            this.predicateElement[idx] = Utils.restoreInt((byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        idx = 0;
        while (idx < size) {
            this.objectElement[idx] = Utils.restoreInt((byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        idx = 0;
        while (idx < size) {
            this.contextElement[idx] = Utils.restoreInt((byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        if (this.isExtended()) {
            idx = 0;
            while (idx < size) {
                this.subjectElementExt[idx] = Utils.restoreByte((byte[])bytes, (int)offset);
                ++idx;
                ++offset;
            }
            idx = 0;
            while (idx < size) {
                this.predicateElementExt[idx] = Utils.restoreByte((byte[])bytes, (int)offset);
                ++idx;
                ++offset;
            }
            idx = 0;
            while (idx < size) {
                this.objectElementExt[idx] = Utils.restoreByte((byte[])bytes, (int)offset);
                ++idx;
                ++offset;
            }
            idx = 0;
            while (idx < size) {
                this.contextElementExt[idx] = Utils.restoreByte((byte[])bytes, (int)offset);
                ++idx;
                ++offset;
            }
        }
        idx = 0;
        while (idx < size) {
            this.status[idx] = Utils.restoreByte((byte[])bytes, (int)offset);
            ++idx;
            ++offset;
        }
        return offset - startOffset;
    }

    protected abstract int readDateTime(byte[] var1, int var2, int var3);

    public final int read(int index, byte[] bytes, int offset) {
        int startOffset = offset;
        offset += this.readDateTime(index, bytes, offset);
        this.subjectElement[index] = Utils.restoreInt((byte[])bytes, (int)offset);
        this.predicateElement[index] = Utils.restoreInt((byte[])bytes, (int)(offset += 4));
        this.objectElement[index] = Utils.restoreInt((byte[])bytes, (int)(offset += 4));
        this.contextElement[index] = Utils.restoreInt((byte[])bytes, (int)(offset += 4));
        offset += 4;
        if (this.isExtended()) {
            this.subjectElementExt[index] = Utils.restoreByte((byte[])bytes, (int)offset);
            this.predicateElementExt[index] = Utils.restoreByte((byte[])bytes, (int)(++offset));
            this.objectElementExt[index] = Utils.restoreByte((byte[])bytes, (int)(++offset));
            this.contextElementExt[index] = Utils.restoreByte((byte[])bytes, (int)(++offset));
            ++offset;
        }
        this.status[index] = Utils.restoreByte((byte[])bytes, (int)offset);
        return ++offset - startOffset;
    }

    protected abstract int readDateTime(int var1, byte[] var2, int var3);

    public final int write(byte[] bytes, int offset) {
        int startOffset = offset;
        int size = this.size();
        offset += this.writeDateTime(bytes, offset, size);
        int idx = 0;
        while (idx < size) {
            Utils.serializeInt((int)this.subjectElement[idx], (byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        idx = 0;
        while (idx < size) {
            Utils.serializeInt((int)this.predicateElement[idx], (byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        idx = 0;
        while (idx < size) {
            Utils.serializeInt((int)this.objectElement[idx], (byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        idx = 0;
        while (idx < size) {
            Utils.serializeInt((int)this.contextElement[idx], (byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        if (this.isExtended()) {
            idx = 0;
            while (idx < size) {
                Utils.serializeByte((byte)this.subjectElementExt[idx], (byte[])bytes, (int)offset);
                ++idx;
                ++offset;
            }
            idx = 0;
            while (idx < size) {
                Utils.serializeByte((byte)this.predicateElementExt[idx], (byte[])bytes, (int)offset);
                ++idx;
                ++offset;
            }
            idx = 0;
            while (idx < size) {
                Utils.serializeByte((byte)this.objectElementExt[idx], (byte[])bytes, (int)offset);
                ++idx;
                ++offset;
            }
            idx = 0;
            while (idx < size) {
                Utils.serializeByte((byte)this.contextElementExt[idx], (byte[])bytes, (int)offset);
                ++idx;
                ++offset;
            }
        }
        idx = 0;
        while (idx < size) {
            Utils.serializeByte((byte)this.status[idx], (byte[])bytes, (int)offset);
            ++idx;
            ++offset;
        }
        return offset - startOffset;
    }

    protected abstract int writeDateTime(byte[] var1, int var2, int var3);

    public final int write(int index, byte[] bytes, int offset) {
        int startOffset = offset;
        offset += this.writeDateTime(index, bytes, offset);
        Utils.serializeInt((int)this.subjectElement[index], (byte[])bytes, (int)offset);
        Utils.serializeInt((int)this.predicateElement[index], (byte[])bytes, (int)(offset += 4));
        Utils.serializeInt((int)this.objectElement[index], (byte[])bytes, (int)(offset += 4));
        Utils.serializeInt((int)this.contextElement[index], (byte[])bytes, (int)(offset += 4));
        offset += 4;
        if (this.isExtended()) {
            Utils.serializeByte((byte)this.subjectElementExt[index], (byte[])bytes, (int)offset);
            Utils.serializeByte((byte)this.predicateElementExt[index], (byte[])bytes, (int)(++offset));
            Utils.serializeByte((byte)this.objectElementExt[index], (byte[])bytes, (int)(++offset));
            Utils.serializeByte((byte)this.contextElementExt[index], (byte[])bytes, (int)(++offset));
            ++offset;
        }
        Utils.serializeByte((byte)this.status[index], (byte[])bytes, (int)offset);
        return ++offset - startOffset;
    }

    protected abstract int writeDateTime(int var1, byte[] var2, int var3);

    public final void set(int index, long[] tuple, int tupleIndex) {
        this.setDateTime(index, tuple, tupleIndex);
        if (this.isExtended()) {
            this.setExtended(this.subjectElement, this.subjectElementExt, index, tuple[tupleIndex + 1]);
            this.setExtended(this.predicateElement, this.predicateElementExt, index, tuple[tupleIndex + 2]);
            this.setExtended(this.objectElement, this.objectElementExt, index, tuple[tupleIndex + 3]);
            this.setExtended(this.contextElement, this.contextElementExt, index, tuple[tupleIndex + 4]);
        } else {
            this.subjectElement[index] = (int)tuple[tupleIndex + 1];
            this.predicateElement[index] = (int)tuple[tupleIndex + 2];
            this.objectElement[index] = (int)tuple[tupleIndex + 3];
            this.contextElement[index] = (int)tuple[tupleIndex + 4];
        }
        this.status[index] = (byte)tuple[tupleIndex + 5];
    }

    protected abstract void setDateTime(int var1, long[] var2, int var3);

    public final void get(int index, long[] tuple, int tupleIndex) {
        this.getDateTime(index, tuple, tupleIndex);
        if (this.isExtended()) {
            tuple[tupleIndex + 1] = this.getExtended(this.subjectElement, this.subjectElementExt, index);
            tuple[tupleIndex + 2] = this.getExtended(this.predicateElement, this.predicateElementExt, index);
            tuple[tupleIndex + 3] = this.getExtended(this.objectElement, this.objectElementExt, index);
            tuple[tupleIndex + 4] = this.getExtended(this.contextElement, this.contextElementExt, index);
        } else {
            tuple[tupleIndex + 1] = (long)this.subjectElement[index] & 0xFFFFFFFFL;
            tuple[tupleIndex + 2] = (long)this.predicateElement[index] & 0xFFFFFFFFL;
            tuple[tupleIndex + 3] = (long)this.objectElement[index] & 0xFFFFFFFFL;
            tuple[tupleIndex + 4] = (long)this.contextElement[index] & 0xFFFFFFFFL;
        }
        tuple[tupleIndex + 5] = (long)this.status[index] & 0xFFFFFFFFL;
    }

    protected abstract void getDateTime(int var1, long[] var2, int var3);

    public final long get(int index, int tupleElement) {
        switch (tupleElement) {
            case 0: {
                return this.getDateTime(index);
            }
            case 1: {
                return this.isExtended() ? this.getExtended(this.subjectElement, this.subjectElementExt, index) : (long)this.subjectElement[index] & 0xFFFFFFFFL;
            }
            case 2: {
                return this.isExtended() ? this.getExtended(this.predicateElement, this.predicateElementExt, index) : (long)this.predicateElement[index] & 0xFFFFFFFFL;
            }
            case 3: {
                return this.isExtended() ? this.getExtended(this.objectElement, this.objectElementExt, index) : (long)this.objectElement[index] & 0xFFFFFFFFL;
            }
            case 4: {
                return this.isExtended() ? this.getExtended(this.contextElement, this.contextElementExt, index) : (long)this.contextElement[index] & 0xFFFFFFFFL;
            }
            case 5: {
                return (long)this.status[index] & 0xFFFFFFFFL;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    protected abstract long getDateTime(int var1);

    public final void set(int index, int tupleElement, long value) {
        block17: {
            block16: {
                if (!this.isExtended()) break block16;
                switch (tupleElement) {
                    case 0: {
                        this.setDateTime(index, value);
                        break block17;
                    }
                    case 1: {
                        this.setExtended(this.subjectElement, this.subjectElementExt, index, value);
                        break block17;
                    }
                    case 2: {
                        this.setExtended(this.predicateElement, this.predicateElementExt, index, value);
                        break block17;
                    }
                    case 3: {
                        this.setExtended(this.objectElement, this.objectElementExt, index, value);
                        break block17;
                    }
                    case 4: {
                        this.setExtended(this.contextElement, this.contextElementExt, index, value);
                        break block17;
                    }
                    case 5: {
                        this.status[index] = (byte)value;
                        break block17;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
            }
            switch (tupleElement) {
                case 0: {
                    this.setDateTime(index, value);
                    break;
                }
                case 1: {
                    this.subjectElement[index] = (int)value;
                    break;
                }
                case 2: {
                    this.predicateElement[index] = (int)value;
                    break;
                }
                case 3: {
                    this.objectElement[index] = (int)value;
                    break;
                }
                case 4: {
                    this.contextElement[index] = (int)value;
                    break;
                }
                case 5: {
                    this.status[index] = (byte)value;
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    protected abstract void setDateTime(int var1, long var2);

    private long getExtended(int[] std, byte[] ext, int index) {
        return (long)std[index] & 0xFFFFFFFFL | ((long)ext[index] & 0xFFL) << 32;
    }

    private void setExtended(int[] std, byte[] ext, int index, long value) {
        std[index] = (int)value;
        ext[index] = (byte)(value >> 32);
    }

    public final boolean isDeleted(int index) {
        return false;
    }

    public final void update(int index, long[] tuple, int tupleIndex) {
        boolean isAdded;
        boolean wasAdded = (this.status[index] & 1) != 0;
        boolean bl = isAdded = (tuple[tupleIndex + 5] & 1L) != 0L;
        if (wasAdded && !isAdded || !wasAdded && isAdded) {
            this.status[index] = (byte)(this.status[index] ^ 4);
        }
        this.status[index] = (byte)((long)(this.status[index] & 0xFF & 0xFFFFFFFE) | tuple[tupleIndex + 5] & 1L);
    }

    public final void undelete(int index) {
        throw new NotImplementedException("Not implemented");
    }

    public final int arity() {
        return 6;
    }

    public final boolean isModified(int index, long[] tuple, int tupleIndex) {
        int cmp = this.compare(index, tuple, tupleIndex);
        if (cmp == 0) {
            return (long)(this.status[index] & 1) != (tuple[tupleIndex + 5] & 1L) || (long)(this.status[index] & 4) != (tuple[tupleIndex + 5] & 4L);
        }
        return false;
    }

    public final void writeMetaData(int[] metaData, int offset) {
        metaData[offset] = this.getEntityIdSize();
    }

    public final void readMetaData(int[] metaData, int offset) {
        if (metaData[offset] != this.getEntityIdSize()) {
            throw new IllegalArgumentException("Statement collection was initialized with entityIdSize=" + this.getEntityIdSize() + " but persisted file contained entityIdSize=" + metaData[offset]);
        }
    }

    public final int compare(int index, long[] tuple, int tupleIndex) {
        int cmp = this.compareDateTime(index, tuple, tupleIndex);
        if (cmp != 0) {
            return cmp;
        }
        if (this.isExtended()) {
            cmp = Utils.compare((long)this.getExtended(this.subjectElement, this.subjectElementExt, index), (long)tuple[tupleIndex + 1]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Utils.compare((long)this.getExtended(this.predicateElement, this.predicateElementExt, index), (long)tuple[tupleIndex + 2]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Utils.compare((long)this.getExtended(this.objectElement, this.objectElementExt, index), (long)tuple[tupleIndex + 3]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Utils.compare((long)this.getExtended(this.contextElement, this.contextElementExt, index), (long)tuple[tupleIndex + 4]);
            if (cmp != 0) {
                return cmp;
            }
        } else {
            cmp = Utils.compare((long)((long)this.subjectElement[index] & 0xFFFFFFFFL), (long)tuple[tupleIndex + 1]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Utils.compare((long)((long)this.predicateElement[index] & 0xFFFFFFFFL), (long)tuple[tupleIndex + 2]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Utils.compare((long)((long)this.objectElement[index] & 0xFFFFFFFFL), (long)tuple[tupleIndex + 3]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Utils.compare((long)((long)this.contextElement[index] & 0xFFFFFFFFL), (long)tuple[tupleIndex + 4]);
            if (cmp != 0) {
                return cmp;
            }
        }
        cmp = Utils.compare((long)(this.status[index] & 0xFF & 0xFFFFFFFA), (long)(tuple[tupleIndex + 5] & 0xFFL & 0xFFFFFFFFFFFFFFFAL));
        return cmp;
    }

    protected abstract int compareDateTime(int var1, long[] var2, int var3);

    public final int getMostSignificantTupleIndex() {
        return 0;
    }

    public final void clean(ArrayPools factory) {
        if (factory != null) {
            this.cleanDateTime(factory);
            if (this.subjectElement != null) {
                factory.release(this.subjectElement);
                this.subjectElement = null;
            }
            if (this.predicateElement != null) {
                factory.release(this.predicateElement);
                this.predicateElement = null;
            }
            if (this.objectElement != null) {
                factory.release(this.objectElement);
                this.objectElement = null;
            }
            if (this.contextElement != null) {
                factory.release(this.contextElement);
                this.contextElement = null;
            }
            if (this.subjectElementExt != null) {
                factory.release(this.subjectElementExt);
                this.subjectElementExt = null;
            }
            if (this.predicateElementExt != null) {
                factory.release(this.predicateElementExt);
                this.predicateElementExt = null;
            }
            if (this.objectElementExt != null) {
                factory.release(this.objectElementExt);
                this.objectElementExt = null;
            }
            if (this.contextElementExt != null) {
                factory.release(this.contextElementExt);
                this.contextElementExt = null;
            }
            if (this.status != null) {
                factory.release(this.status);
            }
        }
    }

    protected abstract void cleanDateTime(ArrayPools var1);

    public final void resize(int newSize) {
        if (newSize == this.size()) {
            return;
        }
        if (newSize <= 0) {
            throw new IllegalArgumentException("Size should be > 0");
        }
        super.resize(newSize);
        this.resizeDateTime(newSize);
        this.subjectElement = Arrays.copyOf(this.subjectElement, newSize);
        this.predicateElement = Arrays.copyOf(this.predicateElement, newSize);
        this.objectElement = Arrays.copyOf(this.objectElement, newSize);
        this.contextElement = Arrays.copyOf(this.contextElement, newSize);
        if (this.isExtended()) {
            this.subjectElementExt = Arrays.copyOf(this.subjectElementExt, newSize);
            this.predicateElementExt = Arrays.copyOf(this.predicateElementExt, newSize);
            this.objectElementExt = Arrays.copyOf(this.objectElementExt, newSize);
            this.contextElementExt = Arrays.copyOf(this.contextElementExt, newSize);
        }
        this.status = Arrays.copyOf(this.status, newSize);
    }

    protected abstract void resizeDateTime(int var1);

    protected final void copyInherited(AbstractHistoryStorage cloned) {
        System.arraycopy(this.subjectElement, 0, cloned.subjectElement, 0, this.subjectElement.length);
        System.arraycopy(this.predicateElement, 0, cloned.predicateElement, 0, this.predicateElement.length);
        System.arraycopy(this.objectElement, 0, cloned.objectElement, 0, this.objectElement.length);
        System.arraycopy(this.contextElement, 0, cloned.contextElement, 0, this.contextElement.length);
        if (this.isExtended()) {
            System.arraycopy(this.subjectElementExt, 0, cloned.subjectElementExt, 0, this.subjectElementExt.length);
            System.arraycopy(this.predicateElementExt, 0, cloned.predicateElementExt, 0, this.predicateElementExt.length);
            System.arraycopy(this.objectElementExt, 0, cloned.objectElementExt, 0, this.objectElementExt.length);
            System.arraycopy(this.contextElementExt, 0, cloned.contextElementExt, 0, this.contextElementExt.length);
        }
        System.arraycopy(this.status, 0, cloned.status, 0, this.status.length);
    }

    public final int byteSize() {
        return (this.dateTimeByteSize() + 4 * (this.isExtended() ? 5 : 4) + 1) * this.size();
    }

    public final int tupleSize() {
        return this.dateTimeByteSize() + 4 * (this.isExtended() ? 5 : 4) + 1;
    }

    protected abstract int dateTimeByteSize();
}

