/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.ontotext.GraphDBConfigParameters;
import com.ontotext.config.ParametersSource;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.plugin.history.CollectionHistoryConnection;
import com.ontotext.graphdb.plugin.history.History;
import com.ontotext.graphdb.plugin.history.HistoryConnection;
import com.ontotext.graphdb.plugin.history.IdTimestampCollection;
import com.ontotext.graphdb.plugin.history.collection.HistoryCollectionConnection;
import com.ontotext.graphdb.plugin.history.collection.TransactionalCollection;
import com.ontotext.graphdb.plugin.history.collection.factored.FactoredHistoryCollection;
import com.ontotext.graphdb.plugin.history.collection.nonfactored.NonFactoredHistoryCollection;
import com.ontotext.graphdb.plugin.history.collection.nonfactored.TxDetailsHistoryCollection;
import com.ontotext.trree.entitypool.EntityPool;
import com.ontotext.trree.entitypool.EntityPoolFactory;
import com.ontotext.trree.entitypool.EntityPoolFactoryException;
import com.ontotext.trree.entitypool.util.DuplicateEntityException;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.transactions.TransactionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

public class CollectionHistory
implements History {
    public static final int CACHE_SIZE = 1000;
    final TransactionalCollection<HistoryCollectionConnection> collection;
    final TxDetailsHistoryCollection detailsHistoryColl;
    final IdTimestampCollection customTxIdToTimestampColl;
    final EntityPool txIdUsernameEntityPool;

    CollectionHistory(Path mainDir, int entityIdSize) {
        this(mainDir, entityIdSize, Config.getPropertyAsBoolean((String)"graphdb.history.factored", (boolean)false));
    }

    CollectionHistory(Path mainDir, int entityIdSize, boolean factored) {
        try {
            Files.createDirectories(mainDir, new FileAttribute[0]);
            Path historyPath = mainDir.resolve("history");
            Path txMetaPath = mainDir.resolve("tx-metadata");
            Files.createDirectories(txMetaPath, new FileAttribute[0]);
            this.collection = factored ? new FactoredHistoryCollection(historyPath.toFile(), 1000, entityIdSize) : new NonFactoredHistoryCollection(historyPath.toFile(), 1000, entityIdSize);
            this.txIdUsernameEntityPool = this.createTxIdUsernameEntityPool(txMetaPath.toFile());
            Path detailsPath = txMetaPath.resolve("tx-details");
            this.detailsHistoryColl = new TxDetailsHistoryCollection(detailsPath.toFile());
            Path idTimestampPath = txMetaPath.resolve("tx-id");
            this.customTxIdToTimestampColl = new IdTimestampCollection(idTimestampPath.toFile());
            this.collection.initialize();
            this.detailsHistoryColl.initialize();
            this.customTxIdToTimestampColl.initialize();
        }
        catch (TransactionException | IOException e) {
            throw new PluginException("Cannot initialize history collection", e);
        }
    }

    @Override
    public HistoryConnection getConnection() {
        return new CollectionHistoryConnection(this);
    }

    @Override
    public void close() {
        this.collection.shutdown();
        this.detailsHistoryColl.shutdown();
        this.customTxIdToTimestampColl.shutdown();
        this.txIdUsernameEntityPool.shutdown();
    }

    private EntityPool createTxIdUsernameEntityPool(File dir) {
        try {
            HashMap<String, Comparable<File>> params = new HashMap<String, Comparable<File>>();
            params.put(GraphDBConfigParameters.STORAGE_FOLDER.name(), dir);
            params.put(GraphDBConfigParameters.PARAM_ENTITY_INDEX_SIZE.name(), Integer.valueOf(100000));
            params.put(GraphDBConfigParameters.PARAM_ENTITY_ID_SIZE.name(), Integer.valueOf(32));
            EntityPool entPool = EntityPoolFactory.getInstance().getEntityPool("transactional", (ParametersSource)new ParametersSource.MapParametersSource(params, null));
            entPool.initialize();
            return entPool;
        }
        catch (EntityPoolFactoryException | DuplicateEntityException e) {
            throw new PluginException("Unable to initialize the custom entity pool", e);
        }
    }
}

