/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.util;

import com.ontotext.soaas.util.RetryExecutionException;
import com.ontotext.soaas.util.RetryingOperation;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;

public class RetryingTaskExecutor
implements TaskExecutor {
    public static final String NAME = "retryingTaskExecutor";
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TaskExecutor delegate;
    private long initialDelay;
    private long delayBeforeRetry;
    private int retries;

    public RetryingTaskExecutor(TaskExecutor delegate, long initialDelay, long delayBeforeRetry, int retries) {
        this.delegate = delegate;
        this.setInitialDelay(initialDelay, TimeUnit.MILLISECONDS);
        this.setDelayBeforeRetry(delayBeforeRetry, TimeUnit.MILLISECONDS);
        this.setRetries(retries);
    }

    public void execute(@NotNull Runnable runnable) {
        this.delegate.execute(this.executeWithRetriesInternal(runnable));
    }

    public void executeAndRetry(@NotNull Runnable runnable) {
        try {
            runnable.run();
        }
        catch (RetryExecutionException ree) {
            this.delegate.execute(this.executeWithRetriesInternal(runnable));
        }
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay, TimeUnit timeUnit) {
        this.initialDelay = Math.max(timeUnit.toMillis(initialDelay), 0L);
    }

    public long getDelayBeforeRetry() {
        return this.delayBeforeRetry;
    }

    public void setDelayBeforeRetry(long delayBeforeRetry, TimeUnit timeUnit) {
        this.delayBeforeRetry = Math.max(timeUnit.toMillis(delayBeforeRetry), 0L);
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    private Runnable executeWithRetriesInternal(Runnable runnable) {
        return new RetryingOperation(runnable, this.getInitialDelay(), this.getDelayBeforeRetry(), this.getRetries(), this.logException());
    }

    private Consumer<RuntimeException> logException() {
        return ex -> LOGGER.error("Async task execution failed unexpectedly!", (Throwable)ex);
    }
}

