/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.validators;

import com.ontotext.models.Operation;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Query;
import com.ontotext.soaas.configuration.GraphQlQueryOptions;
import com.ontotext.soaas.plugin.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDepthValidator
implements OperationValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDepthValidator.class);
    private GraphQlQueryOptions options;

    public OperationResponse validate(Operation operation, ValidationContext validationContext) {
        OperationResponse resp = new OperationResponse();
        if (this.options == null) {
            LOGGER.warn("No instance of the GraphQlQueryOptions has been initialized so skipping the query depth validation. Report to development.");
            return resp;
        }
        if (this.exceedsLimit((Selectable)operation, this.options.getDepthLimit())) {
            resp.addErrorMessage("depth.limit.exceeded", new Object[]{this.options.getDepthLimit()});
        }
        return resp;
    }

    private boolean exceedsLimit(Selectable operation, int limit) {
        if (limit < 0) {
            return true;
        }
        for (Selectable selection : operation.getSelections()) {
            if (!this.exceedsLimit(selection, limit - 1)) continue;
            return true;
        }
        return false;
    }

    public OperationResponse visit(Query query, ValidationContext validationContext) {
        return this.validate((Operation)query, validationContext);
    }

    public OperationResponse visit(Selection selection, ValidationContext validationContext) {
        return new OperationResponse();
    }

    public OperationResponse visit(CreateMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    public OperationResponse visit(UpdateMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    public OperationResponse visit(DeleteMutation deleteMutation, ValidationContext validationContext) {
        return this.validate((Operation)deleteMutation, validationContext);
    }

    @Inject
    public void setGraphQlQueryOptions(GraphQlQueryOptions options) {
        this.options = options;
    }
}

