/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.ontotext.metamodel.BoundServiceState;
import com.ontotext.metamodel.SomlSchemaIdManager;
import com.ontotext.metamodel.storage.ImmediateSchemaNotificationService;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.SchemaNotificationService;
import com.ontotext.metamodel.storage.SomlBindException;
import com.ontotext.metamodel.storage.SomlIdManager;
import com.ontotext.metamodel.storage.SomlNotFoundException;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorageUpdate;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.metamodel.storage.rdf4j.Rdf4JSomlSchemaStore;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaConverter;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.configuration.GraphqlOptions;
import com.ontotext.soaas.query.GraphQlSchemaConverterBuilder;
import com.ontotext.soaas.query.monitoring.QueryMeter;
import com.ontotext.soaas.query.service.QueryService;
import com.ontotext.soaas.query.service.QueryServiceBuilder;
import com.ontotext.sparql.AutoLoadingSparqlConnectionFactory;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpointConfiguration;
import graphql.schema.GraphQLSchema;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class QueryServiceManager {
    private static final Logger LOGGER = Loggers.graphqlLogger();
    private static final SomlIdManager SOML_ID_MANAGER = SomlIdManager.INSTANCE;
    public static final String DEFAULT_CACHE_CONFIG = "maximumSize=100,expireAfterAccess=4h,softValues";
    private final String repository;
    private String defaultSchemaId;
    private final Cache<String, ServiceState> services;
    private GraphqlOptions graphqlOptions;
    private SomlSchemaStorage schemaStorage;
    private final AtomicBoolean registeredListener = new AtomicBoolean(false);
    private SomlSchemaConverter<GraphQLSchema> graphqlSchemaConverter;
    private SomlSchemaConverter<ShaclSchema> shaclSchemaConverter;
    private SparqlEndpointConfiguration sparqlEndpointConfiguration;
    private SomlSchemaIdManager schemaIdManager;
    private QueryServiceBuilder serviceBuilder;
    private SparqlConnectionFactory connectionFactory;
    private SchemaNotificationService notificationService;
    private Function<String, SomlSchema> schemaBuilder;
    private Function<String, QueryMeter> queryMeterBuilder;
    private final Consumer<SomlSchemaStorageUpdate> schemaUpdateListener = this::onSchemaChanged;

    public QueryServiceManager(String repository) {
        this(repository, null);
    }

    public QueryServiceManager(String repository, String cacheConfig) {
        this.repository = repository;
        this.services = this.buildCache((CacheBuilder<Object, Object>)CacheBuilder.from((String)Objects.toString(cacheConfig, DEFAULT_CACHE_CONFIG)).removalListener(this.createRemovalListener()));
    }

    protected RemovalListener<Object, Object> createRemovalListener() {
        return notification -> {
            String cause = switch (notification.getCause()) {
                default -> throw new MatchException(null, null);
                case RemovalCause.SIZE -> "reaching maximum number of active endpoints";
                case RemovalCause.EXPIRED -> "inactivity";
                case RemovalCause.EXPLICIT -> "manual removal";
                case RemovalCause.COLLECTED -> "insufficient memory";
                case RemovalCause.REPLACED -> "being updated";
            };
            LOGGER.info("Unloaded GraphQL endpoint '{}' due to {}", notification.getKey(), (Object)cause);
        };
    }

    protected Cache<String, ServiceState> buildCache(CacheBuilder<Object, Object> builder) {
        return builder.build();
    }

    public String getRepository() {
        return this.repository;
    }

    public QueryService getDefaultService() {
        Optional<String> schemaId = this.getDefaultSchemaId();
        if (schemaId.isPresent()) {
            String reference = SOML_ID_MANAGER.somlIdToReference(schemaId.get());
            return this.getService(reference);
        }
        throw SomlBindException.somlNotBound();
    }

    @NotNull
    public QueryService getService(String schemaId) {
        try {
            return ((ServiceState)this.services.get((Object)schemaId, (Callable<ServiceState>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getService$1(java.lang.String ), ()Lcom/ontotext/soaas/query/service/QueryServiceManager$ServiceState;)((QueryServiceManager)this, (String)schemaId))).queryService;
        }
        catch (Exception ee) {
            throw QueryServiceManager.resolveException(ee);
        }
    }

    private static RuntimeException resolveException(Exception ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            cause = ex;
        }
        if (cause instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)cause;
            return re;
        }
        return new IllegalStateException(cause);
    }

    @Nullable
    public QueryService getServiceIfLoaded(String schemaId) {
        ServiceState state = (ServiceState)this.services.getIfPresent((Object)schemaId);
        return state != null ? state.queryService : null;
    }

    public Set<String> activeServices() {
        return Set.copyOf(this.services.asMap().keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadService(String id) {
        QueryServiceManager queryServiceManager = this;
        synchronized (queryServiceManager) {
            ServiceState removedService = (ServiceState)this.services.getIfPresent((Object)id);
            this.services.invalidate((Object)id);
            if (removedService != null) {
                removedService.shutdown();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAll() {
        QueryServiceManager queryServiceManager = this;
        synchronized (queryServiceManager) {
            this.services.asMap().values().forEach(ServiceState::shutdown);
            this.services.invalidateAll();
        }
    }

    protected ServiceState createService(String schemaId) {
        BoundServiceState state = this.loadSchema(schemaId);
        QueryService service = new QueryServiceBuilder(this.getServiceBuilder()).setBoundServiceState(state).buildQueryService();
        return new ServiceState(service, state);
    }

    public QueryServiceBuilder getServiceBuilder() {
        if (this.serviceBuilder == null) {
            this.serviceBuilder = new QueryServiceBuilder().setRepository(this.repository).setQueryMeter(this.createQueryMeter(this.repository));
        }
        return this.serviceBuilder;
    }

    private QueryMeter createQueryMeter(String repository) {
        if (this.queryMeterBuilder != null) {
            return this.queryMeterBuilder.apply(repository);
        }
        return null;
    }

    public void setServiceBuilder(QueryServiceBuilder serviceBuilder) {
        this.serviceBuilder = serviceBuilder;
    }

    protected BoundServiceState loadSchema(String schemaId) {
        SomlSchema schema = this.getOrCreateSchema(SOML_ID_MANAGER.referenceToSomlId(schemaId));
        try {
            GraphQLSchema graphQlSchema = (GraphQLSchema)this.getGraphqlSchemaConverter().convert(schema);
            SomlSchemaConverter<ShaclSchema> somlSchemaConverter = this.getShaclSchemaConverter();
            if (somlSchemaConverter != null) {
                ShaclSchema shaclSchema = (ShaclSchema)somlSchemaConverter.convert(schema);
                return BoundServiceState.of((SomlSchema)schema, (GraphQLSchema)graphQlSchema, (ShaclSchema)shaclSchema);
            }
            return BoundServiceState.of((SomlSchema)schema, (GraphQLSchema)graphQlSchema);
        }
        catch (SomlConversionException sce) {
            throw new InvalidSchemaException("Unable to build GraphQL model: " + sce.getMessage());
        }
    }

    protected SomlSchema getOrCreateSchema(String schemaId) {
        Optional loadedSchema;
        try {
            loadedSchema = this.getSchemaStorage().getParsed(schemaId);
        }
        catch (Exception ex) {
            LOGGER.warn("Could not load schema: {}", (Object)schemaId, (Object)ex);
            throw new PlatformConfigurationException("Could not load schema: " + schemaId, ErrorCode.SOML_STORE_UNREACHABLE);
        }
        return loadedSchema.orElseGet(() -> this.createSchema(schemaId));
    }

    private SomlSchema createSchema(String schemaId) {
        SomlSchema schema;
        if (this.schemaBuilder != null && (schema = this.schemaBuilder.apply(schemaId)) != null) {
            try {
                this.getSchemaStorage().store(new SchemaEntity(schema.toYaml()));
                return schema;
            }
            catch (SomlStoreException sse) {
                throw new PlatformConfigurationException("Unable to persist schema: " + schemaId + ". " + sse.getMessage(), ErrorCode.MISSING_SOML);
            }
        }
        throw new PlatformConfigurationException("No such schema: " + schemaId, ErrorCode.MISSING_SOML);
    }

    public Optional<String> getDefaultSchemaId() {
        if (this.defaultSchemaId == null) {
            try {
                if (this.schemaIdManager != null) {
                    String firstSchemaId;
                    if (this.schemaIdManager.getId().isEmpty() && StringUtils.isNotEmpty((CharSequence)(firstSchemaId = this.fetchFirstSchemaId()))) {
                        this.schemaIdManager.setId(this.fetchFirstSchemaId());
                    }
                    return this.schemaIdManager.getId();
                }
                this.defaultSchemaId = this.fetchFirstSchemaId();
            }
            catch (UnreachableStoreException use) {
                return Optional.empty();
            }
        }
        return Optional.ofNullable(this.defaultSchemaId);
    }

    public void setSchemaBuilder(Function<String, SomlSchema> schemaBuilder) {
        this.schemaBuilder = schemaBuilder;
    }

    public void setDefaultSchema(String id) throws SomlStoreException {
        if (id == null) {
            this.defaultSchemaId = null;
            if (this.schemaIdManager != null) {
                this.schemaIdManager.clear();
            }
        } else {
            String somlId = SOML_ID_MANAGER.referenceToSomlId(id);
            if (this.getSchemaStorage().contains(somlId)) {
                if (this.schemaIdManager != null) {
                    this.schemaIdManager.setId(somlId);
                } else {
                    this.defaultSchemaId = somlId;
                }
            } else {
                throw SomlNotFoundException.notFound((String)somlId);
            }
        }
    }

    @NotNull
    public SomlSchemaStorage getSchemaStorage() {
        if (this.schemaStorage == null) {
            this.setSchemaStorage((SomlSchemaStorage)new Rdf4JSomlSchemaStore((EndpointProvider)this.getSparqlEndpointConfiguration(), this.getConnectionFactory(), this.getNotificationService()));
        }
        return this.schemaStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchemaStorage(SomlSchemaStorage schemaStorage) {
        QueryServiceManager queryServiceManager;
        if (this.schemaStorage != null) {
            queryServiceManager = this;
            synchronized (queryServiceManager) {
                if (this.registeredListener.compareAndSet(true, false)) {
                    this.schemaStorage.unregisterListener(this.schemaUpdateListener);
                }
            }
        }
        this.schemaStorage = schemaStorage;
        queryServiceManager = this;
        synchronized (queryServiceManager) {
            if (schemaStorage != null && this.registeredListener.compareAndSet(false, true)) {
                this.schemaStorage.registerListener(this.schemaUpdateListener);
            }
        }
    }

    private void onSchemaChanged(SomlSchemaStorageUpdate schemaUpdate) {
        SomlSchemaStorageUpdate.Type type = schemaUpdate.getType();
        if ((type == SomlSchemaStorageUpdate.Type.UPDATE || type == SomlSchemaStorageUpdate.Type.DELETE) && schemaUpdate.getId() != null) {
            String id = SOML_ID_MANAGER.somlIdToReference(schemaUpdate.getId());
            this.unloadService(id);
        }
    }

    @NotNull
    public SchemaNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = new ImmediateSchemaNotificationService();
        }
        return this.notificationService;
    }

    public void setNotificationService(SchemaNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @NotNull
    public SparqlConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new AutoLoadingSparqlConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(SparqlConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @NotNull
    public SomlSchemaConverter<GraphQLSchema> getGraphqlSchemaConverter() {
        if (this.graphqlSchemaConverter == null) {
            this.graphqlSchemaConverter = this.getGraphQlSchemaConverterBuilder().buildWithoutRbac();
        }
        return this.graphqlSchemaConverter;
    }

    public void setGraphqlSchemaConverter(SomlSchemaConverter<GraphQLSchema> graphqlSchemaConverter) {
        this.graphqlSchemaConverter = graphqlSchemaConverter;
    }

    @Nullable
    public SomlSchemaConverter<ShaclSchema> getShaclSchemaConverter() {
        return this.shaclSchemaConverter;
    }

    public void setShaclSchemaConverter(SomlSchemaConverter<ShaclSchema> shaclSchemaConverter) {
        this.shaclSchemaConverter = shaclSchemaConverter;
    }

    @NotNull
    protected GraphQlSchemaConverterBuilder getGraphQlSchemaConverterBuilder() {
        return new GraphQlSchemaConverterBuilder(this.getGraphqlOptions());
    }

    @NotNull
    public SparqlEndpointConfiguration getSparqlEndpointConfiguration() {
        if (this.sparqlEndpointConfiguration == null) {
            this.sparqlEndpointConfiguration = new SparqlEndpointConfiguration();
        }
        return this.sparqlEndpointConfiguration;
    }

    public void setSparqlEndpointConfiguration(SparqlEndpointConfiguration sparqlEndpointConfiguration) {
        this.sparqlEndpointConfiguration = sparqlEndpointConfiguration;
    }

    @NotNull
    public GraphqlOptions getGraphqlOptions() {
        if (this.graphqlOptions == null) {
            this.graphqlOptions = new GraphqlOptions();
        }
        return this.graphqlOptions;
    }

    public void setGraphqlOptions(GraphqlOptions graphqlOptions) {
        this.graphqlOptions = graphqlOptions;
    }

    public SomlSchemaIdManager getSchemaIdManager() {
        return this.schemaIdManager;
    }

    public void setSchemaIdManager(SomlSchemaIdManager schemaIdManager) {
        this.schemaIdManager = schemaIdManager;
    }

    public Function<String, QueryMeter> getQueryMeterBuilder() {
        return this.queryMeterBuilder;
    }

    public void setQueryMeterBuilder(Function<String, QueryMeter> queryMeterBuilder) {
        this.queryMeterBuilder = queryMeterBuilder;
    }

    public void shutdown() {
        this.unloadAll();
        this.setSchemaStorage(null);
    }

    private String fetchFirstSchemaId() throws UnreachableStoreException {
        Collection entities = this.getSchemaStorage().getAll(0, 1, null, false, true);
        return entities.stream().map(SchemaEntity::getSchemaId).findFirst().orElse(null);
    }

    private /* synthetic */ ServiceState lambda$getService$1(String schemaId) throws Exception {
        return this.createService(schemaId);
    }

    protected record ServiceState(QueryService queryService, BoundServiceState state) {
        public void shutdown() {
            this.queryService.shutdown();
        }
    }
}

