/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import com.ontotext.graphql.compiler.BuilderTypeDecider;
import com.ontotext.graphql.compiler.DynamicQueryBuilderFactory;
import com.ontotext.graphql.compiler.QueryOptimizer;
import com.ontotext.graphql.compiler.SparqlBuilderType;
import com.ontotext.graphql.compiler.queryoptimizations.OptionalsToUnions;
import com.ontotext.graphql.parser.ConfigurableGraphQlQueryParserFactory;
import com.ontotext.graphql.parser.argument.ArgumentConverterFactory;
import com.ontotext.graphql.parser.argument.DefaultArgumentConverterFactory;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollectorManager;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.GraphQlResponder;
import com.ontotext.graphql.responder.InfoInvoker;
import com.ontotext.graphql.responder.MutationSparqlEndpointInvoker;
import com.ontotext.graphql.responder.QuerySparqlEndpointInvoker;
import com.ontotext.graphql.responder.SimpleEndpointInvoker;
import com.ontotext.metamodel.BoundServiceState;
import com.ontotext.models.Operation;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.QueryParserFactory;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.common.sparql.QueryBuilderFactory;
import com.ontotext.soaas.configuration.FederatedSparqlConfiguration;
import com.ontotext.soaas.configuration.GraphqlOptions;
import com.ontotext.soaas.configuration.SparqlOptimizations;
import com.ontotext.soaas.configuration.StorageConfiguration;
import com.ontotext.soaas.query.DynamicEndpointProvider;
import com.ontotext.soaas.query.GraphQlSchemaConverterBuilder;
import com.ontotext.soaas.query.apollo.FullGraphQlIntrospectionEndpointInvoker;
import com.ontotext.soaas.query.apollo.TemporarySchemaStorage;
import com.ontotext.soaas.query.monitoring.QueryMeter;
import com.ontotext.soaas.query.service.QueryService;
import com.ontotext.soaas.query.service.SoaasQueryService;
import com.ontotext.sparql.AutoLoadingSparqlConnectionFactory;
import com.ontotext.sparql.Rdf4jInputValueConverter;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpointConfiguration;
import com.ontotext.sparql.SparqlQueryInvoker;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String repository;
    private BoundServiceState serviceState;
    private SecurityContext securityContext;
    private GraphQlSchemaConverterBuilder graphQlSchemaConverterBuilder;
    private StatisticsCollectorManager statisticsManager;
    private DynamicEndpointProvider dynamicEndpointProvider;
    private QueryBuilderFactory<Operation> queryBuilderFactorySupplier;
    private QueryParserFactory queryParserFactory;
    private InputValueConverter inputValueConverter;
    private GraphQlResponder graphQlResponder;
    private BuilderTypeDecider builderTypeDecider;
    private ArgumentConverterFactory argumentConverterFactory;
    private SparqlConnectionFactory readOnlyConnectionFactory;
    private SparqlConnectionFactory writeableConnectionFactory;
    private QueryMeter queryMeter;
    private SparqlEndpointConfiguration sparqlEndpointConfiguration;
    private SparqlOptimizations sparqlOptimizations;
    private GraphqlOptions graphQlOptions;
    private StorageConfiguration storageConfiguration;
    private OperationBuilderOptions operationBuilderOptions;
    private FederatedSparqlConfiguration federatedSparqlConfiguration;

    public QueryServiceBuilder() {
    }

    QueryServiceBuilder(QueryServiceBuilder builder) {
        this.repository = builder.repository;
        this.serviceState = builder.serviceState;
        this.securityContext = builder.securityContext;
        this.graphQlSchemaConverterBuilder = builder.graphQlSchemaConverterBuilder;
        this.statisticsManager = builder.statisticsManager;
        this.dynamicEndpointProvider = builder.dynamicEndpointProvider;
        this.queryBuilderFactorySupplier = builder.queryBuilderFactorySupplier;
        this.queryParserFactory = builder.queryParserFactory;
        this.inputValueConverter = builder.inputValueConverter;
        this.graphQlResponder = builder.graphQlResponder;
        this.builderTypeDecider = builder.builderTypeDecider;
        this.argumentConverterFactory = builder.argumentConverterFactory;
        this.readOnlyConnectionFactory = builder.readOnlyConnectionFactory;
        this.writeableConnectionFactory = builder.writeableConnectionFactory;
        this.queryMeter = builder.queryMeter;
        this.sparqlEndpointConfiguration = builder.sparqlEndpointConfiguration;
        this.sparqlOptimizations = builder.sparqlOptimizations;
        this.graphQlOptions = builder.graphQlOptions;
        this.storageConfiguration = builder.storageConfiguration;
        this.operationBuilderOptions = builder.operationBuilderOptions;
        this.federatedSparqlConfiguration = builder.federatedSparqlConfiguration;
    }

    public QueryService buildQueryService() {
        return new SoaasQueryService(this.getGraphQlResponder(), this.getBoundServiceState(), this.getQueryBuilderFactory(), this.getDynamicEndpointResolver(), this.getQueryParserFactory(), this.getQueryMeter(), this.getGraphQlOptions(), this.getOperationBuilderOptions(), this.getSecurityContext());
    }

    public QueryParserFactory getQueryParserFactory() {
        if (this.queryParserFactory == null) {
            BoundServiceState schemaManager = this.getBoundServiceState();
            this.queryParserFactory = new ConfigurableGraphQlQueryParserFactory(() -> ((BoundServiceState)schemaManager).getSomlSchema(), () -> ((BoundServiceState)schemaManager).getGraphQlSchema(), this.getArgumentConverterFactory());
        }
        return this.queryParserFactory;
    }

    public QueryServiceBuilder setQueryParserFactory(QueryParserFactory queryParserFactory) {
        this.queryParserFactory = queryParserFactory;
        return this;
    }

    public InputValueConverter getInputValueConverter() {
        if (this.inputValueConverter == null) {
            this.inputValueConverter = new Rdf4jInputValueConverter();
        }
        return this.inputValueConverter;
    }

    public QueryServiceBuilder setInputValueConverter(InputValueConverter inputValueConverter) {
        this.inputValueConverter = inputValueConverter;
        return this;
    }

    public ArgumentConverterFactory getArgumentConverterFactory() {
        if (this.argumentConverterFactory == null) {
            this.argumentConverterFactory = new DefaultArgumentConverterFactory(this.getInputValueConverter(), this.getStatisticsManager());
        }
        return this.argumentConverterFactory;
    }

    public QueryServiceBuilder setArgumentConverterFactory(ArgumentConverterFactory argumentConverterFactory) {
        this.argumentConverterFactory = argumentConverterFactory;
        return this;
    }

    public QueryMeter getQueryMeter() {
        if (this.queryMeter == null) {
            this.queryMeter = QueryMeter.noOpMeter();
        }
        return this.queryMeter;
    }

    public QueryServiceBuilder setQueryMeter(QueryMeter queryMeter) {
        this.queryMeter = queryMeter;
        return this;
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = SecurityContext.empty();
        }
        return this.securityContext;
    }

    public QueryServiceBuilder setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    public StatisticsCollectorManager getStatisticsManager() {
        if (this.statisticsManager == null) {
            this.statisticsManager = StatisticsCollectorManager.noOp();
        }
        return this.statisticsManager;
    }

    public QueryServiceBuilder setStatisticsManager(StatisticsCollectorManager statisticsManager) {
        this.statisticsManager = statisticsManager;
        return this;
    }

    private DynamicEndpointProvider getDynamicEndpointResolver() {
        if (this.dynamicEndpointProvider == null) {
            this.dynamicEndpointProvider = new DynamicEndpointProvider((EndpointProvider)this.getSparqlEndpointConfiguration(), this.getStatisticsManager(), this.getSecurityContext());
        }
        return this.dynamicEndpointProvider;
    }

    public QueryServiceBuilder setDynamicEndpointProvider(DynamicEndpointProvider dynamicEndpointProvider) {
        this.dynamicEndpointProvider = dynamicEndpointProvider;
        return this;
    }

    QueryOptimizer queryOptimizer(SparqlOptimizations sparqlOptimizations) {
        LinkedList<OptionalsToUnions> optimizations = new LinkedList<OptionalsToUnions>();
        if (sparqlOptimizations.isOptionalToUnion()) {
            optimizations.add(new OptionalsToUnions());
        }
        return new QueryOptimizer(optimizations);
    }

    public StorageConfiguration getStorageConfiguration() {
        if (this.storageConfiguration == null) {
            this.storageConfiguration = new StorageConfiguration();
        }
        return this.storageConfiguration;
    }

    public QueryServiceBuilder setStorageConfiguration(StorageConfiguration storageConfiguration) {
        this.storageConfiguration = storageConfiguration;
        return this;
    }

    public SparqlEndpointConfiguration getSparqlEndpointConfiguration() {
        return this.sparqlEndpointConfiguration;
    }

    public QueryServiceBuilder setSparqlEndpointConfiguration(SparqlEndpointConfiguration configurations) {
        this.sparqlEndpointConfiguration = configurations;
        return this;
    }

    public FederatedSparqlConfiguration getFederatedSparqlConfiguration() {
        if (this.federatedSparqlConfiguration == null) {
            this.federatedSparqlConfiguration = new FederatedSparqlConfiguration();
        }
        return this.federatedSparqlConfiguration;
    }

    public QueryServiceBuilder setFederatedSparqlConfiguration(FederatedSparqlConfiguration federatedSparqlConfiguration) {
        this.federatedSparqlConfiguration = federatedSparqlConfiguration;
        return this;
    }

    public SparqlOptimizations getSparqlOptimizations() {
        if (this.sparqlOptimizations == null) {
            this.sparqlOptimizations = new SparqlOptimizations();
        }
        return this.sparqlOptimizations;
    }

    public QueryServiceBuilder setSparqlOptimizations(SparqlOptimizations sparqlOptimizations) {
        this.sparqlOptimizations = sparqlOptimizations;
        return this;
    }

    public OperationBuilderOptions getOperationBuilderOptions() {
        if (this.operationBuilderOptions == null) {
            SparqlOptimizations optimizations = this.getSparqlOptimizations();
            this.operationBuilderOptions = OperationBuilderOptions.custom().setMutationMode(optimizations.getMutationMode()).setFederationServices(this.getFederatedSparqlConfiguration().getServices()).setSoTypeOptimizationThreshold(optimizations.getSoTypeOptimizationThreshold()).setSingleSoTypeOptimizationEnabled(optimizations.isSingleSoTypeOptimizationEnabled()).setInThreshold(optimizations.getInThreshold()).build();
        }
        return this.operationBuilderOptions;
    }

    public QueryServiceBuilder setOperationBuilderOptions(OperationBuilderOptions operationBuilderOptions) {
        this.operationBuilderOptions = operationBuilderOptions;
        return this;
    }

    public BuilderTypeDecider getBuilderTypeFromQueryMode() {
        if (this.builderTypeDecider == null) {
            this.builderTypeDecider = operation -> SparqlBuilderType.SUBQUERY;
        }
        return this.builderTypeDecider;
    }

    public QueryServiceBuilder setBuilderTypeDecider(BuilderTypeDecider builderTypeDecider) {
        this.builderTypeDecider = builderTypeDecider;
        return this;
    }

    public QueryBuilderFactory<Operation> getQueryBuilderFactory() {
        if (this.queryBuilderFactorySupplier == null) {
            this.queryBuilderFactorySupplier = new DynamicQueryBuilderFactory(this.queryOptimizer(this.getSparqlOptimizations()), this.getBuilderTypeFromQueryMode(), this.getOperationBuilderOptions());
        }
        return this.queryBuilderFactorySupplier;
    }

    public QueryServiceBuilder setQueryBuilderFactorySupplier(QueryBuilderFactory<Operation> queryBuilderFactorySupplier) {
        this.queryBuilderFactorySupplier = queryBuilderFactorySupplier;
        return this;
    }

    public GraphQlSchemaConverterBuilder graphQlSchemaConverterBuilder() {
        if (this.graphQlSchemaConverterBuilder == null) {
            this.graphQlSchemaConverterBuilder = new GraphQlSchemaConverterBuilder(this.getGraphQlOptions());
        }
        return this.graphQlSchemaConverterBuilder;
    }

    public QueryServiceBuilder setGraphQlSchemaConverterBuilder(GraphQlSchemaConverterBuilder graphQlSchemaConverterBuilder) {
        this.graphQlSchemaConverterBuilder = graphQlSchemaConverterBuilder;
        return this;
    }

    public SparqlConnectionFactory getReadOnlyConnectionFactory() {
        if (this.readOnlyConnectionFactory == null) {
            this.readOnlyConnectionFactory = new AutoLoadingSparqlConnectionFactory();
        }
        return this.readOnlyConnectionFactory;
    }

    public QueryServiceBuilder setReadOnlyConnectionFactory(SparqlConnectionFactory readOnlyConnectionFactory) {
        this.readOnlyConnectionFactory = readOnlyConnectionFactory;
        return this;
    }

    public SparqlConnectionFactory getWriteableConnectionFactory() {
        if (this.writeableConnectionFactory == null) {
            this.writeableConnectionFactory = new AutoLoadingSparqlConnectionFactory();
        }
        return this.writeableConnectionFactory;
    }

    public QueryServiceBuilder setWriteableConnectionFactory(SparqlConnectionFactory writeableConnectionFactory) {
        this.writeableConnectionFactory = writeableConnectionFactory;
        return this;
    }

    public QueryServiceBuilder setConnectionFactory(SparqlConnectionFactory connectionFactory) {
        this.readOnlyConnectionFactory = connectionFactory;
        this.writeableConnectionFactory = connectionFactory;
        return this;
    }

    public GraphQlResponder getGraphQlResponder() {
        if (this.graphQlResponder == null) {
            TemporarySchemaStorage schemaStorage = null;
            String location = this.getStorageConfiguration().getLocation();
            if (StringUtils.isNotBlank((CharSequence)location)) {
                try {
                    schemaStorage = TemporarySchemaStorage.storeInFile(location);
                }
                catch (IOException ioe) {
                    LOGGER.warn("Configured 'storage.location: {}' must be a directory with write permissions!", (Object)location, (Object)ioe);
                }
            }
            if (schemaStorage == null) {
                schemaStorage = TemporarySchemaStorage.storeInMemory();
            }
            GraphqlOptions qlOptions = this.getGraphQlOptions();
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("nullJsonArrays", qlOptions.getResponse().getJson().isNullArrays());
            SparqlQueryInvoker sparqlQueryInvoker = this.createSparqlQueryInvoker(this.getWriteableConnectionFactory());
            this.graphQlResponder = GraphQlResponder.builder().registerInvoker((EndpointInvoker)this.createQueryInvoker()).registerInvoker((EndpointInvoker)new MutationSparqlEndpointInvoker(sparqlQueryInvoker)).registerInvoker((EndpointInvoker)new SimpleEndpointInvoker(sparqlQueryInvoker)).registerInvoker((EndpointInvoker)new FullGraphQlIntrospectionEndpointInvoker(qlOptions, this.getBoundServiceState(), this.graphQlSchemaConverterBuilder(), schemaStorage)).registerInvoker((EndpointInvoker)new InfoInvoker()).setOutputValidation(qlOptions.isEnableOutputValidations()).setTransformOptions(options).build();
        }
        return this.graphQlResponder;
    }

    @NotNull
    protected QuerySparqlEndpointInvoker createQueryInvoker() {
        return new QuerySparqlEndpointInvoker(this.createSparqlQueryInvoker(this.getReadOnlyConnectionFactory()));
    }

    @NotNull
    private SparqlQueryInvoker createSparqlQueryInvoker(SparqlConnectionFactory connectionFactory) {
        SparqlEndpointConfiguration endpointConfiguration = this.getSparqlEndpointConfiguration();
        SparqlQueryInvoker sparqlQueryInvoker = new SparqlQueryInvoker(connectionFactory);
        if (endpointConfiguration.getMaxConcurrentRequests() > 0) {
            sparqlQueryInvoker.setMaxConcurrentRequests(endpointConfiguration.getMaxConcurrentRequests());
        }
        return sparqlQueryInvoker;
    }

    public QueryServiceBuilder setGraphQlResponder(GraphQlResponder graphQlResponder) {
        this.graphQlResponder = graphQlResponder;
        return this;
    }

    public QueryServiceBuilder setBoundServiceState(BoundServiceState serviceState) {
        this.serviceState = serviceState;
        return this;
    }

    public BoundServiceState getBoundServiceState() {
        return Objects.requireNonNull(this.serviceState, BoundServiceState.class.getSimpleName() + " is required");
    }

    public QueryServiceBuilder setGraphQlOptions(GraphqlOptions graphQlOptions) {
        this.graphQlOptions = graphQlOptions;
        return this;
    }

    public GraphqlOptions getGraphQlOptions() {
        if (this.graphQlOptions == null) {
            this.graphQlOptions = new GraphqlOptions();
        }
        return this.graphQlOptions;
    }

    public String getRepository() {
        return this.repository;
    }

    QueryServiceBuilder setRepository(String repository) {
        this.repository = repository;
        return this;
    }
}

