/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.apollo;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TemporarySchemaStorage {
    public static TemporarySchemaStorage storeInMemory() {
        return new InMemoryTemporarySchemaStorage();
    }

    public static TemporarySchemaStorage storeInMemory(int compressionThreshold) {
        return new InMemoryTemporarySchemaStorage(compressionThreshold);
    }

    public static TemporarySchemaStorage storeInFile(String location) throws IOException {
        return new FileTemporarySchemaStorage(Paths.get(location, new String[0]));
    }

    public void writeSchema(String var1, String var2) throws IOException;

    public Reader readSchema(String var1) throws IOException;

    default public String readSchemaAsString(String name) throws IOException {
        try (Reader reader = this.readSchema(name);){
            if (reader == null) {
                String string = null;
                return string;
            }
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }

    public void clear();

    public static class InMemoryTemporarySchemaStorage
    implements TemporarySchemaStorage {
        private static final int DEFAULT_ZIP_THRESHOLD = 0xA00000;
        private static final String ZIP_ENTRY_NAME = "graphql.schema";
        private int zipThreshold;
        private Map<String, Object> content = new HashMap<String, Object>();

        InMemoryTemporarySchemaStorage() {
            this(0xA00000);
        }

        InMemoryTemporarySchemaStorage(int zipThreshold) {
            this.zipThreshold = zipThreshold;
        }

        @Override
        public synchronized void writeSchema(String name, String schema) throws IOException {
            block16: {
                this.clear();
                if (schema.length() > this.zipThreshold) {
                    try (ByteArrayOutputStream bytesStore = new ByteArrayOutputStream();
                         ZipOutputStream zip = new ZipOutputStream(bytesStore);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zip, StandardCharsets.UTF_8);){
                        ZipEntry entry = new ZipEntry(ZIP_ENTRY_NAME);
                        zip.putNextEntry(entry);
                        writer.write(schema);
                        writer.flush();
                        zip.closeEntry();
                        this.content.put(name, bytesStore.toByteArray());
                        break block16;
                    }
                }
                this.content.put(name, schema);
            }
        }

        @Override
        public synchronized Reader readSchema(String name) throws IOException {
            Object value = this.content.get(name);
            if (value instanceof String) {
                return new StringReader((String)value);
            }
            if (value instanceof byte[]) {
                ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream((byte[])value));
                ZipEntry entry = zipInputStream.getNextEntry();
                if (!entry.isDirectory() && ZIP_ENTRY_NAME.equals(entry.getName())) {
                    return new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8);
                }
                throw new IllegalStateException();
            }
            return null;
        }

        @Override
        public synchronized String readSchemaAsString(String name) throws IOException {
            Object value = this.content.get(name);
            if (value instanceof String) {
                return (String)value;
            }
            return TemporarySchemaStorage.super.readSchemaAsString(name);
        }

        @Override
        public synchronized void clear() {
            this.content.clear();
        }
    }

    public static class FileTemporarySchemaStorage
    implements TemporarySchemaStorage {
        private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private File storage;

        private FileTemporarySchemaStorage(Path storageFolder) throws IOException {
            File folder = storageFolder.toFile();
            if (folder.exists()) {
                if (!folder.isDirectory()) {
                    throw new IOException("Expected a directory, got " + String.valueOf(storageFolder));
                }
            } else if (folder.mkdirs()) {
                LOGGER.trace("Created new configuration folder: {}", (Object)folder);
            }
            this.storage = new File(folder, "tempSchemaStorage");
            if (!this.storage.mkdir()) {
                this.clear();
            }
        }

        @Override
        public synchronized void writeSchema(String name, String schema) throws IOException {
            try (FileOutputStream output = new FileOutputStream(this.resolveFile(name, false));){
                IOUtils.write((String)schema, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            }
        }

        private File resolveFile(String name, boolean openForRead) throws IOException {
            File file = new File(this.storage, name);
            if (!openForRead && !file.exists() && file.createNewFile()) {
                LOGGER.trace("Created new temp schema file: {}", (Object)this.storage);
            }
            return file;
        }

        @Override
        public synchronized Reader readSchema(String name) throws IOException {
            File file = this.resolveFile(name, true);
            if (file.exists()) {
                return new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), StandardCharsets.UTF_8);
            }
            return null;
        }

        @Override
        public synchronized String readSchemaAsString(String name) throws IOException {
            return TemporarySchemaStorage.super.readSchemaAsString(name);
        }

        @Override
        public synchronized void clear() {
            if (this.storage.exists()) {
                try {
                    FileUtils.cleanDirectory((File)this.storage);
                }
                catch (IOException ioe) {
                    LOGGER.error("", (Throwable)ioe);
                }
            }
        }
    }
}

