/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.apollo;

import com.ontotext.graphql.parser.ArgumentPostProcessor;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.WhereArgumentParser;
import com.ontotext.licensecheck.GraphQlExtendedFeatures;
import com.ontotext.licensecheck.LicenseCheckUtil;
import com.ontotext.models.OperationType;
import com.ontotext.models.Shape;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.Variables;
import com.ontotext.soaas.query.apollo.Utils;
import com.ontotext.sparql.Rdf4jInputValueConverter;
import graphql.language.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FederationArgumentPostProcessor
implements ArgumentPostProcessor {
    public static final String REPRESENTATIONS = "representations";
    private static final WhereArgumentParser whereParser = new WhereArgumentParser((InputValueConverter)new Rdf4jInputValueConverter());

    public void process(Arguments arguments, Field field, Shape shape, ArgumentConverter argumentConverter) {
        if (!arguments.containsKey((Object)REPRESENTATIONS) || !"_entities".equals(field.getName())) {
            return;
        }
        LicenseCheckUtil.requireGraphQlExtendedLicense((GraphQlExtendedFeatures[])new GraphQlExtendedFeatures[]{GraphQlExtendedFeatures.GRAPH_QL_FEDERATION});
        List<String> objectIds = Utils.getIds(arguments);
        if (objectIds.isEmpty()) {
            return;
        }
        Map<String, List<String>> filter = Collections.singletonMap("ID", objectIds);
        ExpressionValue parsedFilter = (ExpressionValue)whereParser.parseArgument(filter, new ArgumentParserContext(field.getName(), OperationType.QUERY, shape, arguments, null, new Variables()));
        if (arguments.getWhere().isPresent()) {
            throw new IllegalArgumentException("Unsupported Apollo federation query: query has a 'where' clause");
        }
        arguments.setWhere(parsedFilter);
    }
}

