/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query;

import com.ontotext.platform.SomlToGraphQlSchemaConverter;
import com.ontotext.script.ExpressionsDataGenerator;
import com.ontotext.soaas.configuration.GraphqlOptions;
import com.ontotext.soaas.configuration.MutationConfigurations;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class GraphQlSchemaConverterBuilder {
    private GraphqlOptions graphqlOptions;
    private Boolean enableMutations;
    private Boolean enableGeneration;
    private Boolean enableFederation;
    private Boolean enableSubscriptions;
    private Boolean enableReducedSchema;

    public GraphQlSchemaConverterBuilder(GraphqlOptions graphqlOptions) {
        this.graphqlOptions = graphqlOptions;
    }

    @NotNull
    public SomlToGraphQlSchemaConverter buildWithRbac() {
        return this.createConverter(true);
    }

    @NotNull
    public SomlToGraphQlSchemaConverter buildWithoutRbac() {
        return this.createConverter(false);
    }

    @NotNull
    private SomlToGraphQlSchemaConverter createConverter(boolean enableRbac) {
        MutationConfigurations mutationConfig = this.graphqlOptions.getMutation();
        Boolean valueGenerationEnabled = (Boolean)ObjectUtils.defaultIfNull((Object)this.enableGeneration, (Object)(mutationConfig.getGeneration().isEnabled() && mutationConfig.getGeneration().isEnabled(ExpressionsDataGenerator.class) ? 1 : 0));
        Boolean federationEnabled = (Boolean)ObjectUtils.defaultIfNull((Object)this.enableFederation, (Object)this.graphqlOptions.getFederation().isEnabled());
        Boolean mutationsEnabled = (Boolean)ObjectUtils.defaultIfNull((Object)this.enableMutations, (Object)mutationConfig.isEnabled());
        Boolean subscriptionsEnabled = (Boolean)ObjectUtils.defaultIfNull((Object)this.enableSubscriptions, (Object)this.graphqlOptions.getSubscription().isEnabled());
        Boolean reducedSchema = (Boolean)ObjectUtils.defaultIfNull((Object)this.enableReducedSchema, (Object)this.graphqlOptions.isEnableReducedSchema());
        return new SomlToGraphQlSchemaConverter(mutationsEnabled.booleanValue(), valueGenerationEnabled.booleanValue(), federationEnabled.booleanValue(), enableRbac, subscriptionsEnabled.booleanValue(), reducedSchema.booleanValue());
    }

    public GraphqlOptions getGraphqlOptions() {
        return this.graphqlOptions;
    }

    public void setEnableMutations(Boolean enableMutations) {
        this.enableMutations = enableMutations;
    }

    public void setEnableGeneration(Boolean enableGeneration) {
        this.enableGeneration = enableGeneration;
    }

    public void setEnableFederation(Boolean enableFederation) {
        this.enableFederation = enableFederation;
    }

    public void setEnableSubscriptions(Boolean enableSubscriptions) {
        this.enableSubscriptions = enableSubscriptions;
    }

    public void setEnableReducedSchema(Boolean enableReducedSchema) {
        this.enableReducedSchema = enableReducedSchema;
    }
}

