/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer;

import com.ontotext.models.PropertyShape;
import com.ontotext.rdf.transformer.SerializationError;
import com.ontotext.rdf.transformer.SerializationResponse;
import com.ontotext.rdf.transformer.ValueSerializationMode;
import com.ontotext.soaas.common.rdf.ValueReader;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public interface ValueSerializer {
    public SerializationResponse serialize(PropertyShape var1, Collection<Object> var2, ValueReader var3);

    default public ValueSerializationMode getSerializationMode() {
        return ValueSerializationMode.DEFAULT;
    }

    public static BiFunction<Integer, Object, Object> convertAndCollectErrors(String expectedType, UnaryOperator<Object> converter, Consumer<SerializationError> errorConsumer, ValueReader valueReader) {
        return (index, value) -> {
            Object result;
            try {
                Object parsedValue = valueReader.read(value);
                result = converter.apply(parsedValue);
            }
            catch (RuntimeException re) {
                String errorMessage = re.getMessage() == null ? "unknown" : re.getMessage();
                errorConsumer.accept(new SerializationError((Integer)index, value, expectedType, errorMessage));
                return null;
            }
            return result;
        };
    }
}

