/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer;

import com.ontotext.models.Operation;
import com.ontotext.soaas.common.exceptions.QueryExecutionException;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.sparql.ExecutionError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class TransformContext {
    private static final String OPERATION_REQUIRED_MSG = "Operation is required";
    private static final String RDF_DATA_REQUIRED_MSG = "RdfData is required";
    private static final String ERRORS_LIST_REQUIRED_MSG = "Errors are required";
    private final int index;
    private final Operation operation;
    private final RdfTree rdfTree;
    private final List<Serializable> errors;
    private final List<Serializable> warnings;
    private final Map<String, Object> extensions;

    public TransformContext() {
        this.operation = null;
        this.rdfTree = null;
        this.errors = Collections.emptyList();
        this.warnings = new ArrayList<Serializable>();
        this.extensions = new LinkedHashMap<String, Object>();
        this.index = 0;
    }

    public TransformContext(Operation operation, RdfTree rdfTree, Map<String, Object> extensions, int index) {
        this.operation = Objects.requireNonNull(operation, OPERATION_REQUIRED_MSG);
        this.rdfTree = Objects.requireNonNull(rdfTree, RDF_DATA_REQUIRED_MSG);
        this.errors = Collections.emptyList();
        this.warnings = new ArrayList<Serializable>();
        this.extensions = extensions;
        this.index = index;
    }

    public TransformContext(Operation operation, List<Serializable> errors, int index) {
        this.operation = Objects.requireNonNull(operation, OPERATION_REQUIRED_MSG);
        this.errors = Objects.requireNonNull(errors, ERRORS_LIST_REQUIRED_MSG);
        this.warnings = new ArrayList<Serializable>();
        this.rdfTree = null;
        this.extensions = new LinkedHashMap<String, Object>();
        this.index = index;
    }

    public TransformContext(Operation operation, RdfTree rdfTree, List<Serializable> errors, int index) {
        this.operation = Objects.requireNonNull(operation, OPERATION_REQUIRED_MSG);
        this.rdfTree = Objects.requireNonNull(rdfTree, RDF_DATA_REQUIRED_MSG);
        this.errors = Objects.requireNonNull(errors, ERRORS_LIST_REQUIRED_MSG);
        this.warnings = new ArrayList<Serializable>();
        this.extensions = new LinkedHashMap<String, Object>();
        this.index = index;
    }

    public TransformContext(List<Serializable> errors, int index) {
        this.errors = Objects.requireNonNull(errors, ERRORS_LIST_REQUIRED_MSG);
        this.warnings = new ArrayList<Serializable>();
        this.operation = null;
        this.rdfTree = null;
        this.extensions = new LinkedHashMap<String, Object>();
        this.index = index;
    }

    @Nullable
    public Operation getOperation() {
        return this.operation;
    }

    @Nullable
    public RdfTree getData() {
        return this.rdfTree;
    }

    public RdfTree getDataOrFail() {
        if (this.getErrors() == null || this.getErrors().isEmpty()) {
            return this.getData();
        }
        Serializable error = this.getErrors().get(0);
        if (error instanceof ExecutionError) {
            Throwable cause = ((ExecutionError)error).getCause();
            throw new QueryExecutionException(((ExecutionError)error).getMessage(), cause);
        }
        throw new QueryExecutionException(error.toString());
    }

    public List<Serializable> getErrors() {
        return this.errors;
    }

    public void addWarnings(List<Serializable> warnings) {
        this.warnings.addAll(warnings);
    }

    public List<Serializable> getWarnings() {
        return this.warnings;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "TransformContext{index=" + this.index + ", operation=" + (String)(this.operation == null ? "null" : this.operation.getClass().getSimpleName() + ":" + this.operation.getResponseName() + "{}") + ", rdfTree=" + (this.rdfTree == null ? "null" : "not null") + ", errors=" + String.valueOf(this.errors) + ", warnings=" + String.valueOf(this.warnings) + ", extensions=" + String.valueOf(this.extensions) + "}";
    }
}

