/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionOperations;
import it.unibz.inf.ontop.substitution.impl.ImmutableTermsSubstitutionOperations;
import it.unibz.inf.ontop.substitution.impl.InjectiveSubstitutionImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class SubstitutionImpl<T extends ImmutableTerm>
implements Substitution<T> {
    protected final TermFactory termFactory;
    protected final SubstitutionOperations<ImmutableTerm> defaultOperations;
    protected final ImmutableMap<Variable, T> map;

    public SubstitutionImpl(ImmutableMap<Variable, ? extends T> map, TermFactory termFactory, boolean checkEntries) {
        this.termFactory = termFactory;
        this.defaultOperations = new ImmutableTermsSubstitutionOperations(termFactory);
        this.map = map;
        if (checkEntries && this.map.entrySet().stream().anyMatch(e -> ((Variable)e.getKey()).equals(e.getValue()))) {
            throw new IllegalArgumentException("Please do not insert entries like t/t in your substitution (for efficiency reasons)\n. Substitution: " + this.map);
        }
    }

    protected <T extends ImmutableTerm, S extends ImmutableTerm> Substitution<S> createSubstitution(Stream<Map.Entry<Variable, T>> stream, Function<Map.Entry<Variable, T>, S> mapper, boolean checkEntries) {
        return new SubstitutionImpl<S>(stream.collect(ImmutableCollectors.toMap(Map.Entry::getKey, mapper)), this.termFactory, checkEntries);
    }

    @Override
    public Stream<Map.Entry<Variable, T>> stream() {
        return this.map.entrySet().stream();
    }

    @Override
    public boolean isDefining(Variable variable) {
        return this.map.containsKey((Object)variable);
    }

    @Override
    public ImmutableSet<Variable> getDomain() {
        return this.map.keySet();
    }

    @Override
    public boolean rangeAllMatch(Predicate<T> predicate) {
        return this.map.values().stream().allMatch(predicate);
    }

    @Override
    public boolean rangeAnyMatch(Predicate<T> predicate) {
        return this.map.values().stream().anyMatch(predicate);
    }

    @Override
    public ImmutableSet<T> getRangeSet() {
        return ImmutableSet.copyOf((Collection)this.map.values());
    }

    @Override
    public ImmutableSet<Variable> getRangeVariables() {
        return (ImmutableSet)this.map.values().stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet());
    }

    @Override
    public T get(Variable variable) {
        return (T)((ImmutableTerm)this.map.get((Object)variable));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public SubstitutionOperations<ImmutableTerm> onImmutableTerms() {
        return this.defaultOperations;
    }

    @Override
    public boolean isInjective() {
        return InjectiveSubstitutionImpl.isInjective(this.map);
    }

    @Override
    public ImmutableMap<T, Collection<Variable>> inverseMap() {
        return this.stream().collect(ImmutableCollectors.toMultimap(Map.Entry::getValue, Map.Entry::getKey)).asMap();
    }

    @Override
    public ImmutableSet<Variable> getPreImage(Predicate<T> predicate) {
        return (ImmutableSet)this.stream().filter(e -> predicate.test((ImmutableTerm)e.getValue())).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
    }

    @Override
    public Substitution<T> restrictDomainTo(Set<Variable> set) {
        return this.createSubstitution(this.stream().filter(e -> set.contains(e.getKey())), Map.Entry::getValue, false);
    }

    @Override
    public Substitution<T> removeFromDomain(Set<Variable> set) {
        return this.createSubstitution(this.stream().filter(e -> !set.contains(e.getKey())), Map.Entry::getValue, false);
    }

    @Override
    public <S extends ImmutableTerm> Substitution<S> restrictRangeTo(Class<? extends S> type) {
        return this.createSubstitution(this.stream().filter(e -> type.isInstance(e.getValue())), e -> (ImmutableTerm)type.cast(e.getValue()), false);
    }

    @Override
    public <S extends ImmutableTerm> Substitution<S> transform(Function<T, S> function) {
        return this.createSubstitution(this.stream(), e -> (ImmutableTerm)function.apply((ImmutableTerm)e.getValue()), true);
    }

    @Override
    public InjectiveSubstitution<T> injective() {
        return new InjectiveSubstitutionImpl<T>(this.map, this.termFactory, true);
    }

    @Override
    public Substitution.Builder<T, ? extends Substitution.Builder<T, ?>> builder() {
        return new BuilderImpl(this.stream(), false);
    }

    public String toString() {
        return Joiner.on((String)", ").withKeyValueSeparator("/").join(this.map);
    }

    public boolean equals(Object other) {
        if (other instanceof SubstitutionImpl) {
            return this.map.equals(((SubstitutionImpl)other).map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    protected abstract class AbstractBuilderImpl<BT extends ImmutableTerm, B extends Substitution.Builder<BT, ? extends B>>
    implements Substitution.Builder<BT, B> {
        protected final Stream<Map.Entry<Variable, BT>> stream;
        protected final boolean checkEntries;

        AbstractBuilderImpl(Stream<Map.Entry<Variable, BT>> stream, boolean checkEntries) {
            this.stream = stream;
            this.checkEntries = checkEntries;
        }

        private <S extends ImmutableTerm> BuilderImpl<S> createBasicBuilder(Stream<Map.Entry<Variable, S>> stream, boolean checkEntries) {
            return new BuilderImpl(stream, checkEntries);
        }

        protected abstract B createBuilder(Stream<Map.Entry<Variable, BT>> var1, boolean var2);

        @Override
        public B restrictDomainTo(Set<Variable> set) {
            return this.createBuilder(this.stream.filter(e -> set.contains(e.getKey())), this.checkEntries);
        }

        @Override
        public B removeFromDomain(Set<Variable> set) {
            return this.createBuilder(this.stream.filter(e -> !set.contains(e.getKey())), this.checkEntries);
        }

        @Override
        public B restrict(BiPredicate<Variable, BT> predicate) {
            return this.createBuilder(this.stream.filter(e -> predicate.test((Variable)e.getKey(), (ImmutableTerm)e.getValue())), this.checkEntries);
        }

        @Override
        public B restrictRange(Predicate<BT> predicate) {
            return this.createBuilder(this.stream.filter(e -> predicate.test((ImmutableTerm)e.getValue())), this.checkEntries);
        }

        @Override
        public <S extends ImmutableTerm> Substitution.Builder<S, ?> restrictRangeTo(Class<? extends S> type) {
            return this.createBasicBuilder(this.stream.filter(e -> type.isInstance(e.getValue())).map(e -> Maps.immutableEntry((Object)((Variable)e.getKey()), (Object)((ImmutableTerm)type.cast(e.getValue())))), this.checkEntries);
        }

        @Override
        public <U, S extends ImmutableTerm> Substitution.Builder<S, ?> transform(Function<Variable, U> lookup, BiFunction<BT, U, S> function) {
            return this.createBasicBuilder(this.stream.map(e -> Maps.immutableEntry((Object)((Variable)e.getKey()), (Object)((ImmutableTerm)function.apply((ImmutableTerm)e.getValue(), lookup.apply((Variable)e.getKey()))))), true);
        }

        @Override
        public <S extends ImmutableTerm> Substitution.Builder<S, ?> transform(Function<BT, S> function) {
            return this.createBasicBuilder(this.stream.map(e -> Maps.immutableEntry((Object)((Variable)e.getKey()), (Object)((ImmutableTerm)function.apply((ImmutableTerm)e.getValue())))), true);
        }

        @Override
        public <U> Substitution.Builder<BT, ?> transformOrRetain(Function<Variable, U> lookup, BiFunction<BT, U, BT> function) {
            return this.createBasicBuilder(this.stream.map(e -> Maps.immutableEntry((Object)((Variable)e.getKey()), (Object)Optional.ofNullable(lookup.apply((Variable)e.getKey())).map(u -> (ImmutableTerm)function.apply((ImmutableTerm)e.getValue(), u)).orElse((ImmutableTerm)e.getValue()))), true);
        }

        @Override
        public <U, S extends ImmutableTerm> Substitution.Builder<S, ?> transformOrRemove(Function<Variable, U> lookup, Function<U, S> function) {
            return this.createBasicBuilder(this.stream.flatMap(e -> Optional.ofNullable(lookup.apply((Variable)e.getKey())).map(function).map(r -> Maps.immutableEntry((Object)((Variable)e.getKey()), (Object)r)).stream()), true);
        }

        @Override
        public <U> Substitution.Builder<BT, ?> flatTransform(Function<Variable, U> lookup, Function<U, Substitution<BT>> function) {
            return this.createBasicBuilder(this.stream.flatMap(e -> Optional.ofNullable(lookup.apply((Variable)e.getKey())).map(function).map(Substitution::stream).orElseGet(() -> Stream.of(e))), true);
        }

        @Override
        public <S> Stream<S> toStream(BiFunction<Variable, BT, S> transformer) {
            return this.stream.map(e -> transformer.apply((Variable)e.getKey(), (ImmutableTerm)e.getValue()));
        }

        @Override
        public <S> ImmutableMap<Variable, S> toMap(BiFunction<Variable, BT, S> transformer) {
            return this.stream.collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> transformer.apply((Variable)e.getKey(), (ImmutableTerm)e.getValue())));
        }

        @Override
        public <S> ImmutableMap<Variable, S> toMapIgnoreOptional(BiFunction<Variable, BT, Optional<S>> transformer) {
            return this.stream.flatMap(e -> ((Optional)transformer.apply((Variable)e.getKey(), (ImmutableTerm)e.getValue())).stream().map(v -> Maps.immutableEntry((Object)((Variable)e.getKey()), (Object)v))).collect(ImmutableCollectors.toMap());
        }
    }

    protected class BuilderImpl<BT extends ImmutableTerm>
    extends AbstractBuilderImpl<BT, BuilderImpl<BT>> {
        BuilderImpl(Stream<Map.Entry<Variable, BT>> stream, boolean checkEntries) {
            super(stream, checkEntries);
        }

        @Override
        protected BuilderImpl<BT> createBuilder(Stream<Map.Entry<Variable, BT>> stream, boolean checkEntries) {
            return new BuilderImpl<BT>(stream, checkEntries);
        }

        @Override
        public Substitution<BT> build() {
            return SubstitutionImpl.this.createSubstitution(this.stream, Map.Entry::getValue, this.checkEntries);
        }
    }
}

