/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonConstantTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionBasicOperations;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.SubstitutionOperations;
import it.unibz.inf.ontop.substitution.UnifierBuilder;
import it.unibz.inf.ontop.substitution.impl.AbstractSubstitutionBasicOperations;
import it.unibz.inf.ontop.substitution.impl.AbstractSubstitutionOperations;
import it.unibz.inf.ontop.substitution.impl.AbstractUnifierBuilder;
import it.unibz.inf.ontop.substitution.impl.ImmutableTermsSubstitutionOperations;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SubstitutionFactoryImpl
implements SubstitutionFactory {
    private final TermFactory termFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final ImmutableTermsSubstitutionOperations immutableTermsSubstitutionOperations;
    private SubstitutionOperations<VariableOrGroundTerm> onVariableOrGroundTerms;

    @Inject
    private SubstitutionFactoryImpl(TermFactory termFactory, CoreUtilsFactory coreUtilsFactory) {
        this.termFactory = termFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.immutableTermsSubstitutionOperations = new ImmutableTermsSubstitutionOperations(termFactory);
    }

    <T extends ImmutableTerm> Substitution<T> createSubstitution(ImmutableMap<Variable, T> map) {
        return this.termFactory.getSubstitution(map);
    }

    @Override
    public <T extends ImmutableTerm, U, E extends Throwable> Substitution<T> getSubstitutionThrowsExceptions(Collection<U> entries, Function<U, Variable> variableProvider, SubstitutionFactory.FunctionThrowsExceptions<U, T, E> termProvider) throws E {
        ImmutableMap.Builder substitutionMapBuilder = ImmutableMap.builder();
        for (U u : entries) {
            Variable v = variableProvider.apply(u);
            ImmutableTerm t = (ImmutableTerm)termProvider.apply(u);
            substitutionMapBuilder.put((Object)v, (Object)t);
        }
        return this.createSubstitution(substitutionMapBuilder.build());
    }

    @Override
    public <T extends ImmutableTerm> Substitution<T> getSubstitution() {
        return this.createSubstitution(ImmutableMap.of());
    }

    @Override
    public <T extends ImmutableTerm> Substitution<T> getSubstitution(Variable k1, T v1) {
        return this.createSubstitution(ImmutableMap.of((Object)k1, v1));
    }

    @Override
    public <T extends ImmutableTerm> Substitution<T> getSubstitution(Variable k1, T v1, Variable k2, T v2) {
        return this.createSubstitution(ImmutableMap.of((Object)k1, v1, (Object)k2, v2));
    }

    @Override
    public <T extends ImmutableTerm> Substitution<T> getSubstitution(Variable k1, T v1, Variable k2, T v2, Variable k3, T v3) {
        return this.createSubstitution(ImmutableMap.of((Object)k1, v1, (Object)k2, v2, (Object)k3, v3));
    }

    @Override
    public <T extends ImmutableTerm> Substitution<T> getSubstitution(Variable k1, T v1, Variable k2, T v2, Variable k3, T v3, Variable k4, T v4) {
        return this.createSubstitution(ImmutableMap.of((Object)k1, v1, (Object)k2, v2, (Object)k3, v3, (Object)k4, v4));
    }

    @Override
    public <T extends ImmutableTerm> Substitution<T> getSubstitution(ImmutableList<Variable> variables, ImmutableList<? extends T> values) {
        if (variables.size() != values.size()) {
            throw new IllegalArgumentException("lists of different lengths");
        }
        return IntStream.range(0, variables.size()).mapToObj(i -> Maps.immutableEntry((Object)((Variable)variables.get(i)), (Object)((ImmutableTerm)values.get(i)))).collect(this.toSubstitutionSkippingIdentityEntries());
    }

    @Override
    public InjectiveSubstitution<Variable> extractAnInjectiveVar2VarSubstitutionFromInverseOf(Substitution<Variable> substitution) {
        return this.createSubstitution(substitution.inverseMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (Variable)((Collection)e.getValue()).iterator().next()))).injective();
    }

    @Override
    public <T extends ImmutableTerm> Substitution<T> union(Substitution<? extends T> substitution1, Substitution<? extends T> substitution2) {
        if (substitution1.isEmpty()) {
            return this.covariantCast(substitution2);
        }
        if (substitution2.isEmpty()) {
            return this.covariantCast(substitution1);
        }
        return Stream.of(substitution1, substitution2).flatMap(Substitution::stream).distinct().collect(this.toSubstitution());
    }

    @Override
    public <T extends ImmutableTerm> Substitution<T> covariantCast(Substitution<? extends T> substitution) {
        return AbstractSubstitutionOperations.covariantCast(substitution);
    }

    @Override
    public <T extends ImmutableTerm> Collector<Map.Entry<Variable, ? extends T>, ?, Substitution<T>> toSubstitution() {
        return this.toSubstitution(Map.Entry::getKey, Map.Entry::getValue);
    }

    @Override
    public <T extends ImmutableTerm, U> Collector<U, ?, Substitution<T>> toSubstitution(Function<U, Variable> variableMapper, Function<U, ? extends T> termMapper) {
        return SubstitutionFactoryImpl.getCollector(variableMapper, termMapper, ImmutableMap.Builder::put, this::createSubstitution);
    }

    @Override
    public <T extends ImmutableTerm> Collector<Map.Entry<Variable, ? extends T>, ?, Substitution<T>> toSubstitutionSkippingIdentityEntries() {
        return this.toSubstitutionSkippingIdentityEntries(Map.Entry::getKey, Map.Entry::getValue);
    }

    @Override
    public <T extends ImmutableTerm, U> Collector<U, ?, Substitution<T>> toSubstitutionSkippingIdentityEntries(Function<U, Variable> variableMapper, Function<U, ? extends T> termMapper) {
        return SubstitutionFactoryImpl.getCollector(variableMapper, termMapper, (b, v, t) -> {
            if (!v.equals(t)) {
                b.put(v, t);
            }
        }, this::createSubstitution);
    }

    @Override
    public <T extends ImmutableTerm> Collector<Variable, ?, Substitution<T>> toSubstitution(Function<Variable, ? extends T> termMapper) {
        return this.toSubstitution(v -> v, termMapper);
    }

    @Override
    public Collector<Variable, ?, InjectiveSubstitution<Variable>> toFreshRenamingSubstitution(VariableGenerator variableGenerator) {
        return SubstitutionFactoryImpl.getCollector(v -> v, variableGenerator::generateNewVariableFromVar, ImmutableMap.Builder::put, m -> this.createSubstitution((ImmutableMap)m).injective());
    }

    private static <T extends ImmutableTerm, U, R> Collector<U, ImmutableMap.Builder<Variable, T>, R> getCollector(Function<U, Variable> variableMapper, Function<U, ? extends T> termMapper, TriConsumer<ImmutableMap.Builder<Variable, T>, Variable, T> builderPutMethod, Function<ImmutableMap<Variable, T>, R> constructor) {
        return Collector.of(ImmutableMap::builder, (b, e) -> builderPutMethod.put((ImmutableMap.Builder)b, (Variable)variableMapper.apply(e), (Object)((ImmutableTerm)termMapper.apply(e))), (b1, b2) -> b1.putAll((Map)b2.build()), b -> constructor.apply(b.build()), Collector.Characteristics.UNORDERED);
    }

    @Override
    public InjectiveSubstitution<Variable> generateNotConflictingRenaming(VariableGenerator variableGenerator, ImmutableSet<Variable> variables) {
        return variables.stream().collect(this.toSubstitutionSkippingIdentityEntries(v -> v, v -> this.generateNonConflictingVariable((Variable)v, variableGenerator, variables))).injective();
    }

    private Variable generateNonConflictingVariable(Variable v, VariableGenerator variableGenerator, ImmutableSet<Variable> variables) {
        Variable proposedVariable = variableGenerator.generateNewVariableIfConflicting(v);
        if (proposedVariable.equals(v) || !variables.contains((Object)proposedVariable)) {
            return proposedVariable;
        }
        ImmutableSet knownVariables = Sets.union(variableGenerator.getKnownVariables(), variables).immutableCopy();
        VariableGenerator newVariableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection<Variable>)knownVariables);
        Variable newVariable = newVariableGenerator.generateNewVariableFromVar(v);
        variableGenerator.registerAdditionalVariables((Collection<Variable>)ImmutableSet.of((Object)newVariable));
        return newVariable;
    }

    @Override
    public InjectiveSubstitution<Variable> getPrioritizingRenaming(Substitution<?> substitution, ImmutableSet<Variable> priorityVariables) {
        Substitution<Variable> renaming = substitution.builder().restrictDomainTo((Set<Variable>)priorityVariables).restrictRangeTo(Variable.class).restrictRange(t -> !priorityVariables.contains(t)).build();
        return this.extractAnInjectiveVar2VarSubstitutionFromInverseOf(renaming);
    }

    @Override
    public SubstitutionOperations<NonFunctionalTerm> onNonFunctionalTerms() {
        return new AbstractSubstitutionOperations<NonFunctionalTerm>(this.termFactory, v -> v, s -> s){

            @Override
            public NonFunctionalTerm applyToTerm(Substitution<? extends NonFunctionalTerm> substitution, NonFunctionalTerm t) {
                return t instanceof Variable ? this.apply(substitution, (Variable)t) : t;
            }

            @Override
            public AbstractUnifierBuilder<NonFunctionalTerm> unifierBuilder(Substitution<NonFunctionalTerm> substitution) {
                return new AbstractUnifierBuilder<NonFunctionalTerm>(this.termFactory, (SubstitutionBasicOperations)this, substitution){

                    @Override
                    protected UnifierBuilder<NonFunctionalTerm> unifyUnequalTerms(NonFunctionalTerm term1, NonFunctionalTerm term2) {
                        return this.attemptUnifying(term1, term2).or(() -> this.attemptUnifying(term2, term1)).orElseGet(this::empty);
                    }
                };
            }
        };
    }

    @Override
    public SubstitutionOperations<VariableOrGroundTerm> onVariableOrGroundTerms() {
        if (this.onVariableOrGroundTerms == null) {
            this.onVariableOrGroundTerms = new AbstractSubstitutionOperations<VariableOrGroundTerm>(this.termFactory, v -> v, s -> s){

                @Override
                public VariableOrGroundTerm applyToTerm(Substitution<? extends VariableOrGroundTerm> substitution, VariableOrGroundTerm t) {
                    return t instanceof Variable ? this.apply(substitution, (Variable)t) : t;
                }

                @Override
                public AbstractUnifierBuilder<VariableOrGroundTerm> unifierBuilder(Substitution<VariableOrGroundTerm> substitution) {
                    return new AbstractUnifierBuilder<VariableOrGroundTerm>(this.termFactory, (SubstitutionBasicOperations)this, substitution){

                        @Override
                        protected UnifierBuilder<VariableOrGroundTerm> unifyUnequalTerms(VariableOrGroundTerm term1, VariableOrGroundTerm term2) {
                            return this.attemptUnifying(term1, term2).or(() -> this.attemptUnifying(term2, term1)).orElseGet(this::empty);
                        }
                    };
                }
            };
        }
        return this.onVariableOrGroundTerms;
    }

    @Override
    public SubstitutionOperations<Variable> onVariables() {
        return new AbstractSubstitutionOperations<Variable>(this.termFactory, v -> v, s -> s){

            @Override
            public Variable applyToTerm(Substitution<? extends Variable> substitution, Variable t) {
                return this.apply(substitution, t);
            }

            @Override
            public AbstractUnifierBuilder<Variable> unifierBuilder(Substitution<Variable> substitution) {
                return new AbstractUnifierBuilder<Variable>(this.termFactory, (SubstitutionBasicOperations)this, substitution){

                    @Override
                    protected UnifierBuilder<Variable> unifyUnequalTerms(Variable term1, Variable term2) {
                        return this.attemptUnifying(term1, term2).get();
                    }
                };
            }
        };
    }

    @Override
    public SubstitutionBasicOperations<NonGroundTerm> onNonGroundTerms() {
        return new AbstractSubstitutionBasicOperations<NonGroundTerm>(this.termFactory){

            @Override
            public NonGroundTerm applyToTerm(Substitution<? extends NonGroundTerm> substitution, NonGroundTerm t) {
                if (t instanceof Variable) {
                    return 4.applyToVariable(substitution, (Variable)t, v -> v);
                }
                if (t instanceof NonGroundFunctionalTerm) {
                    return (NonGroundFunctionalTerm)SubstitutionFactoryImpl.this.immutableTermsSubstitutionOperations.apply(substitution, (NonGroundFunctionalTerm)t);
                }
                throw new IllegalArgumentException("Unexpected kind of term: " + t.getClass());
            }

            @Override
            public NonGroundTerm rename(Substitution<Variable> renaming, NonGroundTerm t) {
                return this.applyToTerm(renaming, t);
            }
        };
    }

    @Override
    public SubstitutionBasicOperations<NonConstantTerm> onNonConstantTerms() {
        return new AbstractSubstitutionBasicOperations<NonConstantTerm>(this.termFactory){

            @Override
            public NonConstantTerm applyToTerm(Substitution<? extends NonConstantTerm> substitution, NonConstantTerm t) {
                if (t instanceof Variable) {
                    return 5.applyToVariable(substitution, (Variable)t, v -> v);
                }
                if (t instanceof ImmutableFunctionalTerm) {
                    return SubstitutionFactoryImpl.this.immutableTermsSubstitutionOperations.apply(substitution, (ImmutableFunctionalTerm)t);
                }
                throw new IllegalArgumentException("Unexpected kind of term: " + t.getClass());
            }

            @Override
            public NonConstantTerm rename(Substitution<Variable> renaming, NonConstantTerm t) {
                return this.applyToTerm(renaming, t);
            }
        };
    }

    @Override
    public SubstitutionOperations<ImmutableTerm> onImmutableTerms() {
        return this.immutableTermsSubstitutionOperations;
    }

    @Override
    public SubstitutionBasicOperations<NonVariableTerm> onNonVariableTerms() {
        return new AbstractSubstitutionBasicOperations<NonVariableTerm>(this.termFactory){

            @Override
            public NonVariableTerm applyToTerm(Substitution<? extends NonVariableTerm> substitution, NonVariableTerm t) {
                return this.internalApplyToTerm(substitution, t);
            }

            @Override
            public NonVariableTerm rename(Substitution<Variable> renaming, NonVariableTerm t) {
                return this.internalApplyToTerm(renaming, t);
            }

            private NonVariableTerm internalApplyToTerm(Substitution<?> renaming, NonVariableTerm t) {
                if (t instanceof Constant) {
                    return t;
                }
                if (t instanceof ImmutableFunctionalTerm) {
                    return SubstitutionFactoryImpl.this.immutableTermsSubstitutionOperations.apply(renaming, (ImmutableFunctionalTerm)t);
                }
                throw new IllegalArgumentException("Unexpected kind of term: " + t.getClass());
            }
        };
    }

    @Override
    public SubstitutionBasicOperations<ImmutableFunctionalTerm> onImmutableFunctionalTerms() {
        return new AbstractSubstitutionBasicOperations<ImmutableFunctionalTerm>(this.termFactory){

            @Override
            public ImmutableFunctionalTerm applyToTerm(Substitution<? extends ImmutableFunctionalTerm> substitution, ImmutableFunctionalTerm t) {
                return SubstitutionFactoryImpl.this.immutableTermsSubstitutionOperations.apply(substitution, t);
            }

            @Override
            public ImmutableFunctionalTerm rename(Substitution<Variable> renaming, ImmutableFunctionalTerm t) {
                return SubstitutionFactoryImpl.this.immutableTermsSubstitutionOperations.apply(renaming, t);
            }
        };
    }

    @FunctionalInterface
    private static interface TriConsumer<B, V, T> {
        public void put(B var1, V var2, T var3);
    }
}

