/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionOperations;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Substitution<T extends ImmutableTerm> {
    public Stream<Map.Entry<Variable, T>> stream();

    public boolean isDefining(Variable var1);

    public ImmutableSet<Variable> getDomain();

    public ImmutableSet<Variable> getPreImage(Predicate<T> var1);

    public ImmutableSet<T> getRangeSet();

    public ImmutableSet<Variable> getRangeVariables();

    public boolean rangeAllMatch(Predicate<T> var1);

    public boolean rangeAnyMatch(Predicate<T> var1);

    public T get(Variable var1);

    public boolean isEmpty();

    public <S extends ImmutableTerm> Substitution<S> transform(Function<T, S> var1);

    public boolean isInjective();

    public InjectiveSubstitution<T> injective();

    public SubstitutionOperations<ImmutableTerm> onImmutableTerms();

    default public ImmutableTerm apply(Variable variable) {
        return this.onImmutableTerms().apply((Substitution<ImmutableTerm>)this, variable);
    }

    default public ImmutableTerm applyToTerm(ImmutableTerm t) {
        return this.onImmutableTerms().applyToTerm(this, t);
    }

    default public ImmutableFunctionalTerm apply(ImmutableFunctionalTerm term) {
        return this.onImmutableTerms().apply((Substitution<ImmutableTerm>)this, term);
    }

    default public ImmutableExpression apply(ImmutableExpression expression) {
        return this.onImmutableTerms().apply((Substitution<ImmutableTerm>)this, expression);
    }

    default public ImmutableList<ImmutableTerm> apply(ImmutableList<? extends Variable> variables) {
        return this.onImmutableTerms().apply((Substitution<ImmutableTerm>)this, variables);
    }

    default public ImmutableSet<ImmutableTerm> apply(ImmutableSet<? extends Variable> terms) {
        return this.onImmutableTerms().apply((Substitution<ImmutableTerm>)this, terms);
    }

    default public ImmutableList<ImmutableTerm> applyToTerms(ImmutableList<? extends ImmutableTerm> terms) {
        return this.onImmutableTerms().applyToTerms((Substitution<ImmutableTerm>)this, terms);
    }

    default public ImmutableMap<Integer, ImmutableTerm> applyToTerms(ImmutableMap<Integer, ? extends ImmutableTerm> argumentMap) {
        return this.onImmutableTerms().applyToTerms((Substitution<ImmutableTerm>)this, argumentMap);
    }

    default public Substitution<ImmutableTerm> compose(Substitution<? extends ImmutableTerm> f) {
        return this.onImmutableTerms().compose(this, f);
    }

    public Substitution<T> restrictDomainTo(Set<Variable> var1);

    public Substitution<T> removeFromDomain(Set<Variable> var1);

    public <S extends ImmutableTerm> Substitution<S> restrictRangeTo(Class<? extends S> var1);

    public ImmutableMap<T, Collection<Variable>> inverseMap();

    public Builder<T, ? extends Builder<T, ?>> builder();

    public static interface Builder<T extends ImmutableTerm, B extends Builder<T, ? extends B>> {
        public Substitution<T> build();

        public B restrictDomainTo(Set<Variable> var1);

        public B removeFromDomain(Set<Variable> var1);

        public B restrict(BiPredicate<Variable, T> var1);

        public B restrictRange(Predicate<T> var1);

        public <S extends ImmutableTerm> Builder<S, ?> restrictRangeTo(Class<? extends S> var1);

        public <S extends ImmutableTerm> Builder<S, ?> transform(Function<T, S> var1);

        public <U, S extends ImmutableTerm> Builder<S, ?> transform(Function<Variable, U> var1, BiFunction<T, U, S> var2);

        public <U> Builder<T, ?> transformOrRetain(Function<Variable, U> var1, BiFunction<T, U, T> var2);

        public <U, S extends ImmutableTerm> Builder<S, ?> transformOrRemove(Function<Variable, U> var1, Function<U, S> var2);

        public <U> Builder<T, ?> flatTransform(Function<Variable, U> var1, Function<U, Substitution<T>> var2);

        public <S> Stream<S> toStream(BiFunction<Variable, T, S> var1);

        public <S> ImmutableMap<Variable, S> toMap(BiFunction<Variable, T, S> var1);

        public <S> ImmutableMap<Variable, S> toMapIgnoreOptional(BiFunction<Variable, T, Optional<S>> var1);
    }
}

