/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.impl.TermTypeAncestryImpl;
import java.util.Optional;

public class TermTypeImpl
implements TermType {
    private final TermTypeAncestry ancestry;
    private final boolean isAbstract;
    private final String name;

    protected TermTypeImpl(String name, TermTypeAncestry parentAncestry, boolean isAbstract) {
        this.name = name;
        this.isAbstract = isAbstract;
        this.ancestry = parentAncestry.newAncestry(this);
    }

    private TermTypeImpl() {
        this.name = "Origin";
        this.isAbstract = true;
        this.ancestry = new TermTypeAncestryImpl(this);
    }

    static TermType createOriginTermType() {
        return new TermTypeImpl();
    }

    @Override
    public final boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isA(TermType moreGeneralType) {
        TermType commonDenominator = this.getCommonDenominator(moreGeneralType);
        return moreGeneralType.equals(commonDenominator);
    }

    @Override
    public TermType getCommonDenominator(TermType otherTermType) {
        if (this.equals(otherTermType)) {
            return this;
        }
        if (this.ancestry.contains(otherTermType)) {
            return otherTermType;
        }
        TermTypeAncestry otherAncestry = otherTermType.getAncestry();
        if (otherAncestry.contains(this)) {
            return this;
        }
        return this.ancestry.getClosestCommonAncestor(otherAncestry);
    }

    @Override
    public TermTypeAncestry getAncestry() {
        return this.ancestry;
    }

    public boolean equals(Object other) {
        return Optional.ofNullable(other).filter(o -> o instanceof TermType).map(o -> (TermType)o).filter(o -> o.toString().equals(this.toString())).isPresent();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

