/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.impl.AbstractNonFunctionalTerm;
import java.util.Objects;
import java.util.stream.Stream;

public class VariableImpl
extends AbstractNonFunctionalTerm
implements Variable,
Comparable<Variable> {
    private final String name;

    protected VariableImpl(String name) {
        Objects.requireNonNull(name, "Variable name cannot be null");
        this.name = name;
    }

    public boolean equals(Object other) {
        return other instanceof VariableImpl && this.name.equals(((VariableImpl)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isGround() {
        return false;
    }

    @Override
    public Stream<Variable> getVariableStream() {
        return Stream.of(this);
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableTerm otherTerm, VariableNullability variableNullability) {
        if (otherTerm instanceof Variable) {
            return this.equals(otherTerm) ? IncrementalEvaluation.declareIsTrue() : IncrementalEvaluation.declareSameExpression();
        }
        if (otherTerm instanceof ImmutableFunctionalTerm) {
            return otherTerm.evaluateStrictEq(this, variableNullability);
        }
        return otherTerm.isNull() ? IncrementalEvaluation.declareIsNull() : IncrementalEvaluation.declareSameExpression();
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(VariableNullability variableNullability) {
        return variableNullability.isPossiblyNullable(this) ? IncrementalEvaluation.declareSameExpression() : IncrementalEvaluation.declareIsTrue();
    }

    @Override
    public boolean isNullable(ImmutableSet<Variable> nullableVariables) {
        return nullableVariables.contains((Object)this);
    }

    @Override
    public int compareTo(Variable other) {
        return this.name.compareTo(other.getName());
    }
}

